/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.alfresco.cmis.CMISResultSet;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.lucene.SolrJSONResultSet;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionCheckCollection;
import org.alfresco.repo.security.permissions.PermissionCheckValue;
import org.alfresco.repo.security.permissions.PermissionCheckedCollection;
import org.alfresco.repo.security.permissions.PermissionCheckedValue;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ACLEntryAfterInvocationProvider
implements AfterInvocationProvider,
InitializingBean {
    private static Log log = LogFactory.getLog(ACLEntryAfterInvocationProvider.class);
    private static final String AFTER_ACL_NODE = "AFTER_ACL_NODE";
    private static final String AFTER_ACL_PARENT = "AFTER_ACL_PARENT";
    private PermissionService permissionService;
    private NamespacePrefixResolver nspr;
    private NodeService nodeService;
    private int maxPermissionChecks;
    private long maxPermissionCheckTimeMillis;
    private Set<QName> unfilteredForClassQNames = new HashSet<QName>();
    private Set<String> unfilteredFor = null;
    private boolean optimisePermissionsCheck;
    private int optimisePermissionsBulkFetchSize;

    public ACLEntryAfterInvocationProvider() {
        this.maxPermissionChecks = Integer.MAX_VALUE;
        this.maxPermissionCheckTimeMillis = Long.MAX_VALUE;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.nspr;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver nspr) {
        this.nspr = nspr;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        log.warn((Object)"Bean property 'authenticationService' no longer required.");
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public void setUnfilteredFor(Set<String> unfilteredFor) {
        this.unfilteredFor = unfilteredFor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.permissionService == null) {
            throw new IllegalArgumentException("There must be a permission service");
        }
        if (this.nspr == null) {
            throw new IllegalArgumentException("There must be a namespace service");
        }
        if (this.nodeService == null) {
            throw new IllegalArgumentException("There must be a node service");
        }
        if (this.unfilteredFor != null) {
            for (String qnameString : this.unfilteredFor) {
                QName qname = QName.resolveToQName((NamespacePrefixResolver)this.nspr, (String)qnameString);
                this.unfilteredForClassQNames.add(qname);
            }
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        if (log.isDebugEnabled() && object instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)object;
            log.debug((Object)("Method: " + mi.getMethod().toString()));
        }
        try {
            if (AuthenticationUtil.isRunAsUserTheSystemUser()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Allowing system user access");
                }
                return returnedObject;
            }
            if (returnedObject == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Allowing null object access");
                }
                return null;
            }
            if (PermissionCheckedValue.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (PermissionCheckedValue)returnedObject);
            }
            if (PermissionCheckValue.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (PermissionCheckValue)returnedObject);
            }
            if (StoreRef.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, this.nodeService.getRootNode((StoreRef)returnedObject)).getStoreRef();
            }
            if (NodeRef.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (NodeRef)returnedObject);
            }
            if (Pair.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (Pair)returnedObject);
            }
            if (ChildAssociationRef.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (ChildAssociationRef)returnedObject);
            }
            if (SolrJSONResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                return returnedObject;
            }
            if (CMISResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                return returnedObject;
            }
            if (PagingLuceneResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (PagingLuceneResultSet)returnedObject);
            }
            if (ResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (ResultSet)returnedObject);
            }
            if (QueryEngineResults.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (QueryEngineResults)returnedObject);
            }
            if (Collection.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (Collection)returnedObject);
            }
            if (returnedObject.getClass().isArray()) {
                return this.decide(authentication, object, config, (Object[])returnedObject);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Uncontrolled object - access allowed for " + object.getClass().getName()));
            }
            return returnedObject;
        }
        catch (AccessDeniedException ade) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access denied");
                ade.printStackTrace();
            }
            throw ade;
        }
        catch (RuntimeException re) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access denied by runtime exception");
                re.printStackTrace();
            }
            throw re;
        }
    }

    private NodeRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, NodeRef returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        if (this.isUnfiltered(returnedObject)) {
            return returnedObject;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            NodeRef testNodeRef = null;
            if (cad.typeString.equals(AFTER_ACL_NODE)) {
                testNodeRef = returnedObject;
            } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                testNodeRef = this.nodeService.getPrimaryParent(returnedObject).getParentRef();
            }
            if (testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
            throw new AccessDeniedException("Access Denied");
        }
        return returnedObject;
    }

    private boolean isUnfiltered(NodeRef returnedObject) {
        if (returnedObject == null || !this.nodeService.exists(returnedObject)) {
            return true;
        }
        if (this.unfilteredForClassQNames.size() > 0) {
            QName typeQName = this.nodeService.getType(returnedObject);
            if (this.unfilteredForClassQNames.contains(typeQName)) {
                return true;
            }
            Set aspectQNames = this.nodeService.getAspects(returnedObject);
            for (QName abstain : this.unfilteredForClassQNames) {
                if (!aspectQNames.contains(abstain)) continue;
                return true;
            }
        }
        return false;
    }

    private PermissionCheckedValue decide(Authentication authentication, Object object, ConfigAttributeDefinition config, PermissionCheckedValue returnedObject) throws AccessDeniedException {
        return returnedObject;
    }

    private PermissionCheckValue decide(Authentication authentication, Object object, ConfigAttributeDefinition config, PermissionCheckValue returnedObject) throws AccessDeniedException {
        NodeRef nodeRef = returnedObject.getNodeRef();
        this.decide(authentication, object, config, nodeRef);
        return returnedObject;
    }

    private Pair decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Pair returnedObject) throws AccessDeniedException {
        NodeRef nodeRef = (NodeRef)returnedObject.getSecond();
        this.decide(authentication, object, config, nodeRef);
        return returnedObject;
    }

    private List<ConfigAttributeDefintion> extractSupportedDefinitions(ConfigAttributeDefinition config) {
        ArrayList<ConfigAttributeDefintion> definitions = new ArrayList<ConfigAttributeDefintion>();
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            definitions.add(new ConfigAttributeDefintion(attr));
        }
        return definitions;
    }

    private ChildAssociationRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, ChildAssociationRef returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            NodeRef testNodeRef = null;
            if (cad.typeString.equals(AFTER_ACL_NODE)) {
                testNodeRef = returnedObject.getChildRef();
            } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                testNodeRef = returnedObject.getParentRef();
            }
            if (this.isUnfiltered(testNodeRef) || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
            throw new AccessDeniedException("Access Denied");
        }
        return returnedObject;
    }

    private ResultSet decide(Authentication authentication, Object object, ConfigAttributeDefinition config, PagingLuceneResultSet returnedObject) throws AccessDeniedException {
        ResultSet raw = returnedObject.getWrapped();
        ResultSet filteredForPermissions = this.decide(authentication, object, config, raw);
        PagingLuceneResultSet newPaging = new PagingLuceneResultSet(filteredForPermissions, returnedObject.getResultSetMetaData().getSearchParameters(), this.nodeService);
        return newPaging;
    }

    public void setOptimisePermissionsCheck(boolean optimisePermissionsCheck) {
        this.optimisePermissionsCheck = optimisePermissionsCheck;
    }

    public void setOptimisePermissionsBulkFetchSize(int optimisePermissionsBulkFetchSize) {
        this.optimisePermissionsBulkFetchSize = optimisePermissionsBulkFetchSize;
    }

    private ResultSet decide(Authentication authentication, Object object, ConfigAttributeDefinition config, ResultSet returnedObject) throws AccessDeniedException {
        ResultSet rs = this.optimisePermissionsCheck ? this.decideNew(authentication, object, config, returnedObject) : this.decideOld(authentication, object, config, returnedObject);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet decideNew(Authentication authentication, Object object, ConfigAttributeDefinition config, ResultSet returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        FilteringResultSet filteringResultSet = new FilteringResultSet(returnedObject);
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        Integer maxSize = null;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxItems() >= 0) {
            maxSize = new Integer(returnedObject.getResultSetMetaData().getSearchParameters().getMaxItems());
        }
        if (maxSize == null && returnedObject.getResultSetMetaData().getSearchParameters().getLimitBy() == LimitBy.FINAL_SIZE) {
            maxSize = new Integer(returnedObject.getResultSetMetaData().getSearchParameters().getLimit());
        }
        if (maxSize != null && returnedObject.getResultSetMetaData().getSearchParameters().getSkipCount() >= 0) {
            maxSize = new Integer(maxSize + returnedObject.getResultSetMetaData().getSearchParameters().getSkipCount());
        }
        int maxChecks = this.maxPermissionChecks;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionChecks() >= 0) {
            maxChecks = returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionChecks();
        }
        long maxCheckTime = this.maxPermissionCheckTimeMillis;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionCheckTimeMillis() >= 0L) {
            maxCheckTime = returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionCheckTimeMillis();
        }
        if (supportedDefinitions.size() == 0) {
            int i;
            if (maxSize == null) {
                return returnedObject;
            }
            if (returnedObject.length() > maxSize) {
                for (i = 0; i < maxSize; ++i) {
                    filteringResultSet.setIncluded(i, true);
                }
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            } else {
                for (i = 0; i < maxSize; ++i) {
                    filteringResultSet.setIncluded(i, true);
                }
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            }
        }
        if (returnedObject.length() > 0) {
            boolean builkFetch = returnedObject.getBulkFetch();
            returnedObject.setBulkFetch(false);
            returnedObject.getNodeRef(returnedObject.length() - 1);
            returnedObject.setBulkFetch(builkFetch);
        }
        long startTimeMillis = System.currentTimeMillis();
        filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
        boolean oldBulkFetch = returnedObject.setBulkFetch(true);
        int oldFetchSize = returnedObject.setBulkFetchSize(this.optimisePermissionsBulkFetchSize);
        try {
            for (int i = 0; i < returnedObject.length(); ++i) {
                long currentTimeMillis = System.currentTimeMillis();
                if (i >= maxChecks) {
                    log.warn((Object)("maxChecks exceeded (" + maxChecks + ")"), (Throwable)new Exception("Back Trace"));
                    filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                } else if (currentTimeMillis - startTimeMillis > maxCheckTime) {
                    log.warn((Object)("maxCheckTime exceeded (" + (currentTimeMillis - startTimeMillis) + " milliseconds)"), (Throwable)new Exception("Back Trace"));
                    filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                } else {
                    filteringResultSet.setIncluded(i, true);
                    NodeRef nodeRef = returnedObject.getNodeRef(i);
                    if (filteringResultSet.getIncluded(i) && this.permissionService.hasReadPermission(nodeRef) == AccessStatus.DENIED) {
                        filteringResultSet.setIncluded(i, false);
                    }
                    if (maxSize == null || filteringResultSet.length() <= maxSize) continue;
                    filteringResultSet.setIncluded(i, false);
                    filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                }
                break;
            }
        }
        finally {
            returnedObject.setBulkFetch(oldBulkFetch);
            returnedObject.setBulkFetchSize(oldFetchSize);
        }
        return filteringResultSet;
    }

    private ResultSet decideOld(Authentication authentication, Object object, ConfigAttributeDefinition config, ResultSet returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        FilteringResultSet filteringResultSet = new FilteringResultSet(returnedObject);
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        Integer maxSize = null;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxItems() >= 0) {
            maxSize = new Integer(returnedObject.getResultSetMetaData().getSearchParameters().getMaxItems());
        }
        if (maxSize == null && returnedObject.getResultSetMetaData().getSearchParameters().getLimitBy() == LimitBy.FINAL_SIZE) {
            maxSize = new Integer(returnedObject.getResultSetMetaData().getSearchParameters().getLimit());
        }
        if (maxSize != null && returnedObject.getResultSetMetaData().getSearchParameters().getSkipCount() >= 0) {
            maxSize = new Integer(maxSize + returnedObject.getResultSetMetaData().getSearchParameters().getSkipCount());
        }
        int maxChecks = this.maxPermissionChecks;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionChecks() >= 0) {
            maxChecks = returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionChecks();
        }
        long maxCheckTime = this.maxPermissionCheckTimeMillis;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionCheckTimeMillis() >= 0L) {
            maxCheckTime = returnedObject.getResultSetMetaData().getSearchParameters().getMaxPermissionCheckTimeMillis();
        }
        if (supportedDefinitions.size() == 0) {
            if (maxSize == null) {
                return returnedObject;
            }
            if (returnedObject.length() > maxSize) {
                for (int i = 0; i < maxSize; ++i) {
                    filteringResultSet.setIncluded(i, true);
                }
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                return filteringResultSet;
            }
            for (int i = 0; i < returnedObject.length(); ++i) {
                filteringResultSet.setIncluded(i, true);
            }
            filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(returnedObject.getResultSetMetaData().getLimitedBy(), PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            return filteringResultSet;
        }
        if (returnedObject.length() > 0) {
            boolean builkFetch = returnedObject.getBulkFetch();
            returnedObject.setBulkFetch(false);
            returnedObject.getNodeRef(returnedObject.length() - 1);
            returnedObject.setBulkFetch(builkFetch);
        }
        long startTimeMillis = System.currentTimeMillis();
        filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(returnedObject.getResultSetMetaData().getLimitedBy(), PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
        for (int i = 0; i < returnedObject.length(); ++i) {
            long currentTimeMillis = System.currentTimeMillis();
            if (i >= maxChecks) {
                log.warn((Object)("maxChecks exceeded (" + maxChecks + ")"), (Throwable)new Exception("Back Trace"));
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                break;
            }
            if (currentTimeMillis - startTimeMillis > maxCheckTime) {
                log.warn((Object)("maxCheckTime exceeded (" + (currentTimeMillis - startTimeMillis) + " milliseconds)"), (Throwable)new Exception("Back Trace"));
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.NUMBER_OF_PERMISSION_EVALUATIONS, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
                break;
            }
            filteringResultSet.setIncluded(i, true);
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(AFTER_ACL_NODE)) {
                    testNodeRef = returnedObject.getNodeRef(i);
                } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                    testNodeRef = returnedObject.getChildAssocRef(i).getParentRef();
                }
                if (this.isUnfiltered(testNodeRef) || !filteringResultSet.getIncluded(i) || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
                filteringResultSet.setIncluded(i, false);
            }
            if (maxSize == null || filteringResultSet.length() <= maxSize) continue;
            filteringResultSet.setIncluded(i, false);
            filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            break;
        }
        return filteringResultSet;
    }

    private QueryEngineResults decide(Authentication authentication, Object object, ConfigAttributeDefinition config, QueryEngineResults returnedObject) throws AccessDeniedException {
        Map map = returnedObject.getResults();
        HashMap<Set, ResultSet> answer = new HashMap<Set, ResultSet>(map.size(), 1.0f);
        for (Set group : map.keySet()) {
            ResultSet raw = (ResultSet)map.get(group);
            ResultSet permed = PagingLuceneResultSet.class.isAssignableFrom(raw.getClass()) ? this.decide(authentication, object, config, (PagingLuceneResultSet)raw) : this.decide(authentication, object, config, raw);
            answer.put(group, permed);
        }
        return new QueryEngineResults(answer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Collection returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entries are " + supportedDefinitions));
        }
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        long targetResultCount = returnedObject.size();
        int maxPermissionChecks = Integer.MAX_VALUE;
        long maxPermissionCheckTimeMillis = this.maxPermissionCheckTimeMillis;
        if (returnedObject instanceof PermissionCheckCollection) {
            PermissionCheckCollection permissionCheckCollection = (PermissionCheckCollection)((Object)returnedObject);
            targetResultCount = permissionCheckCollection.getTargetResultCount();
            if (permissionCheckCollection.getCutOffAfterCount() > 0) {
                maxPermissionChecks = permissionCheckCollection.getCutOffAfterCount();
            }
            if (permissionCheckCollection.getCutOffAfterTimeMs() > 0L) {
                maxPermissionCheckTimeMillis = permissionCheckCollection.getCutOffAfterTimeMs();
            }
        }
        boolean cutoff = false;
        long startTimeMillis = System.currentTimeMillis();
        int count = 0;
        ArrayList keepValues = new ArrayList(returnedObject.size());
        for (Object nextObject : returnedObject) {
            long currentTimeMillis = System.currentTimeMillis();
            if ((long)keepValues.size() >= targetResultCount) break;
            if (count >= maxPermissionChecks) {
                cutoff = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("decide (collection) cut-off: " + count + " checks exceeded " + maxPermissionChecks + " checks"));
                break;
            }
            if (currentTimeMillis - startTimeMillis > maxPermissionCheckTimeMillis) {
                cutoff = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("decide (collection) cut-off: " + (currentTimeMillis - startTimeMillis) + "ms exceeded " + maxPermissionCheckTimeMillis + "ms"));
                break;
            }
            boolean allowed = true;
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(AFTER_ACL_NODE)) {
                    if (StoreRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = this.nodeService.getRootNode((StoreRef)nextObject);
                    } else if (NodeRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = (NodeRef)nextObject;
                    } else if (ChildAssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = ((ChildAssociationRef)nextObject).getChildRef();
                    } else if (Pair.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = (NodeRef)((Pair)nextObject).getSecond();
                    } else {
                        if (!PermissionCheckValue.class.isAssignableFrom(nextObject.getClass())) throw new ACLEntryVoterException("The specified parameter is not recognized: " + nextObject.getClass());
                        testNodeRef = ((PermissionCheckValue)nextObject).getNodeRef();
                    }
                } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                    if (StoreRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = null;
                    } else if (NodeRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = this.nodeService.getPrimaryParent((NodeRef)nextObject).getParentRef();
                    } else if (ChildAssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = ((ChildAssociationRef)nextObject).getParentRef();
                    } else if (Pair.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = (NodeRef)((Pair)nextObject).getSecond();
                    } else {
                        if (!PermissionCheckValue.class.isAssignableFrom(nextObject.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + nextObject.getClass());
                        NodeRef nodeRef = ((PermissionCheckValue)nextObject).getNodeRef();
                        testNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\t" + cad.typeString + " test on " + testNodeRef + " from " + nextObject.getClass().getName()));
                }
                if (this.isUnfiltered(testNodeRef) || !allowed || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
                allowed = false;
                break;
            }
            ++count;
            if (!allowed) continue;
            keepValues.add(nextObject);
        }
        int sizeOriginal = returnedObject.size();
        int checksRemaining = sizeOriginal - count;
        if (keepValues.size() >= sizeOriginal) return PermissionCheckedCollection.PermissionCheckedCollectionMixin.create(returnedObject, cutoff, checksRemaining, sizeOriginal);
        try {
            returnedObject.clear();
            returnedObject.addAll(keepValues);
            return PermissionCheckedCollection.PermissionCheckedCollectionMixin.create(returnedObject, cutoff, checksRemaining, sizeOriginal);
        }
        catch (UnsupportedOperationException e) {
            throw new AccessDeniedException("Permission-checked list must be modifiable", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object[] returnedObject) throws AccessDeniedException {
        BitSet incudedSet = new BitSet(returnedObject.length);
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        int l = returnedObject.length;
        for (int i = 0; i < l; ++i) {
            Object current = returnedObject[i];
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                incudedSet.set(i, true);
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(AFTER_ACL_NODE)) {
                    if (StoreRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = this.nodeService.getRootNode((StoreRef)current);
                    } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = (NodeRef)current;
                    } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = ((ChildAssociationRef)current).getChildRef();
                    } else if (Pair.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = (NodeRef)((Pair)current).getSecond();
                    } else {
                        if (!PermissionCheckValue.class.isAssignableFrom(current.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + current.getClass());
                        testNodeRef = ((PermissionCheckValue)current).getNodeRef();
                    }
                } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                    if (StoreRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = null;
                    } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = this.nodeService.getPrimaryParent((NodeRef)current).getParentRef();
                    } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = ((ChildAssociationRef)current).getParentRef();
                    } else if (Pair.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = (NodeRef)((Pair)current).getSecond();
                    } else {
                        if (!PermissionCheckValue.class.isAssignableFrom(current.getClass())) throw new ACLEntryVoterException("The specified parameter is recognized: " + current.getClass());
                        NodeRef nodeRef = ((PermissionCheckValue)current).getNodeRef();
                        testNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\t" + cad.typeString + " test on " + testNodeRef + " from " + current.getClass().getName()));
                }
                if (this.isUnfiltered(testNodeRef) || !incudedSet.get(i) || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
                incudedSet.set(i, false);
            }
        }
        if (incudedSet.cardinality() == returnedObject.length) {
            return returnedObject;
        }
        Object[] answer = new Object[incudedSet.cardinality()];
        int i = incudedSet.nextSetBit(0);
        int p = 0;
        while (i >= 0) {
            answer[p] = returnedObject[i];
            ++i;
            i = incudedSet.nextSetBit(i);
            ++p;
        }
        return answer;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && (attribute.getAttribute().startsWith(AFTER_ACL_NODE) || attribute.getAttribute().startsWith(AFTER_ACL_PARENT));
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    private class ConfigAttributeDefintion {
        String typeString;
        SimplePermissionReference required;

        ConfigAttributeDefintion(ConfigAttribute attr) {
            StringTokenizer st = new StringTokenizer(attr.getAttribute(), ".", false);
            if (st.countTokens() != 3) {
                throw new ACLEntryVoterException("There must be three . separated tokens in each config attribute");
            }
            this.typeString = st.nextToken();
            String qNameString = st.nextToken();
            String permissionString = st.nextToken();
            if (!this.typeString.equals(ACLEntryAfterInvocationProvider.AFTER_ACL_NODE) && !this.typeString.equals(ACLEntryAfterInvocationProvider.AFTER_ACL_PARENT)) {
                throw new ACLEntryVoterException("Invalid type: must be ACL_NODE or ACL_PARENT");
            }
            QName qName = QName.createQName((String)qNameString, (NamespacePrefixResolver)ACLEntryAfterInvocationProvider.this.nspr);
            this.required = SimplePermissionReference.getPermissionReference(qName, permissionString);
        }
    }
}

