/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.alfresco.repo.search.ResultSetRowIterator;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryAfterInvocationProvider;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.util.Pair;

public class FilteringResultSet
extends ACLEntryAfterInvocationProvider
implements ResultSet {
    private ResultSet unfiltered;
    private BitSet inclusionMask;
    private ResultSetMetaData resultSetMetaData;

    public FilteringResultSet(ResultSet unfiltered) {
        this.unfiltered = unfiltered;
        this.inclusionMask = new BitSet(unfiltered.length());
    }

    public FilteringResultSet(ResultSet unfiltered, BitSet inclusionMask) {
        this.unfiltered = unfiltered;
        this.inclusionMask = inclusionMask;
    }

    ResultSet getUnFilteredResultSet() {
        return this.unfiltered;
    }

    void setIncluded(int i, boolean excluded) {
        this.inclusionMask.set(i, excluded);
    }

    boolean getIncluded(int i) {
        return this.inclusionMask.get(i);
    }

    public int length() {
        return this.inclusionMask.cardinality();
    }

    private int translateIndex(int n) {
        if (n > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int count = -1;
        int l = this.unfiltered.length();
        for (int i = 0; i < l; ++i) {
            if (this.inclusionMask.get(i)) {
                ++count;
            }
            if (count != n) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    public NodeRef getNodeRef(int n) {
        return this.unfiltered.getNodeRef(this.translateIndex(n));
    }

    public float getScore(int n) {
        return this.unfiltered.getScore(this.translateIndex(n));
    }

    public void close() {
        this.unfiltered.close();
    }

    public ResultSetRow getRow(int i) {
        return this.unfiltered.getRow(this.translateIndex(i));
    }

    public List<NodeRef> getNodeRefs() {
        ArrayList<NodeRef> answer = new ArrayList<NodeRef>(this.length());
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = (ResultSetRow)i$.next();
            answer.add(row.getNodeRef());
        }
        return answer;
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> answer = new ArrayList<ChildAssociationRef>(this.length());
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = (ResultSetRow)i$.next();
            answer.add(row.getChildAssocRef());
        }
        return answer;
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        return this.unfiltered.getChildAssocRef(this.translateIndex(n));
    }

    public ListIterator<ResultSetRow> iterator() {
        return new FilteringIterator();
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public void setResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    public int getStart() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMore() {
        throw new UnsupportedOperationException();
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return this.unfiltered.setBulkFetch(bulkFetch);
    }

    public boolean getBulkFetch() {
        return this.unfiltered.getBulkFetch();
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return this.unfiltered.setBulkFetchSize(bulkFetchSize);
    }

    public int getBulkFetchSize() {
        return this.unfiltered.getBulkFetchSize();
    }

    public List<Pair<String, Integer>> getFieldFacet(String field) {
        return this.unfiltered.getFieldFacet(field);
    }

    class FilteringIterator
    implements ResultSetRowIterator {
        int underlyingPosition = -1;

        FilteringIterator() {
        }

        @Override
        public boolean hasNext() {
            return FilteringResultSet.this.inclusionMask.nextSetBit(this.underlyingPosition + 1) != -1;
        }

        @Override
        public ResultSetRow next() {
            this.underlyingPosition = FilteringResultSet.this.inclusionMask.nextSetBit(this.underlyingPosition + 1);
            if (this.underlyingPosition == -1) {
                throw new IllegalStateException();
            }
            return FilteringResultSet.this.unfiltered.getRow(this.underlyingPosition);
        }

        @Override
        public boolean hasPrevious() {
            if (this.underlyingPosition <= 0) {
                return false;
            }
            for (int i = this.underlyingPosition - 1; i >= 0; --i) {
                if (!FilteringResultSet.this.inclusionMask.get(i)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ResultSetRow previous() {
            if (this.underlyingPosition <= 0) {
                throw new IllegalStateException();
            }
            for (int i = this.underlyingPosition - 1; i >= 0; --i) {
                if (!FilteringResultSet.this.inclusionMask.get(i)) continue;
                this.underlyingPosition = i;
                return FilteringResultSet.this.unfiltered.getRow(this.underlyingPosition);
            }
            throw new IllegalStateException();
        }

        @Override
        public int nextIndex() {
            return FilteringResultSet.this.inclusionMask.nextSetBit(this.underlyingPosition + 1);
        }

        @Override
        public int previousIndex() {
            if (this.underlyingPosition <= 0) {
                return -1;
            }
            for (int i = this.underlyingPosition - 1; i >= 0; --i) {
                if (!FilteringResultSet.this.inclusionMask.get(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(ResultSetRow o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(ResultSetRow o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean allowsReverse() {
            return true;
        }

        @Override
        public ResultSet getResultSet() {
            return FilteringResultSet.this;
        }
    }
}

