/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.FilterPropString;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryFactory;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.person.HomeFolderManager;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantDomainMismatchException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.invitation.InvitationException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.ModelUtil;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class PersonServiceImpl
extends TransactionListenerAdapter
implements PersonService,
NodeServicePolicies.BeforeCreateNodePolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private static Log logger = LogFactory.getLog(PersonServiceImpl.class);
    private static final String CANNED_QUERY_PEOPLE_LIST = "peopleGetChildrenCannedQueryFactory";
    private static final String DELETE = "DELETE";
    private static final String SPLIT = "SPLIT";
    private static final String LEAVE = "LEAVE";
    public static final String SYSTEM_FOLDER_SHORT_QNAME = "sys:system";
    public static final String PEOPLE_FOLDER_SHORT_QNAME = "sys:people";
    private static final String SYSTEM_USAGE_WARN_LIMIT_USERS_EXCEEDED_VERBOSE = "system.usage.err.limit_users_exceeded_verbose";
    private static final String KEY_POST_TXN_DUPLICATES = "PersonServiceImpl.KEY_POST_TXN_DUPLICATES";
    public static final String KEY_ALLOW_UID_UPDATE = "PersonServiceImpl.KEY_ALLOW_UID_UPDATE";
    private static final String KEY_USERS_CREATED = "PersonServiceImpl.KEY_USERS_CREATED";
    private StoreRef storeRef;
    private TransactionService transactionService;
    private NodeService nodeService;
    private TenantService tenantService;
    private SearchService searchService;
    private AuthorityService authorityService;
    private MutableAuthenticationService authenticationService;
    private DictionaryService dictionaryService;
    private PermissionServiceSPI permissionServiceSPI;
    private NamespacePrefixResolver namespacePrefixResolver;
    private HomeFolderManager homeFolderManager;
    private PolicyComponent policyComponent;
    private AclDAO aclDao;
    private PermissionsManager permissionsManager;
    private RepoAdminService repoAdminService;
    private ServiceRegistry serviceRegistry;
    private boolean createMissingPeople;
    private static Set<QName> mutableProperties;
    private String defaultHomeFolderProvider;
    private boolean processDuplicates = true;
    private String duplicateMode = "LEAVE";
    private boolean lastIsBest = true;
    private boolean includeAutoCreated = false;
    private NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry;
    private SimpleCache<String, Set<NodeRef>> personCache;
    private Map<String, NodeRef> peopleContainerRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private UserNameMatcher userNameMatcher;
    private JavaBehaviour beforeCreateNodeValidationBehaviour;
    private JavaBehaviour beforeDeleteNodeValidationBehaviour;
    private boolean homeFolderCreationEager;

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return 1;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"storeUrl", (Object)this.storeRef);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionServiceSPI", (Object)this.permissionServiceSPI);
        PropertyCheck.mandatory((Object)this, (String)"authorityService", (Object)this.authorityService);
        PropertyCheck.mandatory((Object)this, (String)"authenticationService", (Object)this.authenticationService);
        PropertyCheck.mandatory((Object)this, (String)"namespacePrefixResolver", (Object)this.namespacePrefixResolver);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"personCache", this.personCache);
        PropertyCheck.mandatory((Object)this, (String)"aclDao", (Object)this.aclDao);
        PropertyCheck.mandatory((Object)this, (String)"homeFolderManager", (Object)this.homeFolderManager);
        PropertyCheck.mandatory((Object)this, (String)"repoAdminService", (Object)this.repoAdminService);
        this.beforeCreateNodeValidationBehaviour = new JavaBehaviour(this, "beforeCreateNodeValidation");
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)this.beforeCreateNodeValidationBehaviour);
        this.beforeDeleteNodeValidationBehaviour = new JavaBehaviour(this, "beforeDeleteNodeValidation");
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)this.beforeDeleteNodeValidationBehaviour);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_USER, (Behaviour)new JavaBehaviour(this, "onUpdatePropertiesUser"));
    }

    @Override
    public void setCreateMissingPeople(boolean createMissingPeople) {
        this.createMissingPeople = createMissingPeople;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setUserNameMatcher(UserNameMatcher userNameMatcher) {
        this.userNameMatcher = userNameMatcher;
    }

    void setDefaultHomeFolderProvider(String defaultHomeFolderProvider) {
        this.defaultHomeFolderProvider = defaultHomeFolderProvider;
    }

    public void setDuplicateMode(String duplicateMode) {
        this.duplicateMode = duplicateMode;
    }

    public void setIncludeAutoCreated(boolean includeAutoCreated) {
        this.includeAutoCreated = includeAutoCreated;
    }

    public void setLastIsBest(boolean lastIsBest) {
        this.lastIsBest = lastIsBest;
    }

    public void setProcessDuplicates(boolean processDuplicates) {
        this.processDuplicates = processDuplicates;
    }

    public void setHomeFolderManager(HomeFolderManager homeFolderManager) {
        this.homeFolderManager = homeFolderManager;
    }

    public void setHomeFolderCreationEager(boolean homeFolderCreationEager) {
        this.homeFolderCreationEager = homeFolderCreationEager;
    }

    public void setAclDAO(AclDAO aclDao) {
        this.aclDao = aclDao;
    }

    public void setPermissionsManager(PermissionsManager permissionsManager) {
        this.permissionsManager = permissionsManager;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setPersonCache(SimpleCache<String, Set<NodeRef>> personCache) {
        this.personCache = personCache;
    }

    private FileFolderService getFileFolderService() {
        return this.serviceRegistry.getFileFolderService();
    }

    private NamespaceService getNamespaceService() {
        return this.serviceRegistry.getNamespaceService();
    }

    private ActionService getActionService() {
        return this.serviceRegistry.getActionService();
    }

    @Override
    public NodeRef getPerson(String userName) {
        return this.getPerson(userName, true);
    }

    @Override
    public NodeRef getPerson(final String userName, final boolean autoCreateHomeFolderAndMissingPersonIfAllowed) {
        if (this.tenantService.isEnabled() && "System".equals(AuthenticationUtil.getRunAsUser()) && this.tenantService.isTenantUser(userName)) {
            String tenantDomain = this.tenantService.getUserDomain(userName);
            return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return PersonServiceImpl.this.getPersonImpl(userName, autoCreateHomeFolderAndMissingPersonIfAllowed);
                }
            }, (String)this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
        }
        return this.getPersonImpl(userName, autoCreateHomeFolderAndMissingPersonIfAllowed);
    }

    private NodeRef getPersonImpl(String userName, boolean autoCreateHomeFolderAndMissingPersonIfAllowed) {
        if (userName == null) {
            return null;
        }
        if (userName.length() == 0) {
            return null;
        }
        NodeRef personNode = this.getPersonOrNull(userName);
        if (personNode == null) {
            AlfrescoTransactionSupport.TxnReadState txnReadState = AlfrescoTransactionSupport.getTransactionReadState();
            if (autoCreateHomeFolderAndMissingPersonIfAllowed && this.createMissingPeople() && txnReadState == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
                return this.createMissingPerson(userName, true);
            }
            throw new NoSuchPersonException(userName);
        }
        if (autoCreateHomeFolderAndMissingPersonIfAllowed) {
            this.makeHomeFolderIfRequired(personNode);
        }
        return personNode;
    }

    @Override
    public boolean personExists(String caseSensitiveUserName) {
        return this.getPersonOrNull(caseSensitiveUserName) != null;
    }

    private NodeRef getPersonOrNull(String searchUserName) {
        Set<NodeRef> allRefs = this.getFromCache(searchUserName);
        boolean addToCache = false;
        if (allRefs == null) {
            List childRefs = this.nodeService.getChildAssocs(this.getPeopleContainer(), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)this.getChildNameLower(searchUserName), false);
            allRefs = new LinkedHashSet<NodeRef>(childRefs.size() * 2);
            for (ChildAssociationRef childRef : childRefs) {
                NodeRef nodeRef = childRef.getChildRef();
                allRefs.add(nodeRef);
            }
            addToCache = true;
        }
        ArrayList<NodeRef> refs = new ArrayList<NodeRef>(allRefs.size());
        HashSet<NodeRef> nodesToRemoveFromCache = new HashSet<NodeRef>();
        for (NodeRef nodeRef : allRefs) {
            if (this.nodeService.exists(nodeRef)) {
                Serializable value = this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME);
                String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
                if (!this.userNameMatcher.matches(searchUserName, realUserName)) continue;
                refs.add(nodeRef);
                continue;
            }
            nodesToRemoveFromCache.add(nodeRef);
        }
        if (!nodesToRemoveFromCache.isEmpty()) {
            allRefs.removeAll(nodesToRemoveFromCache);
        }
        NodeRef returnRef = null;
        if (refs.size() > 1) {
            returnRef = this.handleDuplicates(refs, searchUserName);
        } else if (refs.size() == 1) {
            returnRef = (NodeRef)refs.get(0);
            if (addToCache) {
                this.putToCache(searchUserName, allRefs);
            }
        }
        return returnRef;
    }

    private NodeRef handleDuplicates(List<NodeRef> refs, String searchUserName) {
        if (this.processDuplicates) {
            NodeRef best = this.findBest(refs);
            HashSet<NodeRef> toHandle = new HashSet<NodeRef>();
            toHandle.addAll(refs);
            toHandle.remove(best);
            this.addDuplicateNodeRefsToHandle(toHandle);
            return best;
        }
        String userNameSensitivity = " (user name is case-" + (this.userNameMatcher.getUserNamesAreCaseSensitive() ? "sensitive" : "insensitive") + ")";
        String domainNameSensitivity = "";
        if (!this.userNameMatcher.getDomainSeparator().equals("")) {
            domainNameSensitivity = " (domain name is case-" + (this.userNameMatcher.getDomainNamesAreCaseSensitive() ? "sensitive" : "insensitive") + ")";
        }
        throw new AlfrescoRuntimeException("Found more than one user for " + searchUserName + userNameSensitivity + domainNameSensitivity);
    }

    private Set<NodeRef> getPostTxnDuplicates() {
        HashSet postTxnDuplicates = (HashSet)AlfrescoTransactionSupport.getResource(KEY_POST_TXN_DUPLICATES);
        if (postTxnDuplicates == null) {
            postTxnDuplicates = new HashSet();
            AlfrescoTransactionSupport.bindResource(KEY_POST_TXN_DUPLICATES, postTxnDuplicates);
        }
        return postTxnDuplicates;
    }

    private void addDuplicateNodeRefsToHandle(Set<NodeRef> refs) {
        AlfrescoTransactionSupport.bindListener(this);
        Set<NodeRef> postTxnDuplicates = this.getPostTxnDuplicates();
        postTxnDuplicates.addAll(refs);
    }

    @Override
    public void afterCommit() {
        final Set<NodeRef> postTxnDuplicates = this.getPostTxnDuplicates();
        if (postTxnDuplicates.size() == 0) {
            return;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> processDuplicateWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                if (PersonServiceImpl.this.duplicateMode.equalsIgnoreCase(PersonServiceImpl.SPLIT)) {
                    logger.info((Object)("Splitting " + postTxnDuplicates.size() + " duplicate person objects."));
                    AlfrescoTransactionSupport.bindResource(PersonServiceImpl.KEY_ALLOW_UID_UPDATE, Boolean.TRUE);
                    PersonServiceImpl.this.split(postTxnDuplicates);
                    logger.info((Object)("Split " + postTxnDuplicates.size() + " duplicate person objects."));
                } else if (PersonServiceImpl.this.duplicateMode.equalsIgnoreCase(PersonServiceImpl.DELETE)) {
                    PersonServiceImpl.this.delete(postTxnDuplicates);
                    logger.info((Object)"Deleted duplicate person objects");
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Duplicate person objects exist");
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(processDuplicateWork, false, true);
    }

    private void delete(Set<NodeRef> toDelete) {
        for (NodeRef nodeRef : toDelete) {
            this.deletePerson(nodeRef);
        }
    }

    private void split(Set<NodeRef> toSplit) {
        for (NodeRef nodeRef : toSplit) {
            String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            String newUserName = userName + GUID.generate();
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_USERNAME, (Serializable)((Object)(userName + GUID.generate())));
            logger.info((Object)("   New person object: " + newUserName));
        }
    }

    private NodeRef findBest(List<NodeRef> refs) {
        if (this.lastIsBest) {
            Collections.sort(refs, new NodeIdComparator(this.nodeService, false));
        } else {
            Collections.sort(refs, new NodeIdComparator(this.nodeService, true));
        }
        NodeRef fallBack = null;
        for (NodeRef nodeRef : refs) {
            if (fallBack == null) {
                fallBack = nodeRef;
            }
            if (!this.includeAutoCreated && this.wasAutoCreated(nodeRef)) continue;
            return nodeRef;
        }
        return fallBack;
    }

    private boolean wasAutoCreated(NodeRef nodeRef) {
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        String testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME));
        if (testString == null || !testString.equals(userName)) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EMAIL));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ORGID));
        if (testString == null || !testString.equals("")) {
            return false;
        }
        testString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_HOME_FOLDER_PROVIDER));
        return testString != null && testString.equals(this.defaultHomeFolderProvider);
    }

    @Override
    public boolean createMissingPeople() {
        return this.createMissingPeople;
    }

    @Override
    public Set<QName> getMutableProperties() {
        return mutableProperties;
    }

    @Override
    public void setPersonProperties(String userName, Map<QName, Serializable> properties) {
        this.setPersonProperties(userName, properties, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPersonProperties(String userName, Map<QName, Serializable> properties, boolean autoCreateHomeFolder) {
        NodeRef personNode = this.getPersonOrNull(userName);
        if (personNode == null) {
            if (!this.createMissingPeople()) throw new PersonException("No person found for user name " + userName);
            personNode = this.createMissingPerson(userName, autoCreateHomeFolder);
        } else {
            String suggestedUserName;
            if (autoCreateHomeFolder) {
                this.makeHomeFolderIfRequired(personNode);
            }
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personNode, ContentModel.PROP_USERNAME));
            if (this.getUserNamesAreCaseSensitive() || (suggestedUserName = (String)((Object)properties.get(ContentModel.PROP_USERNAME))) == null || !suggestedUserName.equalsIgnoreCase(realUserName)) {
                properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)realUserName));
            }
        }
        Map update = this.nodeService.getProperties(personNode);
        update.putAll(properties);
        this.nodeService.setProperties(personNode, update);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    private NodeRef createMissingPerson(String userName, boolean autoCreateHomeFolder) {
        HashMap<QName, Serializable> properties = this.getDefaultProperties(userName);
        NodeRef person = this.createPerson(properties);
        if (autoCreateHomeFolder && !this.homeFolderCreationEager) {
            this.makeHomeFolderIfRequired(person);
        }
        return person;
    }

    private void makeHomeFolderIfRequired(NodeRef person) {
        NodeRef homeFolder;
        if (person != null && (homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER))) == null) {
            final ChildAssociationRef ref = this.nodeService.getPrimaryParent(person);
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    PersonServiceImpl.this.makeHomeFolderAsSystem(ref);
                    return null;
                }
            }, this.transactionService.isReadOnly(), this.transactionService.isReadOnly() ? false : AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY);
        }
    }

    private void makeHomeFolderAsSystem(final ChildAssociationRef childAssocRef) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                PersonServiceImpl.this.homeFolderManager.makeHomeFolder(childAssocRef);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private HashMap<QName, Serializable> getDefaultProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)this.tenantService.getBaseNameUser(userName)));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_HOME_FOLDER_PROVIDER, (Serializable)((Object)this.defaultHomeFolderProvider));
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        properties.put(ContentModel.PROP_SIZE_QUOTA, Long.valueOf(-1L));
        return properties;
    }

    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties) {
        return this.createPerson(properties, this.authorityService.getDefaultZones());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties, Set<String> zones) {
        AuthorityType authorityType;
        ParameterCheck.mandatory((String)"properties", properties);
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_USERNAME));
        if (userName == null) {
            throw new IllegalArgumentException("No username specified when creating the person.");
        }
        Long maxUsers = this.repoAdminService.getRestrictions().getUsers();
        if (maxUsers != null) {
            Set usersCreated = TransactionalResourceHelper.getSet(KEY_USERS_CREATED);
            usersCreated.add(userName);
            AlfrescoTransactionSupport.bindListener(this);
        }
        if ((authorityType = AuthorityType.getAuthorityType((String)userName)) != AuthorityType.USER) {
            throw new AlfrescoRuntimeException("Attempt to create person for an authority which is not a user");
        }
        this.tenantService.checkDomainUser(userName);
        if (this.personExists(userName)) {
            throw new AlfrescoRuntimeException("Person '" + userName + "' already exists.");
        }
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_SIZE_CURRENT, Long.valueOf(0L));
        NodeRef personRef = null;
        try {
            this.beforeCreateNodeValidationBehaviour.disable();
            personRef = this.nodeService.createNode(this.getPeopleContainer(), ContentModel.ASSOC_CHILDREN, this.getChildNameLower(userName), ContentModel.TYPE_PERSON, properties).getChildRef();
        }
        finally {
            this.beforeCreateNodeValidationBehaviour.enable();
        }
        if (zones != null) {
            for (String zone : zones) {
                this.nodeService.addChild(this.authorityService.getOrCreateZone(zone), personRef, ContentModel.ASSOC_IN_ZONE, QName.createQName((String)"cm", (String)userName, (NamespacePrefixResolver)this.namespacePrefixResolver));
            }
        }
        this.removeFromCache(userName);
        return personRef;
    }

    @Override
    public void notifyPerson(String userName, String password) {
        NodeRef noderef = this.getPerson(userName, false);
        Map userProps = this.nodeService.getProperties(noderef);
        String email = null;
        if (userProps.containsKey(ContentModel.PROP_EMAIL)) {
            email = (String)userProps.get(ContentModel.PROP_EMAIL);
        }
        if (email == null || email.length() == 0) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Not sending new user notification to " + userName + " as no email address found"));
            }
            return;
        }
        Map<String, Serializable> model = this.buildEmailTemplateModel(userProps);
        model.put("password", (Serializable)((Object)password));
        NodeRef creatorNR = this.getPerson(AuthenticationUtil.getFullyAuthenticatedUser());
        Map creatorProps = this.nodeService.getProperties(creatorNR);
        Map<String, Serializable> creator = this.buildEmailTemplateModel(creatorProps);
        model.put("creator", (Serializable)((Object)creator));
        String productName = ModelUtil.getProductName(this.repoAdminService);
        model.put("productName", (Serializable)((Object)productName));
        HashMap<String, Serializable> actionParams = new HashMap<String, Serializable>();
        actionParams.put("template_model", (Serializable)((Object)model));
        actionParams.put("to", (Serializable)((Object)email));
        actionParams.put("from", (Serializable)creatorProps.get(ContentModel.PROP_EMAIL));
        actionParams.put("subject", (Serializable)((Object)I18NUtil.getMessage((String)"invitation.notification.person.email.subject", (Object[])new Object[]{productName})));
        actionParams.put("template", (Serializable)this.getNotifyEmailTemplateNodeRef());
        Action mailAction = this.getActionService().createAction("mail", actionParams);
        this.getActionService().executeAction(mailAction, noderef, false, true);
    }

    private NodeRef getNotifyEmailTemplateNodeRef() {
        String xpath = "app:company_home/app:dictionary/app:email_templates/cm:invite/cm:new-user-email.html.ftl";
        try {
            NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            List nodeRefs = this.searchService.selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (nodeRefs.size() > 1) {
                logger.error((Object)("Found too many email templates using: " + xpath));
                nodeRefs = Collections.singletonList(nodeRefs.get(0));
            } else if (nodeRefs.size() == 0) {
                throw new InvitationException("Cannot find the email template using " + xpath, new Object[0]);
            }
            NodeRef base = (NodeRef)nodeRefs.get(0);
            NodeRef local = this.getFileFolderService().getLocalizedSibling(base);
            return local;
        }
        catch (SearcherException e) {
            throw new InvitationException("Cannot find the email template!", e);
        }
    }

    private Map<String, Serializable> buildEmailTemplateModel(Map<QName, Serializable> props) {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>((int)((double)props.size() * 1.5));
        for (QName qname : props.keySet()) {
            model.put(qname.getLocalName(), props.get(qname));
            model.put(qname.getLocalName().toLowerCase(), props.get(qname));
        }
        return model;
    }

    @Override
    public NodeRef getPeopleContainer() {
        String cacheKey = this.tenantService.getCurrentUserDomain();
        NodeRef peopleNodeRef = this.peopleContainerRefs.get(cacheKey);
        if (peopleNodeRef == null) {
            NodeRef rootNodeRef = this.nodeService.getRootNode(this.tenantService.getName(this.storeRef));
            List children = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)SYSTEM_FOLDER_SHORT_QNAME, (NamespacePrefixResolver)this.namespacePrefixResolver), false);
            if (children.size() == 0) {
                throw new AlfrescoRuntimeException("Required people system path not found: sys:system");
            }
            NodeRef systemNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            if ((children = this.nodeService.getChildAssocs(systemNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)QName.createQName((String)PEOPLE_FOLDER_SHORT_QNAME, (NamespacePrefixResolver)this.namespacePrefixResolver), false)).size() == 0) {
                throw new AlfrescoRuntimeException("Required people system path not found: sys:people");
            }
            peopleNodeRef = ((ChildAssociationRef)children.get(0)).getChildRef();
            this.peopleContainerRefs.put(cacheKey, peopleNodeRef);
        }
        return peopleNodeRef;
    }

    @Override
    public void deletePerson(String userName) {
        if ((userName = this.getUserIdentifier(userName)) == null) {
            return;
        }
        NodeRef personRef = this.getPersonOrNull(userName);
        this.deletePersonImpl(userName, personRef);
    }

    @Override
    public void deletePerson(NodeRef personRef) {
        QName typeQName = this.nodeService.getType(personRef);
        if (!typeQName.equals((Object)ContentModel.TYPE_PERSON)) {
            throw new AlfrescoRuntimeException("deletePerson: invalid type of node " + personRef + " (actual=" + typeQName + ", expected=" + ContentModel.TYPE_PERSON + ")");
        }
        String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
        this.deletePersonImpl(userName, personRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePersonImpl(String userName, NodeRef personRef) {
        Long maxUsers;
        if (userName != null) {
            try {
                this.authenticationService.deleteAuthentication(userName);
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
            try {
                this.authenticationService.invalidateUserSession(userName);
            }
            catch (AuthenticationException e) {
                // empty catch block
            }
            this.permissionServiceSPI.deletePermissions(userName);
        }
        if (personRef != null) {
            try {
                this.beforeDeleteNodeValidationBehaviour.disable();
                this.nodeService.deleteNode(personRef);
            }
            finally {
                this.beforeDeleteNodeValidationBehaviour.enable();
            }
        }
        if ((maxUsers = this.repoAdminService.getRestrictions().getUsers()) != null) {
            AlfrescoTransactionSupport.bindListener(this);
        }
    }

    @Override
    public Set<NodeRef> getAllPeople() {
        List personInfos = this.getPeople(null, true, null, new PagingRequest(Integer.MAX_VALUE, null)).getPage();
        HashSet<NodeRef> refs = new HashSet<NodeRef>(personInfos.size());
        for (PersonService.PersonInfo personInfo : personInfos) {
            refs.add(personInfo.getNodeRef());
        }
        return refs;
    }

    @Override
    public PagingResults<PersonService.PersonInfo> getPeople(List<Pair<QName, String>> stringPropFilters, boolean filterIgnoreCase, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        GetChildrenCannedQuery cq;
        CannedQueryResults results;
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        NodeRef contextNodeRef = this.getPeopleContainer();
        HashSet<QName> childTypeQNames = new HashSet<QName>(1);
        childTypeQNames.add(ContentModel.TYPE_PERSON);
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_PEOPLE_LIST));
        ArrayList<FilterProp> filterProps = null;
        if (stringPropFilters != null) {
            filterProps = new ArrayList<FilterProp>(stringPropFilters.size());
            for (Pair<QName, String> filterProp : stringPropFilters) {
                String filterStr = (String)filterProp.getSecond();
                if (filterStr == null || filterStr.equals("") || filterStr.equals("*")) continue;
                if (filterStr.endsWith("*")) {
                    filterStr = filterStr.substring(0, filterStr.length() - 1);
                }
                filterProps.add(new FilterPropString((QName)filterProp.getFirst(), filterStr, filterIgnoreCase ? FilterPropString.FilterTypeString.STARTSWITH_IGNORECASE : FilterPropString.FilterTypeString.STARTSWITH));
            }
        }
        List nodeRefs = (results = (cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(contextNodeRef, null, null, childTypeQNames, filterProps, sortProps, pagingRequest)).execute()).getPageCount() > 0 ? (List)results.getPages().get(0) : Collections.emptyList();
        final Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
        if (start != null) {
            int cnt = results.getPagedResultCount();
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            boolean hasMoreItems = results.hasMoreItems();
            int pageNum = skipCount / maxItems + 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getPeople: " + cnt + " items in " + (System.currentTimeMillis() - start) + " msecs " + "[pageNum=" + pageNum + ",skip=" + skipCount + ",max=" + maxItems + ",hasMorePages=" + hasMoreItems + ",totalCount=" + totalCount + ",filters=" + stringPropFilters + ",filtersIgnoreCase=" + filterIgnoreCase + "]"));
            }
        }
        final ArrayList<PersonService.PersonInfo> personInfos = new ArrayList<PersonService.PersonInfo>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            Map props = this.nodeService.getProperties(nodeRef);
            personInfos.add(new PersonService.PersonInfo(nodeRef, (String)props.get(ContentModel.PROP_USERNAME), (String)props.get(ContentModel.PROP_FIRSTNAME), (String)props.get(ContentModel.PROP_LASTNAME)));
        }
        return new PagingResults<PersonService.PersonInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<PersonService.PersonInfo> getPage() {
                return personInfos;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    @Override
    public Set<NodeRef> getPeopleFilteredByProperty(QName propertyKey, Serializable propertyValue, int count) {
        if (count > 1000) {
            throw new IllegalArgumentException("Only 1000 results are allowed but got a request for " + count + ". Use getPeople.");
        }
        if (this.dictionaryService.getProperty(ContentModel.TYPE_PERSON, propertyKey) == null) {
            throw new AlfrescoRuntimeException("Property '" + propertyKey + "' is not defined " + "for content model type cm:person");
        }
        ArrayList<Pair<QName, String>> filterProps = new ArrayList<Pair<QName, String>>(1);
        filterProps.add(new Pair((Object)propertyKey, (Object)((String)((Object)propertyValue))));
        PagingRequest pagingRequest = new PagingRequest(count, null);
        List personInfos = this.getPeople(filterProps, true, null, pagingRequest).getPage();
        HashSet<NodeRef> refs = new HashSet<NodeRef>(personInfos.size());
        for (PersonService.PersonInfo personInfo : personInfos) {
            refs.add(personInfo.getNodeRef());
        }
        return refs;
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef personRef = childAssocRef.getChildRef();
        String userName = (String)((Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
        if (this.getPeopleContainer().equals((Object)childAssocRef.getParentRef())) {
            this.removeFromCache(userName);
        }
        this.permissionsManager.setPermissions(personRef, userName, userName);
        if (this.homeFolderCreationEager) {
            this.makeHomeFolderAsSystem(childAssocRef);
        }
    }

    private QName getChildNameLower(String userName) {
        return QName.createQName((String)"cm", (String)userName.toLowerCase(), (NamespacePrefixResolver)this.namespacePrefixResolver);
    }

    @Override
    public void beforeCreateNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
    }

    public void beforeCreateNodeValidation(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        if (this.getPeopleContainer().equals((Object)parentRef)) {
            throw new AlfrescoRuntimeException("beforeCreateNode: use PersonService to create person");
        }
        logger.info((Object)("Person node is not being created under the people container (actual=" + parentRef + ", expected=" + this.getPeopleContainer() + ")"));
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
        if (this.authorityService.isGuestAuthority(userName)) {
            throw new AlfrescoRuntimeException("The " + userName + " user cannot be deleted.");
        }
        NodeRef parentRef = null;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null) {
            parentRef = parentAssocRef.getParentRef();
            if (this.getPeopleContainer().equals((Object)parentRef)) {
                this.removeFromCache(userName);
            }
        }
    }

    public void beforeDeleteNodeValidation(NodeRef nodeRef) {
        NodeRef parentRef = null;
        ChildAssociationRef parentAssocRef = this.nodeService.getPrimaryParent(nodeRef);
        if (parentAssocRef != null) {
            parentRef = parentAssocRef.getParentRef();
        }
        if (this.getPeopleContainer().equals((Object)parentRef)) {
            throw new AlfrescoRuntimeException("beforeDeleteNode: use PersonService to delete person");
        }
        logger.info((Object)("Person node that is being deleted is not under the parent people container (actual=" + parentRef + ", expected=" + this.getPeopleContainer() + ")"));
    }

    private Set<NodeRef> getFromCache(String userName) {
        return (Set)this.personCache.get((Serializable)((Object)userName.toLowerCase()));
    }

    private void putToCache(String userName, Set<NodeRef> refs) {
        this.personCache.put((Serializable)((Object)userName.toLowerCase()), refs);
    }

    private void removeFromCache(String userName) {
        this.personCache.remove((Serializable)((Object)userName.toLowerCase()));
    }

    @Override
    public String getUserIdentifier(String caseSensitiveUserName) {
        NodeRef nodeRef = this.getPersonOrNull(caseSensitiveUserName);
        if (nodeRef != null && this.nodeService.exists(nodeRef)) {
            String realUserName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            return realUserName;
        }
        return null;
    }

    @Override
    public boolean getUserNamesAreCaseSensitive() {
        return this.userNameMatcher.getUserNamesAreCaseSensitive();
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String uidBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_USERNAME));
        if (uidBefore == null) {
            return;
        }
        String uidAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(ContentModel.PROP_USERNAME));
        if (!EqualsHelper.nullSafeEquals((Object)uidBefore, (Object)uidAfter)) {
            if (AlfrescoTransactionSupport.getResource(KEY_ALLOW_UID_UPDATE) != null || uidBefore.equalsIgnoreCase(uidAfter)) {
                if (uidBefore != null) {
                    this.aclDao.renameAuthority(uidBefore, uidAfter);
                }
                QName newAssocQName = this.getChildNameLower(uidAfter);
                ChildAssociationRef assoc = this.nodeService.getPrimaryParent(nodeRef);
                this.nodeService.moveNode(nodeRef, assoc.getParentRef(), assoc.getTypeQName(), newAssocQName);
                QName oldAssocQName = QName.createQName((String)"cm", (String)uidBefore, (NamespacePrefixResolver)this.namespacePrefixResolver);
                newAssocQName = QName.createQName((String)"cm", (String)uidAfter, (NamespacePrefixResolver)this.namespacePrefixResolver);
                for (ChildAssociationRef parent : this.nodeService.getParentAssocs(nodeRef)) {
                    if (parent.isPrimary() || !parent.getQName().equals((Object)oldAssocQName)) continue;
                    this.nodeService.removeChildAssociation(parent);
                    this.nodeService.addChild(parent.getParentRef(), parent.getChildRef(), parent.getTypeQName(), newAssocQName);
                }
                this.removeFromCache(uidBefore);
            } else {
                throw new UnsupportedOperationException("The user name on a person can not be changed");
            }
        }
    }

    public void onUpdatePropertiesUser(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String userName = (String)((Object)after.get(ContentModel.PROP_USER_USERNAME));
        if (userName == null) {
            return;
        }
        NodeRef personNodeRef = this.getPersonOrNull(userName);
        if (personNodeRef == null) {
            return;
        }
        Boolean enabled = (Boolean)after.get(ContentModel.PROP_ENABLED);
        if (enabled == null || enabled.booleanValue()) {
            this.nodeService.removeAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED);
        } else {
            this.nodeService.addAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED, null);
        }
        Set usersCreated = TransactionalResourceHelper.getSet(KEY_USERS_CREATED);
        usersCreated.add(userName);
        AlfrescoTransactionSupport.bindListener(this);
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        AuthenticationUtil.RunAsWork<Long> getMaxUsersWork = new AuthenticationUtil.RunAsWork<Long>(){

            public Long doWork() throws Exception {
                return PersonServiceImpl.this.repoAdminService.getRestrictions().getUsers();
            }
        };
        Long maxUsers = (Long)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getMaxUsersWork, (String)AuthenticationUtil.getSystemUserName());
        if (maxUsers == null) {
            return;
        }
        Long users = (Long)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Long>(){

            public Long doWork() throws Exception {
                PersonServiceImpl.this.repoAdminService.updateUsage(RepoUsage.UsageType.USAGE_USERS);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Number of users is " + PersonServiceImpl.this.repoAdminService.getUsage().getUsers()));
                }
                return PersonServiceImpl.this.repoAdminService.getUsage().getUsers();
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        Set<String> usersCreated = TransactionalResourceHelper.getSet(KEY_USERS_CREATED);
        if (users > maxUsers) {
            ArrayList<String> usersMsg = new ArrayList<String>(5);
            int i = 0;
            for (String userCreated : usersCreated) {
                if (++i > 5) {
                    usersMsg.add(" ... more");
                    break;
                }
                usersMsg.add(userCreated);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Maximum number of users exceeded: " + usersCreated));
            }
            throw AlfrescoRuntimeException.create((String)SYSTEM_USAGE_WARN_LIMIT_USERS_EXCEEDED_VERBOSE, (Object[])new Object[]{maxUsers, usersMsg});
        }
        RepoUsageStatus usageStatus = this.repoAdminService.getUsageStatus();
        usageStatus.logMessages(logger);
    }

    @Override
    public int countPeople() {
        NodeRef peopleContainer = this.getPeopleContainer();
        return this.nodeService.countChildAssocs(peopleContainer, true);
    }

    public static String updateUsernameForTenancy(String username, TenantService tenantService) throws TenantDomainMismatchException {
        if (!tenantService.isEnabled()) {
            return username;
        }
        String currentDomain = tenantService.getCurrentUserDomain();
        if (!currentDomain.equals("")) {
            if (!tenantService.isTenantUser(username)) {
                username = tenantService.getDomainUser(username, currentDomain);
                logger.warn((Object)("Added domain to username: " + username));
            } else {
                tenantService.checkDomainUser(username);
            }
        }
        return username;
    }

    @Override
    public boolean isEnabled(String userName) {
        NodeRef noderef = this.getPerson(userName, false);
        Serializable ser = this.nodeService.getProperty(noderef, ContentModel.PROP_ENABLED);
        if (ser == null) {
            return true;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    static {
        HashSet<QName> props = new HashSet<QName>();
        props.add(ContentModel.PROP_HOMEFOLDER);
        props.add(ContentModel.PROP_FIRSTNAME);
        props.add(ContentModel.PROP_LASTNAME);
        props.add(ContentModel.PROP_EMAIL);
        props.add(ContentModel.PROP_ORGID);
        mutableProperties = Collections.unmodifiableSet(props);
    }

    public static class NodeIdComparator
    implements Comparator<NodeRef> {
        private NodeService nodeService;
        boolean ascending;

        NodeIdComparator(NodeService nodeService, boolean ascending) {
            this.nodeService = nodeService;
            this.ascending = ascending;
        }

        @Override
        public int compare(NodeRef first, NodeRef second) {
            Long firstId = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(first, ContentModel.PROP_NODE_DBID));
            Long secondId = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(second, ContentModel.PROP_NODE_DBID));
            if (firstId != null) {
                if (secondId != null) {
                    return firstId.compareTo(secondId) * (this.ascending ? 1 : -1);
                }
                return this.ascending ? -1 : 1;
            }
            if (secondId != null) {
                return this.ascending ? 1 : -1;
            }
            return 0;
        }
    }
}

