/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.security.person.PersonServiceImpl;
import org.alfresco.repo.security.person.SplitPersonCleanupBootstrapBean;
import org.alfresco.repo.security.person.UserNameMatcherImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.tools.RenameUser;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;

public class PersonTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private PersonService personService;
    private UserNameMatcherImpl userNameMatcher;
    private BehaviourFilter policyBehaviourFilter;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private PermissionService permissionService;
    private AuthorityService authorityService;
    private MutableAuthenticationDao authenticationDAO;
    private UserTransaction testTX;

    public void setUp() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.userNameMatcher = (UserNameMatcherImpl)ctx.getBean("userNameMatcher");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.permissionService = (PermissionService)ctx.getBean("permissionService");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.policyBehaviourFilter = (BehaviourFilter)ctx.getBean("policyBehaviourFilter");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        for (NodeRef nodeRef : this.personService.getAllPeople()) {
            String uid = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            if (uid.equals(AuthenticationUtil.getAdminUserName()) || uid.equals(AuthenticationUtil.getGuestUserName())) continue;
            this.personService.deletePerson(nodeRef);
        }
        this.personService.setCreateMissingPeople(true);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
    }

    protected void tearDown() throws Exception {
        this.userNameMatcher.setUserNamesAreCaseSensitive(false);
        if (this.testTX != null) {
            try {
                this.testTX.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    private int getPeopleCount() {
        PagingRequest pagingRequest = new PagingRequest(20000, null);
        int count = this.personService.getPeople(null, true, null, pagingRequest).getPage().size();
        pagingRequest = new PagingRequest(0, 1, null);
        pagingRequest.setRequestTotalCountMax(20000);
        PagingResults<PersonService.PersonInfo> ppr = this.personService.getPeople(null, true, null, pagingRequest);
        Pair totalResultCount = ppr.getTotalResultCount();
        PersonTest.assertNotNull((Object)totalResultCount);
        PersonTest.assertTrue((totalResultCount.getFirst() == totalResultCount.getSecond() ? 1 : 0) != 0);
        PersonTest.assertEquals((int)count, (int)((Integer)totalResultCount.getFirst()));
        return count;
    }

    private void checkPeopleContain(String userName) {
        PagingRequest pagingRequest = new PagingRequest(0, 20000, null);
        PagingResults<PersonService.PersonInfo> ppr = this.personService.getPeople(null, true, null, pagingRequest);
        boolean found = false;
        for (PersonService.PersonInfo person : ppr.getPage()) {
            if (!person.getUserName().equals(userName)) continue;
            found = true;
            break;
        }
        PersonTest.assertTrue((boolean)found);
    }

    public void xtestLazyHomeFolderCreation() throws Exception {
        String firstName = "" + System.currentTimeMillis();
        String lastName = String.format("%05d", -1);
        final String username = GUID.generate();
        String emailAddress = String.format("%s.%s@xyz.com", firstName, lastName);
        PropertyMap properties = new PropertyMap(7);
        properties.put(ContentModel.PROP_USERNAME, username);
        properties.put(ContentModel.PROP_FIRSTNAME, firstName);
        properties.put(ContentModel.PROP_LASTNAME, lastName);
        properties.put(ContentModel.PROP_EMAIL, emailAddress);
        final NodeRef madePerson = this.personService.createPerson(properties);
        NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(madePerson, ContentModel.PROP_HOMEFOLDER));
        if (homeFolder != null) {
            throw new IllegalStateException("Home folder created eagerly");
        }
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        RetryingTransactionHelper helper = this.transactionService.getRetryingTransactionHelper();
        helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((boolean)PersonTest.this.personService.personExists(username));
                NodeRef person = PersonTest.this.personService.getPerson(username);
                Assert.assertEquals((Object)madePerson, (Object)person);
                NodeRef homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)PersonTest.this.nodeService.getProperty(madePerson, ContentModel.PROP_HOMEFOLDER));
                if (homeFolder == null) {
                    throw new IllegalStateException("Home folder not created lazily");
                }
                return null;
            }
        }, true, false);
        homeFolder = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(madePerson, ContentModel.PROP_HOMEFOLDER));
        if (homeFolder == null) {
            throw new IllegalStateException("Home folder not created lazily");
        }
    }

    public void testZones() {
        PersonTest.assertNull(this.authorityService.getAuthorityZones("derek"));
        PersonTest.assertNull(this.authorityService.getAuthorityZones("null"));
        this.personService.createPerson(this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        Set<String> zones = this.authorityService.getAuthorityZones("derek");
        PersonTest.assertEquals((int)2, (int)zones.size());
        this.authorityService.removeAuthorityFromZones("derek", zones);
        PersonTest.assertEquals((int)0, (int)this.authorityService.getAuthorityZones("derek").size());
        this.authorityService.addAuthorityToZones("derek", zones);
        PersonTest.assertEquals((int)2, (int)this.authorityService.getAuthorityZones("derek").size());
        HashSet<String> newZones = null;
        this.personService.createPerson(this.createDefaultProperties("null", "null", "null", "null", "null", this.rootNodeRef), newZones);
        PersonTest.assertEquals((int)0, (int)this.authorityService.getAuthorityZones("null").size());
        newZones = new HashSet<String>();
        this.personService.createPerson(this.createDefaultProperties("empty", "empty", "empty", "empty", "empty", this.rootNodeRef), newZones);
        PersonTest.assertEquals((int)0, (int)this.authorityService.getAuthorityZones("empty").size());
        newZones.add("One");
        this.personService.createPerson(this.createDefaultProperties("1", "1", "1", "1", "1", this.rootNodeRef), newZones);
        PersonTest.assertEquals((int)1, (int)this.authorityService.getAuthorityZones("1").size());
        newZones.add("Two");
        this.personService.createPerson(this.createDefaultProperties("2", "2", "2", "2", "2", this.rootNodeRef), newZones);
        PersonTest.assertEquals((int)2, (int)this.authorityService.getAuthorityZones("2").size());
        newZones.add("Three");
        this.personService.createPerson(this.createDefaultProperties("3", "3", "3", "3", "3", this.rootNodeRef), newZones);
        PersonTest.assertEquals((int)3, (int)this.authorityService.getAuthorityZones("3").size());
        HashSet<String> toRemove = null;
        this.authorityService.removeAuthorityFromZones("3", toRemove);
        PersonTest.assertEquals((int)3, (int)this.authorityService.getAuthorityZones("3").size());
        toRemove = new HashSet<String>();
        this.authorityService.removeAuthorityFromZones("3", toRemove);
        PersonTest.assertEquals((int)3, (int)this.authorityService.getAuthorityZones("3").size());
        toRemove.add("Three");
        this.authorityService.removeAuthorityFromZones("3", toRemove);
        PersonTest.assertEquals((int)2, (int)this.authorityService.getAuthorityZones("3").size());
        toRemove.add("Two");
        this.authorityService.removeAuthorityFromZones("3", toRemove);
        PersonTest.assertEquals((int)1, (int)this.authorityService.getAuthorityZones("3").size());
        toRemove.add("One");
        this.authorityService.removeAuthorityFromZones("3", toRemove);
        PersonTest.assertEquals((int)0, (int)this.authorityService.getAuthorityZones("3").size());
        this.authorityService.addAuthorityToZones("3", newZones);
        PersonTest.assertEquals((int)3, (int)this.authorityService.getAuthorityZones("3").size());
        PersonTest.assertEquals((int)3, (int)this.authorityService.getAllAuthoritiesInZone("One", null).size());
        PersonTest.assertEquals((int)2, (int)this.authorityService.getAllAuthoritiesInZone("Two", null).size());
        PersonTest.assertEquals((int)1, (int)this.authorityService.getAllAuthoritiesInZone("Three", null).size());
    }

    public void xtestPerformance() {
        this.personService.setCreateMissingPeople(false);
        this.personService.createPerson(this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        long create = 0L;
        for (int i = 0; i < 10000; ++i) {
            String id = "TestUser-" + i;
            long start = System.nanoTime();
            this.personService.createPerson(this.createDefaultProperties(id, id, id, id, id, this.rootNodeRef));
            long end = System.nanoTime();
            create += end - start;
            if (i <= 0 || i % 100 != 0) continue;
            System.out.println("Count = " + i);
            System.out.println("Average create : " + (float)(create / (long)i) / 1000000.0f);
            start = System.nanoTime();
            this.personService.personExists(id);
            end = System.nanoTime();
            System.out.println("Exists : " + (float)(end - start) / 1000000.0f);
            start = System.nanoTime();
            int size = this.getPeopleCount();
            end = System.nanoTime();
            System.out.println("Size (" + size + ") : " + (float)(end - start) / 1000000.0f);
        }
    }

    public void testDeletePerson() throws Exception {
        this.personService.getPerson("andy");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(n1, "andy", "Read", true);
        this.permissionService.setPermission(n2, "andy", "All", true);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.nodeService.deleteNode(n1);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.personService.deletePerson("andy");
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
    }

    public void testCreateAndThenDelete() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.getPerson("andy");
            PersonTest.fail((String)"Getting Andy should fail");
        }
        catch (PersonException pe) {
            // empty catch block
        }
        this.personService.createPerson(this.createDefaultProperties("andy", "Andy", "Hind", "andy@hind", "alfresco", this.rootNodeRef));
        this.personService.getPerson("andy");
        this.personService.deletePerson("andy");
        try {
            this.personService.getPerson("andy");
            PersonTest.fail((String)"Getting Andy should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testCreateMissingPeople1() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.getPerson("andy");
            PersonTest.fail((String)"Getting Andy should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testCreateMissingPeople2() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        NodeRef nodeRef = this.personService.getPerson("andy");
        PersonTest.assertNotNull((Object)nodeRef);
        this.testProperties(nodeRef, "andy", "andy", "", "", "");
        nodeRef = this.personService.getPerson("andy");
        this.testProperties(nodeRef, "andy", "andy", "", "", "");
        nodeRef = this.personService.getPerson("Andy");
        this.testProperties(nodeRef, "andy", "andy", "", "", "");
        PersonTest.assertEquals((Object)nodeRef, (Object)this.personService.getPerson("Andy"));
        nodeRef = this.personService.getPerson("Andy");
        PersonTest.assertNotNull((Object)nodeRef);
        if (this.personService.getUserIdentifier("Andy").equals("Andy")) {
            this.testProperties(nodeRef, "Andy", "Andy", "", "", "");
        } else {
            this.testProperties(nodeRef, "andy", "andy", "", "", "");
        }
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
            PersonTest.fail((String)"Getting Derek should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testCreateMissingPeople() {
        PersonTest.assertEquals((int)2, (int)this.getPeopleCount());
        this.checkPeopleContain(AuthenticationUtil.getAdminUserName());
        this.checkPeopleContain(AuthenticationUtil.getGuestUserName());
        PersonTest.assertFalse((boolean)this.personService.personExists("andy"));
        PersonTest.assertFalse((boolean)this.personService.personExists("derek"));
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        NodeRef nodeRef = this.personService.getPerson("andy");
        PersonTest.assertNotNull((Object)nodeRef);
        this.testProperties(nodeRef, "andy", "andy", "", "", "");
        this.personService.setCreateMissingPeople(true);
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        this.testProperties(this.personService.getPerson("andy"), "andy", "andy", "", "", "");
        PersonTest.assertTrue((boolean)this.personService.personExists("andy"));
        PersonTest.assertTrue((boolean)this.personService.personExists("derek"));
        this.checkPeopleContain("andy");
        this.checkPeopleContain("derek");
        PersonTest.assertEquals((int)4, (int)this.getPeopleCount());
    }

    public void testMutableProperties() {
        PersonTest.assertEquals((int)5, (int)this.personService.getMutableProperties().size());
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_HOMEFOLDER));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_FIRSTNAME));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_LASTNAME));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_EMAIL));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_ORGID));
    }

    public void testPersonCRUD1() {
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.getPerson("derek");
            PersonTest.fail((String)"Getting Derek should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testPersonCRUD2() {
        this.personService.setCreateMissingPeople(false);
        this.personService.createPerson(this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_");
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        PersonTest.assertEquals((int)3, (int)this.getPeopleCount());
        this.checkPeopleContain("derek");
        PersonTest.assertEquals((int)1, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_USERNAME, (Serializable)((Object)"derek"), 10).size());
        PersonTest.assertEquals((int)1, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)"dh@dh"), 10).size());
        PersonTest.assertEquals((int)1, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_ORGID, (Serializable)((Object)"alfresco"), 10).size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_USERNAME, (Serializable)((Object)"glen"), 10).size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)"gj@email.com"), 10).size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_ORGID, (Serializable)((Object)"microsoft"), 10).size());
        this.personService.deletePerson("derek");
        PersonTest.assertEquals((int)2, (int)this.getPeopleCount());
        try {
            this.personService.getPerson("derek");
            PersonTest.fail((String)"Getting Derek should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testPersonCRUD() {
        this.personService.setCreateMissingPeople(false);
        this.personService.createPerson(this.createDefaultProperties("Derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("Derek"), "Derek", "Derek", "Hulley", "dh@dh", "alfresco");
        this.personService.setPersonProperties("Derek", this.createDefaultProperties("notderek", "Derek_", "Hulley_", "dh@dh_", "alfresco_", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("Derek"), "Derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_");
        this.personService.setPersonProperties("Derek", this.createDefaultProperties("notderek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("Derek"), "Derek", "Derek", "Hulley", "dh@dh", "alfresco");
        PersonTest.assertEquals((int)3, (int)this.getPeopleCount());
        this.checkPeopleContain("Derek");
        PersonTest.assertEquals((int)1, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_USERNAME, (Serializable)((Object)"Derek"), 10).size());
        PersonTest.assertEquals((int)1, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)"dh@dh"), 10).size());
        PersonTest.assertEquals((int)1, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_ORGID, (Serializable)((Object)"alfresco"), 10).size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_USERNAME, (Serializable)((Object)"Glen"), 10).size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)"gj@email.com"), 10).size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeopleFilteredByProperty(ContentModel.PROP_ORGID, (Serializable)((Object)"microsoft"), 10).size());
        PersonTest.assertEquals((boolean)this.personService.personExists("derek"), (boolean)EqualsHelper.nullSafeEquals((Object)this.personService.getUserIdentifier("derek"), (Object)"Derek"));
        PersonTest.assertEquals((boolean)this.personService.personExists("dEREK"), (boolean)EqualsHelper.nullSafeEquals((Object)this.personService.getUserIdentifier("dEREK"), (Object)"Derek"));
        PersonTest.assertEquals((boolean)this.personService.personExists("DEREK"), (boolean)EqualsHelper.nullSafeEquals((Object)this.personService.getUserIdentifier("DEREK"), (Object)"Derek"));
        this.personService.deletePerson("Derek");
        PersonTest.assertEquals((int)2, (int)this.getPeopleCount());
    }

    public void testPeopleFiltering() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertEquals((int)2, (int)this.getPeopleCount());
        this.checkPeopleContain(AuthenticationUtil.getAdminUserName());
        this.checkPeopleContain(AuthenticationUtil.getGuestUserName());
        this.personService.createPerson(this.createDefaultProperties("aa", "Aa", "Aa", "aa@aa", "alfresco", this.rootNodeRef));
        this.personService.createPerson(this.createDefaultProperties("bc", "c", "C", "bc@bc", "alfresco", this.rootNodeRef));
        this.personService.createPerson(this.createDefaultProperties("yy", "B", "D", "yy@yy", "alfresco", this.rootNodeRef));
        this.personService.createPerson(this.createDefaultProperties("Yz", "yz", "B", "yz@yz", "alfresco", this.rootNodeRef));
        PersonTest.assertEquals((int)6, (int)this.getPeopleCount());
        PagingRequest pr = new PagingRequest(100, null);
        ArrayList<Pair<QName, String>> filters = new ArrayList<Pair<QName, String>>(4);
        filters.clear();
        filters.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)"y"));
        PersonTest.assertEquals((int)2, (int)this.personService.getPeople(filters, true, null, pr).getPage().size());
        PersonTest.assertEquals((int)1, (int)this.personService.getPeople(filters, false, null, pr).getPage().size());
        filters.clear();
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)"b"));
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)"b"));
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_LASTNAME, (Object)"b"));
        PersonTest.assertEquals((int)3, (int)this.personService.getPeople(filters, true, null, pr).getPage().size());
        PersonTest.assertEquals((int)1, (int)this.personService.getPeople(filters, false, null, pr).getPage().size());
        filters.clear();
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)"A"));
        PersonTest.assertEquals((int)2, (int)this.personService.getPeople(filters, true, null, pr).getPage().size());
        PersonTest.assertEquals((int)0, (int)this.personService.getPeople(filters, false, null, pr).getPage().size());
        this.personService.deletePerson("aa");
        filters.clear();
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)"a"));
        PersonTest.assertEquals((int)1, (int)this.personService.getPeople(filters, true, null, pr).getPage().size());
        filters.clear();
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)"a*"));
        PersonTest.assertEquals((int)1, (int)this.personService.getPeople(filters, true, null, pr).getPage().size());
        filters.clear();
        filters.add((Pair<QName, String>)new Pair((Object)ContentModel.PROP_USERNAME, (Object)"*"));
        PersonTest.assertEquals((int)5, (int)this.getPeopleCount());
        PersonTest.assertEquals((int)5, (int)this.personService.getPeople(filters, true, null, pr).getPage().size());
    }

    public void testPeopleSortingPaging() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertEquals((int)2, (int)this.getPeopleCount());
        NodeRef p1 = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        NodeRef p2 = this.personService.getPerson(AuthenticationUtil.getGuestUserName());
        NodeRef p3 = this.personService.createPerson(this.createDefaultProperties("aa", "Aa", "Aa", "aa@aa", "alfresco", this.rootNodeRef));
        NodeRef p4 = this.personService.createPerson(this.createDefaultProperties("cc", "Cc", "Cc", "cc@cc", "alfresco", this.rootNodeRef));
        NodeRef p5 = this.personService.createPerson(this.createDefaultProperties("hh", "Hh", "Hh", "hh@hh", "alfresco", this.rootNodeRef));
        NodeRef p6 = this.personService.createPerson(this.createDefaultProperties("bb", "Bb", "Bb", "bb@bb", "alfresco", this.rootNodeRef));
        NodeRef p7 = this.personService.createPerson(this.createDefaultProperties("dd", "Dd", "Dd", "dd@dd", "alfresco", this.rootNodeRef));
        PersonTest.assertEquals((int)7, (int)this.getPeopleCount());
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>(1);
        sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        PagingRequest pr = new PagingRequest(0, 2, null);
        PagingResults<PersonService.PersonInfo> ppr = this.personService.getPeople(null, true, sort, pr);
        List results = ppr.getPage();
        PersonTest.assertEquals((int)2, (int)results.size());
        PersonTest.assertEquals((Object)p3, (Object)((PersonService.PersonInfo)results.get(0)).getNodeRef());
        PersonTest.assertEquals((Object)p1, (Object)((PersonService.PersonInfo)results.get(1)).getNodeRef());
        pr = new PagingRequest(2, 2, null);
        ppr = this.personService.getPeople(null, true, sort, pr);
        results = ppr.getPage();
        PersonTest.assertEquals((int)2, (int)results.size());
        PersonTest.assertEquals((Object)p6, (Object)((PersonService.PersonInfo)results.get(0)).getNodeRef());
        PersonTest.assertEquals((Object)p4, (Object)((PersonService.PersonInfo)results.get(1)).getNodeRef());
        pr = new PagingRequest(4, 2, null);
        ppr = this.personService.getPeople(null, true, sort, pr);
        results = ppr.getPage();
        PersonTest.assertEquals((int)2, (int)results.size());
        PersonTest.assertEquals((Object)p7, (Object)((PersonService.PersonInfo)results.get(0)).getNodeRef());
        PersonTest.assertEquals((Object)p2, (Object)((PersonService.PersonInfo)results.get(1)).getNodeRef());
        pr = new PagingRequest(6, 2, null);
        ppr = this.personService.getPeople(null, true, sort, pr);
        results = ppr.getPage();
        PersonTest.assertEquals((int)1, (int)results.size());
        PersonTest.assertEquals((Object)p5, (Object)((PersonService.PersonInfo)results.get(0)).getNodeRef());
    }

    private void testProperties(NodeRef nodeRef, String userName, String firstName, String lastName, String email, String orgId) {
        PersonTest.assertEquals((String)userName, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME))));
        PersonTest.assertNotNull((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_HOMEFOLDER));
        PersonTest.assertEquals((String)firstName, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME))));
        PersonTest.assertEquals((String)lastName, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME))));
        PersonTest.assertEquals((String)email, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EMAIL))));
        PersonTest.assertEquals((String)orgId, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ORGID))));
    }

    private Map<QName, Serializable> createDefaultProperties(String userName, String firstName, String lastName, String email, String orgId, NodeRef home) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_HOMEFOLDER, (Serializable)home);
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)firstName));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)lastName));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)email));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)orgId));
        return properties;
    }

    public void testCaseSensitive() {
        NodeRef nodeRef;
        this.personService.createPerson(this.createDefaultProperties("Derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        try {
            nodeRef = this.personService.getPerson("derek");
            if (this.personService.getUserIdentifier("derek").equals("Derek")) {
                PersonTest.assertNotNull((Object)nodeRef);
            } else {
                PersonTest.assertNotNull(null);
            }
        }
        catch (PersonException pe) {
            // empty catch block
        }
        try {
            nodeRef = this.personService.getPerson("deRek");
            if (this.personService.getUserIdentifier("deRek").equals("Derek")) {
                PersonTest.assertNotNull((Object)nodeRef);
            } else {
                PersonTest.assertNotNull(null);
            }
        }
        catch (PersonException pe) {
            // empty catch block
        }
        try {
            nodeRef = this.personService.getPerson("DEREK");
            if (this.personService.getUserIdentifier("DEREK").equals("Derek")) {
                PersonTest.assertNotNull((Object)nodeRef);
            } else {
                PersonTest.assertNotNull(null);
            }
        }
        catch (PersonException personException) {
            // empty catch block
        }
        this.personService.getPerson("Derek");
    }

    public void testReadOnlyTransactionHandling() throws Exception {
        this.testTX.commit();
        boolean createMissingPeople = this.personService.createMissingPeople();
        PersonTest.assertTrue((String)"Default should be to create missing people", (boolean)createMissingPeople);
        String username = "Derek";
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deletePersonWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                PersonTest.this.personService.deletePerson("Derek");
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deletePersonWork, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> getMissingPersonWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return PersonTest.this.personService.getPerson("Derek");
            }
        };
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(getMissingPersonWork, true, true);
            PersonTest.fail((String)"Expected auto-creation of person to fail gracefully");
        }
        catch (NoSuchPersonException e) {
            // empty catch block
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction(getMissingPersonWork, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deletePersonWork, false, true);
    }

    public void xtestSplitPersonCleanupManyTimes() throws Throwable {
        for (int i = 0; i < 100; ++i) {
            try {
                this.forceSplitPersonCleanup();
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed on iteration " + i + " of forcing split person.", e);
            }
        }
    }

    private void forceSplitPersonCleanup() throws Exception {
        this.testTX.commit();
        boolean createMissingPeople = this.personService.createMissingPeople();
        PersonTest.assertTrue((String)"Default should be to create missing people", (boolean)createMissingPeople);
        PersonServiceImpl personServiceImpl = (PersonServiceImpl)this.personService;
        personServiceImpl.setDuplicateMode("LEAVE");
        final String duplicateUsername = GUID.generate();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deletePersonWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                PersonTest.this.personService.deletePerson(duplicateUsername);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deletePersonWork, false, true);
        int threadCount = 10;
        final CountDownLatch startLatch = new CountDownLatch(threadCount);
        final CountDownLatch endLatch = new CountDownLatch(threadCount);
        final ConcurrentHashMap cleanableNodeRefs = new ConcurrentHashMap(17);
        Runnable createPersonRunnable = new Runnable(){

            @Override
            public void run() {
                RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createPersonWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                    @Override
                    public NodeRef execute() throws Throwable {
                        try {
                            startLatch.await();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        NodeRef personNodeRef = PersonTest.this.personService.getPerson(duplicateUsername);
                        return personNodeRef;
                    }
                };
                startLatch.countDown();
                try {
                    NodeRef nodeRef = PersonTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(createPersonWork, false, true);
                    String threadName = Thread.currentThread().getName();
                    cleanableNodeRefs.put(threadName, nodeRef);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                endLatch.countDown();
            }
        };
        for (int i = 0; i < threadCount; ++i) {
            Thread thread = new Thread(createPersonRunnable);
            thread.setName(this.getName() + "-" + i);
            thread.setDaemon(true);
            thread.start();
        }
        try {
            endLatch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        personServiceImpl.setDuplicateMode("DELETE");
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> getPersonWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return PersonTest.this.personService.getPerson(duplicateUsername);
            }
        };
        final NodeRef remainingNodeRef = this.transactionService.getRetryingTransactionHelper().doInTransaction(getPersonWork, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                for (NodeRef nodeRef : cleanableNodeRefs.values()) {
                    if (nodeRef.equals((Object)remainingNodeRef) || !PersonTest.this.nodeService.exists(nodeRef)) continue;
                    Assert.fail((String)("Expected unused person noderef to have been cleaned up: " + nodeRef));
                }
                return null;
            }
        }, true, true);
    }

    public void testSplitDuplicates() throws Exception {
        this.testProcessDuplicates(true);
        SplitPersonCleanupBootstrapBean splitPersonBean = new SplitPersonCleanupBootstrapBean();
        splitPersonBean.setNodeService(this.nodeService);
        splitPersonBean.setPersonService(this.personService);
        splitPersonBean.setTransactionService(this.transactionService);
        Assert.assertEquals((int)9, (int)splitPersonBean.removePeopleWithGUIDBasedIds());
    }

    public void testDeleteDuplicates() throws Exception {
        this.testProcessDuplicates(false);
    }

    private void testProcessDuplicates(final boolean split) throws Exception {
        this.testTX.commit();
        ((PersonServiceImpl)this.personService).setDuplicateMode(split ? "SPLIT" : "DELETE");
        final String duplicateUserName = GUID.generate();
        final NodeRef[] duplicates = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NodeRef[] execute() throws Throwable {
                NodeRef[] duplicates = new NodeRef[10];
                Map properties = PersonTest.this.createDefaultProperties(duplicateUserName, "firstName", "lastName", "email@orgId", "orgId", null);
                duplicates[0] = PersonTest.this.personService.createPerson(properties);
                ChildAssociationRef container = PersonTest.this.nodeService.getPrimaryParent(duplicates[0]);
                List parents = PersonTest.this.nodeService.getParentAssocs(duplicates[0]);
                try {
                    PersonTest.this.policyBehaviourFilter.disableBehaviour(ContentModel.TYPE_PERSON);
                    for (int i = 1; i < duplicates.length; ++i) {
                        duplicates[i] = PersonTest.this.nodeService.createNode(container.getParentRef(), container.getTypeQName(), container.getQName(), ContentModel.TYPE_PERSON, properties).getChildRef();
                        for (ChildAssociationRef parent : parents) {
                            if (parent.isPrimary()) continue;
                            PersonTest.this.nodeService.addChild(parent.getParentRef(), duplicates[i], parent.getTypeQName(), parent.getQName());
                        }
                    }
                }
                finally {
                    PersonTest.this.policyBehaviourFilter.enableBehaviour(ContentModel.TYPE_PERSON);
                }
                Assert.assertEquals((Object)duplicates[duplicates.length - 1], (Object)PersonTest.this.personService.getPerson(duplicateUserName));
                return duplicates;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (int i = 0; i < duplicates.length - 1; ++i) {
                    if (split) {
                        String newUserName = (String)((Object)PersonTest.this.nodeService.getProperty(duplicates[i], ContentModel.PROP_USERNAME));
                        Assert.assertNotSame((Object)duplicateUserName, (Object)newUserName);
                        continue;
                    }
                    Assert.assertFalse((boolean)PersonTest.this.nodeService.exists(duplicates[i]));
                }
                Assert.assertTrue((boolean)PersonTest.this.personService.personExists(duplicateUserName));
                PersonTest.this.personService.deletePerson(duplicateUserName);
                return null;
            }
        }, false, true);
    }

    public void testCheckForDuplicateCaseInsensitive() {
        block8: {
            NodeRef personRef;
            HashMap<QName, Serializable> personProps;
            String TEST_PERSON_UPPER;
            block7: {
                String TEST_PERSON_LOWER;
                block6: {
                    String TEST_PERSON_MIXED = "Test_Person_One";
                    TEST_PERSON_UPPER = "Test_Person_One".toUpperCase();
                    TEST_PERSON_LOWER = "Test_Person_One".toLowerCase();
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    NodeRef peopleContainer = this.personService.getPeopleContainer();
                    personProps = new HashMap<QName, Serializable>();
                    personProps.put(ContentModel.PROP_HOMEFOLDER, (Serializable)peopleContainer);
                    personProps.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"test first name"));
                    personProps.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)"test last name"));
                    personProps.put(ContentModel.PROP_SIZE_CURRENT, Integer.valueOf(0));
                    RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            if (!PersonTest.this.personService.personExists(TEST_PERSON_UPPER)) {
                                personProps.put(ContentModel.PROP_USERNAME, "Test_Person_One");
                                PersonTest.this.personService.createPerson(personProps);
                            }
                            return null;
                        }
                    };
                    txnHelper.doInTransaction(callback);
                    personRef = null;
                    try {
                        ChildAssociationRef childAssocRef = this.nodeService.createNode(peopleContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testperson"), ContentModel.TYPE_PERSON, personProps);
                        PersonTest.fail((String)"Shouldn't be able to create person node directly (within people container) - use createPerson instead");
                    }
                    catch (AlfrescoRuntimeException are) {
                        if (are.getMessage().contains("use PersonService")) break block6;
                        throw are;
                    }
                }
                try {
                    personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)TEST_PERSON_LOWER));
                    personRef = this.personService.createPerson(personProps);
                    PersonTest.fail((String)"Shouldn't be able to create duplicate person");
                }
                catch (AlfrescoRuntimeException are) {
                    if (are.getMessage().contains("already exists")) break block7;
                    throw are;
                }
            }
            try {
                personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)TEST_PERSON_UPPER));
                personRef = this.personService.createPerson(personProps);
                PersonTest.fail((String)"Shouldn't be able to create duplicate person");
            }
            catch (AlfrescoRuntimeException are) {
                if (are.getMessage().contains("already exists")) break block8;
                throw are;
            }
        }
    }

    public void testCheckForDuplicateCaseSensitive() {
        block8: {
            NodeRef personRef;
            HashMap<QName, Serializable> personProps;
            block7: {
                String TEST_PERSON_LOWER;
                block6: {
                    String TEST_PERSON_MIXED = "Test_Person_Two";
                    String TEST_PERSON_UPPER = "Test_Person_Two".toUpperCase();
                    TEST_PERSON_LOWER = "Test_Person_Two".toLowerCase();
                    this.userNameMatcher.setUserNamesAreCaseSensitive(true);
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    NodeRef peopleContainer = this.personService.getPeopleContainer();
                    personProps = new HashMap<QName, Serializable>();
                    personProps.put(ContentModel.PROP_HOMEFOLDER, (Serializable)peopleContainer);
                    personProps.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"test first name"));
                    personProps.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)"test last name"));
                    personProps.put(ContentModel.PROP_SIZE_CURRENT, Integer.valueOf(0));
                    RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            if (!PersonTest.this.personService.personExists("Test_Person_Two")) {
                                personProps.put(ContentModel.PROP_USERNAME, "Test_Person_Two");
                                PersonTest.this.personService.createPerson(personProps);
                            }
                            return null;
                        }
                    };
                    txnHelper.doInTransaction(callback);
                    personRef = null;
                    personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)TEST_PERSON_LOWER));
                    personRef = this.personService.createPerson(personProps);
                    personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)TEST_PERSON_UPPER));
                    personRef = this.personService.createPerson(personProps);
                    try {
                        personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"Test_Person_Two"));
                        personRef = this.personService.createPerson(personProps);
                        PersonTest.fail((String)"Shouldn't be able to create duplicate person");
                    }
                    catch (AlfrescoRuntimeException are) {
                        if (are.getMessage().contains("already exists")) break block6;
                        throw are;
                    }
                }
                try {
                    personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)TEST_PERSON_LOWER));
                    personRef = this.personService.createPerson(personProps);
                    PersonTest.fail((String)"Shouldn't be able to create duplicate person");
                }
                catch (AlfrescoRuntimeException are) {
                    if (are.getMessage().contains("already exists")) break block7;
                    throw are;
                }
            }
            try {
                personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"Test_Person_Two"));
                personRef = this.personService.createPerson(personProps);
                PersonTest.fail((String)"Shouldn't be able to create duplicate person");
            }
            catch (AlfrescoRuntimeException are) {
                if (are.getMessage().contains("already exists")) break block8;
                throw are;
            }
        }
    }

    public void testUpdateUserNameCase() {
        String TEST_PERSON_UPPER = "TEST_PERSON_THREE";
        final String TEST_PERSON_LOWER = "TEST_PERSON_THREE".toLowerCase();
        this.userNameMatcher.setUserNamesAreCaseSensitive(true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        final HashMap<QName, Object> personProps = new HashMap<QName, Object>();
        personProps.put(ContentModel.PROP_HOMEFOLDER, this.rootNodeRef);
        personProps.put(ContentModel.PROP_FIRSTNAME, "test first name ");
        personProps.put(ContentModel.PROP_LASTNAME, "test last name");
        personProps.put(ContentModel.PROP_SIZE_CURRENT, 0);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                personProps.put(ContentModel.PROP_USERNAME, TEST_PERSON_LOWER);
                return PersonTest.this.personService.createPerson(personProps);
            }
        };
        final NodeRef personRef = txnHelper.doInTransaction(callback);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback2 = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PersonTest.this.nodeService.setProperty(personRef, ContentModel.PROP_USERNAME, (Serializable)((Object)"TEST_PERSON_THREE"));
                return null;
            }
        };
        txnHelper.doInTransaction(callback2);
    }

    public void testCheckForIndirectUsage() throws Exception {
        block5: {
            HashMap<QName, Serializable> personProps;
            block4: {
                String TEST_PERSON = "Test_Person_Four";
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                NodeRef peopleContainer = this.personService.getPeopleContainer();
                personProps = new HashMap<QName, Serializable>();
                personProps.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"Test_Person_Four"));
                personProps.put(ContentModel.PROP_HOMEFOLDER, (Serializable)peopleContainer);
                personProps.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)"test first name"));
                personProps.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)"test last name"));
                personProps.put(ContentModel.PROP_SIZE_CURRENT, Integer.valueOf(0));
                try {
                    ChildAssociationRef childAssocRef = this.nodeService.createNode(peopleContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testperson"), ContentModel.TYPE_PERSON, personProps);
                    PersonTest.fail((String)"Shouldn't be able to create person node directly (within people container) - use createPerson instead");
                }
                catch (AlfrescoRuntimeException are) {
                    if (are.getMessage().contains("use PersonService")) break block4;
                    throw are;
                }
            }
            NodeRef personRef = this.personService.createPerson(personProps);
            try {
                this.nodeService.deleteNode(personRef);
                PersonTest.fail((String)"Shouldn't be able to delete person node directly (within people container) - use deletePerson instead");
            }
            catch (AlfrescoRuntimeException are) {
                if (are.getMessage().contains("use PersonService")) break block5;
                throw are;
            }
        }
        this.testTX.rollback();
        this.personService.deletePerson("Test_Person_Four");
    }

    public void testDisableEnablePerson() {
        String userName = GUID.generate();
        this.authenticationDAO.createUser(userName, "abc".toCharArray());
        Map<QName, Serializable> properties = this.createDefaultProperties(userName, "firstName", "lastName", "email@orgId", "orgId", null);
        NodeRef personNodeRef = this.personService.createPerson(properties);
        PersonTest.assertTrue((String)"Person should be enabled.", (boolean)this.authenticationDAO.getEnabled(userName));
        PersonTest.assertFalse((String)"Person should not be disabled.", (boolean)this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED));
        this.authenticationDAO.setEnabled(userName, true);
        PersonTest.assertTrue((String)"Person should be enabled.", (boolean)this.authenticationDAO.getEnabled(userName));
        PersonTest.assertFalse((String)"Person should not be disabled.", (boolean)this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED));
        this.authenticationDAO.setEnabled(userName, false);
        PersonTest.assertFalse((String)"Person should be disabled.", (boolean)this.authenticationDAO.getEnabled(userName));
        PersonTest.assertTrue((String)"Person should be disabled.", (boolean)this.nodeService.hasAspect(personNodeRef, ContentModel.ASPECT_PERSON_DISABLED));
    }

    public void testDisableEnableAdmin() {
        String admin = AuthenticationUtil.getAdminUserName();
        PersonTest.assertTrue((String)"Admin must be enabled", (boolean)this.authenticationDAO.getEnabled(admin));
        this.authenticationDAO.setEnabled(admin, true);
        PersonTest.assertTrue((String)"Admin must be enabled", (boolean)this.authenticationDAO.getEnabled(admin));
        this.authenticationDAO.setEnabled(admin, false);
        PersonTest.assertTrue((String)"Admin must STILL be enabled", (boolean)this.authenticationDAO.getEnabled(admin));
        PersonTest.assertFalse((String)"Admin must be unlocked", (boolean)this.authenticationDAO.getLocked(admin));
        this.authenticationDAO.setLocked(admin, false);
        PersonTest.assertFalse((String)"Admin must be unlocked", (boolean)this.authenticationDAO.getLocked(admin));
        this.authenticationDAO.setLocked(admin, true);
        PersonTest.assertFalse((String)"Admin must STILL be enabled", (boolean)this.authenticationDAO.getLocked(admin));
        PersonTest.assertFalse((String)"Admin account does not expire", (boolean)this.authenticationDAO.getAccountExpires(admin));
        this.authenticationDAO.setAccountExpires(admin, false);
        PersonTest.assertFalse((String)"Admin account does not expire", (boolean)this.authenticationDAO.getAccountExpires(admin));
        this.authenticationDAO.setAccountExpires(admin, true);
        PersonTest.assertFalse((String)"Admin account STILL does not expire", (boolean)this.authenticationDAO.getAccountExpires(admin));
    }

    public void testNotifyPerson() {
        String userName = GUID.generate();
        this.authenticationDAO.createUser(userName, "abc".toCharArray());
        Map<QName, Serializable> properties = this.createDefaultProperties(userName, "firstName", "lastName", "email@orgId", "orgId", null);
        this.personService.createPerson(properties);
        this.personService.notifyPerson(userName, "abc");
    }

    public void testRenameUser() throws Exception {
        this.testTX.commit();
        String username = AuthenticationUtil.getAdminUserName();
        final String oldUsername = GUID.generate();
        final String newUsername = oldUsername + GUID.generate();
        final NodeRef person = this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                if (PersonTest.this.personService.personExists(oldUsername)) {
                    PersonTest.this.personService.deletePerson(oldUsername);
                }
                if (PersonTest.this.personService.personExists(newUsername)) {
                    PersonTest.this.personService.deletePerson(newUsername);
                }
                Map properties = PersonTest.this.createDefaultProperties(oldUsername, "firstName", "lastName", "email@orgId", "orgId", null);
                NodeRef person = PersonTest.this.personService.createPerson(properties);
                Assert.assertEquals((Object)oldUsername, (Object)PersonTest.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                Assert.assertEquals((Object)person, (Object)PersonTest.this.personService.getPerson(oldUsername));
                Assert.assertFalse((String)"new user should not exist yet", (boolean)PersonTest.this.personService.personExists(newUsername));
                return person;
            }
        }, false, true);
        RenameUser renameUser = new RenameUser(){

            @Override
            protected void exit(int status) {
                Assert.assertEquals((String)"Tool exit status should be normal", (int)0, (int)status);
            }
        };
        renameUser.setLogin(false);
        renameUser.start(new String[]{"-user", username, oldUsername, newUsername});
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                String newUserName = (String)((Object)PersonTest.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                Assert.assertEquals((String)newUsername, (String)newUserName);
                Assert.assertEquals((Object)newUsername, (Object)PersonTest.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                Assert.assertEquals((Object)person, (Object)PersonTest.this.personService.getPerson(newUsername));
                Assert.assertFalse((String)"old user should no longer exist", (boolean)PersonTest.this.personService.personExists(oldUsername));
                PersonTest.this.personService.deletePerson(newUsername);
                return null;
            }
        }, false, true);
    }
}

