/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.service;

import junit.framework.TestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class StoreRedirectorProxyFactoryTest
extends TestCase {
    private ApplicationContext factory = null;

    public void setUp() {
        this.factory = new ClassPathXmlApplicationContext("org/alfresco/repo/service/testredirector.xml");
    }

    public void testRedirect() {
        StoreRef storeRef1 = new StoreRef("Type1", "id");
        StoreRef storeRef2 = new StoreRef("Type2", "id");
        StoreRef storeRef3 = new StoreRef("Type3", "id");
        StoreRef storeRef4 = new StoreRef("Type3", "woof");
        NodeRef nodeRef1 = new NodeRef(storeRef1, "id");
        NodeRef nodeRef2 = new NodeRef(storeRef2, "id");
        TestServiceInterface service = (TestServiceInterface)this.factory.getBean("redirector_service1");
        String result1 = service.defaultBinding("redirector_service1");
        StoreRedirectorProxyFactoryTest.assertEquals((String)"Type1:redirector_service1", (String)result1);
        String result1a = service.noArgs();
        StoreRedirectorProxyFactoryTest.assertEquals((String)"Type1", (String)result1a);
        String result2 = service.storeRef(storeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + storeRef1), (String)result2);
        String result3 = service.storeRef(storeRef2);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type2:" + storeRef2), (String)result3);
        String result4 = service.nodeRef(nodeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + nodeRef1), (String)result4);
        String result5 = service.nodeRef(nodeRef2);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type2:" + nodeRef2), (String)result5);
        String result6 = service.multiStoreRef(storeRef1, storeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + storeRef1 + "," + storeRef1), (String)result6);
        String result7 = service.multiStoreRef(storeRef2, storeRef2);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type2:" + storeRef2 + "," + storeRef2), (String)result7);
        String result8 = service.multiNodeRef(nodeRef1, nodeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + nodeRef1 + "," + nodeRef1), (String)result8);
        String result9 = service.multiNodeRef(nodeRef2, nodeRef2);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type2:" + nodeRef2 + "," + nodeRef2), (String)result9);
        String result10 = service.mixedStoreNodeRef(storeRef1, nodeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + storeRef1 + "," + nodeRef1), (String)result10);
        String result11 = service.mixedStoreNodeRef(storeRef2, nodeRef2);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type2:" + storeRef2 + "," + nodeRef2), (String)result11);
        String result12 = service.mixedStoreNodeRef(null, null);
        StoreRedirectorProxyFactoryTest.assertEquals((String)"Type1:null,null", (String)result12);
        String result13 = service.mixedStoreNodeRef(storeRef1, null);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + storeRef1 + ",null"), (String)result13);
        String result14 = service.storeRef(storeRef3);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type3:" + storeRef3), (String)result14);
        String result15 = service.storeRef(storeRef4);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + storeRef4), (String)result15);
    }

    public void testInvalidArgs() {
        StoreRef defaultRef = new StoreRef("Type1", "id");
        StoreRef storeRef1 = new StoreRef("InvalidType1", "id");
        NodeRef nodeRef1 = new NodeRef(storeRef1, "id");
        TestServiceInterface service = (TestServiceInterface)this.factory.getBean("redirector_service1");
        String result1 = service.storeRef(storeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + storeRef1), (String)result1);
        String result2 = service.nodeRef(nodeRef1);
        StoreRedirectorProxyFactoryTest.assertEquals((String)("Type1:" + nodeRef1), (String)result2);
    }

    public void testException() {
        StoreRef storeRef1 = new StoreRef("Type1", "id");
        NodeRef nodeRef1 = new NodeRef(storeRef1, "id");
        TestServiceInterface service = (TestServiceInterface)this.factory.getBean("redirector_service1");
        try {
            service.throwException(nodeRef1);
            StoreRedirectorProxyFactoryTest.fail((String)"Service method did not throw exception");
        }
        catch (Exception e) {
            StoreRedirectorProxyFactoryTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
            StoreRedirectorProxyFactoryTest.assertEquals((String)nodeRef1.toString(), (String)e.getMessage());
        }
    }

    public static class Type3Component
    extends Component {
        private Type3Component() {
            super("Type3");
        }
    }

    public static class Type2Component
    extends Component {
        private Type2Component() {
            super("Type2");
        }
    }

    public static class Type1Component
    extends Component {
        private Type1Component() {
            super("Type1");
        }
    }

    public static abstract class Component
    implements TestServiceInterface {
        private String type;

        private Component(String type) {
            this.type = type;
        }

        @Override
        public String noArgs() {
            return this.type;
        }

        @Override
        public String defaultBinding(String arg) {
            return this.type + ":" + arg;
        }

        @Override
        public String nodeRef(NodeRef ref1) {
            return this.type + ":" + ref1;
        }

        @Override
        public String storeRef(StoreRef ref1) {
            return this.type + ":" + ref1;
        }

        @Override
        public String multiNodeRef(NodeRef ref1, NodeRef ref2) {
            return this.type + ":" + ref1 + "," + ref2;
        }

        @Override
        public String multiStoreRef(StoreRef ref1, StoreRef ref2) {
            return this.type + ":" + ref1 + "," + ref2;
        }

        @Override
        public String mixedStoreNodeRef(StoreRef ref1, NodeRef ref2) {
            return this.type + ":" + ref1 + "," + ref2;
        }

        @Override
        public void throwException(NodeRef ref1) {
            throw new IllegalArgumentException(ref1.toString());
        }
    }

    public static interface TestServiceInterface {
        public String noArgs();

        public String defaultBinding(String var1);

        public String storeRef(StoreRef var1);

        public String nodeRef(NodeRef var1);

        public String multiStoreRef(StoreRef var1, StoreRef var2);

        public String multiNodeRef(NodeRef var1, NodeRef var2);

        public String mixedStoreNodeRef(StoreRef var1, NodeRef var2);

        public void throwException(NodeRef var1);
    }
}

