/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.HashMap;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.alfresco.util.test.junitrules.TemporarySitesTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.extensions.webscripts.GUID;

public class SiteServiceImplMoreTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath:sites/test-" + TemporarySitesTest.class.getSimpleName() + "-context.xml");
    public static TemporarySites STATIC_TEST_SITES = new TemporarySites(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain staticRuleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)STATIC_TEST_SITES);
    public RunAsFullyAuthenticatedRule runAllTestsAsAdmin = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    public AlfrescoPerson testUser = new AlfrescoPerson(APP_CONTEXT_INIT);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.runAllTestsAsAdmin).around((TestRule)this.testUser);
    private static NamespaceService NAMESPACE_SERVICE;
    private static SiteService SITE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static String TEST_SITE_NAME;
    private static String TEST_SUB_SITE_NAME;
    private static TemporarySites.TestSiteAndMemberInfo TEST_SITE_WITH_MEMBERS;

    @BeforeClass
    public static void initStaticData() throws Exception {
        NAMESPACE_SERVICE = (NamespaceService)APP_CONTEXT_INIT.getApplicationContext().getBean("namespaceService", NamespaceService.class);
        SITE_SERVICE = (SiteService)APP_CONTEXT_INIT.getApplicationContext().getBean("siteService", SiteService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        String admin = AuthenticationUtil.getAdminUserName();
        TEST_SITE_NAME = GUID.generate();
        TEST_SUB_SITE_NAME = GUID.generate();
        QName subSiteType = QName.createQName((String)"testsite", (String)"testSubsite", (NamespacePrefixResolver)NAMESPACE_SERVICE);
        STATIC_TEST_SITES.createSite("sitePreset", TEST_SITE_NAME, "siteTitle", "siteDescription", SiteVisibility.PUBLIC, admin);
        STATIC_TEST_SITES.createSite("sitePreset", TEST_SUB_SITE_NAME, "siteTitle", "siteDescription", SiteVisibility.PUBLIC, subSiteType, admin);
        TEST_SITE_WITH_MEMBERS = STATIC_TEST_SITES.createTestSiteWithUserPerRole(SiteServiceImplMoreTest.class.getSimpleName(), "sitePreset", SiteVisibility.PUBLIC, admin);
    }

    @Test
    public void listSitesIncludingSubTypesOfSite() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PagingResults<SiteInfo> sites = SITE_SERVICE.listSites(null, null, new PagingRequest(0, 1024));
                HashMap<String, SiteInfo> sitesByName = new HashMap<String, SiteInfo>();
                for (SiteInfo site : sites.getPage()) {
                    sitesByName.put(site.getShortName(), site);
                }
                Assert.assertNotNull((String)"st:site missing.", sitesByName.get(TEST_SITE_NAME));
                Assert.assertNotNull((String)"subtype of st:site missing.", sitesByName.get(TEST_SUB_SITE_NAME));
                return null;
            }
        });
    }

    @Test
    public void anySiteManagerShouldBeAbleToDeleteASite() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                SITE_SERVICE.setMembership(TEST_SITE_WITH_MEMBERS.siteInfo.getShortName(), SiteServiceImplMoreTest.this.testUser.getUsername(), "SiteManager");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        SITE_SERVICE.deleteSite(TEST_SITE_WITH_MEMBERS.siteInfo.getShortName());
                        return null;
                    }
                }, (String)SiteServiceImplMoreTest.this.testUser.getUsername());
                return null;
            }
        });
    }
}

