/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.subscriptions;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.subscriptions.SubscriptionsDAO;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.PagingSubscriptionResults;
import org.alfresco.service.cmr.subscriptions.PrivateSubscriptionListException;
import org.alfresco.service.cmr.subscriptions.SubscriptionItemTypeEnum;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.cmr.subscriptions.SubscriptionsDisabledException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;

public class SubscriptionServiceImpl
implements SubscriptionService {
    private static Log logger = LogFactory.getLog(SubscriptionServiceImpl.class);
    private static final String ACTIVITY_TOOL = "subscriptionService";
    private static final String FOLLOWER_FIRSTNAME = "followerFirstName";
    private static final String FOLLOWER_LASTNAME = "followerLastName";
    private static final String FOLLOWER_USERNAME = "followerUserName";
    private static final String FOLLOWER_JOBTITLE = "followerJobTitle";
    private static final String USER_FIRSTNAME = "userFirstName";
    private static final String USER_LASTNAME = "userLastName";
    private static final String USER_USERNAME = "userUserName";
    private static final String FOLLOWING_COUNT = "followingCount";
    private static final String FOLLOWER_COUNT = "followerCount";
    private static final String SUBSCRIBER_FIRSTNAME = "subscriberFirstName";
    private static final String SUBSCRIBER_LASTNAME = "subscriberLastName";
    private static final String SUBSCRIBER_USERNAME = "subscriberUserName";
    private static final String NODE = "node";
    protected SubscriptionsDAO subscriptionsDAO;
    protected NodeService nodeService;
    protected PersonService personService;
    protected ActivityService activityService;
    protected AuthorityService authorityService;
    protected ActionService actionService;
    protected SearchService searchService;
    protected NamespaceService namespaceService;
    protected FileFolderService fileFolderService;
    protected boolean active;

    public void setSubscriptionsDAO(SubscriptionsDAO subscriptionsDAO) {
        this.subscriptionsDAO = subscriptionsDAO;
    }

    public final void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public final void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public final void setActivityService(ActivityService activictyService) {
        this.activityService = activictyService;
    }

    public final void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public final void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public final void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public final void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public final void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public PagingSubscriptionResults getSubscriptions(String userId, SubscriptionItemTypeEnum type, PagingRequest pagingRequest) {
        this.checkEnabled();
        this.checkRead(userId, true);
        return this.subscriptionsDAO.selectSubscriptions(userId, type, pagingRequest);
    }

    @Override
    public int getSubscriptionCount(String userId, SubscriptionItemTypeEnum type) {
        this.checkEnabled();
        this.checkRead(userId, true);
        return this.subscriptionsDAO.countSubscriptions(userId, type);
    }

    @Override
    public void subscribe(String userId, NodeRef node) {
        this.checkEnabled();
        this.checkWrite(userId);
        this.checkUserNode(node);
        this.subscriptionsDAO.insertSubscription(userId, node);
        if (userId.equalsIgnoreCase(AuthenticationUtil.getRunAsUser())) {
            String activityDataJSON = null;
            try {
                NodeRef subscriberNode = this.personService.getPerson(userId, false);
                JSONObject activityData = new JSONObject();
                activityData.put(SUBSCRIBER_USERNAME, (Object)userId);
                activityData.put(SUBSCRIBER_FIRSTNAME, (Object)this.nodeService.getProperty(subscriberNode, ContentModel.PROP_FIRSTNAME));
                activityData.put(SUBSCRIBER_LASTNAME, (Object)this.nodeService.getProperty(subscriberNode, ContentModel.PROP_LASTNAME));
                activityData.put(NODE, (Object)node.toString());
                activityDataJSON = activityData.toString();
            }
            catch (JSONException je) {
                logger.error((Object)("Failed to get activity data: " + (Object)((Object)je)));
            }
            this.activityService.postActivity("org.alfresco.subscriptions.subscribed", null, ACTIVITY_TOOL, activityDataJSON);
        }
    }

    @Override
    public void unsubscribe(String userId, NodeRef node) {
        this.checkEnabled();
        this.checkWrite(userId);
        this.subscriptionsDAO.deleteSubscription(userId, node);
    }

    @Override
    public boolean hasSubscribed(String userId, NodeRef node) {
        this.checkEnabled();
        this.checkRead(userId, true);
        return this.subscriptionsDAO.hasSubscribed(userId, node);
    }

    @Override
    public PagingFollowingResults getFollowing(String userId, PagingRequest pagingRequest) {
        this.checkEnabled();
        this.checkRead(userId, true);
        return this.subscriptionsDAO.selectFollowing(userId, pagingRequest);
    }

    @Override
    public int getFollowingCount(String userId) {
        this.checkEnabled();
        this.checkRead(userId, true);
        return this.getSubscriptionCount(userId, SubscriptionItemTypeEnum.USER);
    }

    @Override
    public PagingFollowingResults getFollowers(String userId, PagingRequest pagingRequest) {
        this.checkEnabled();
        this.checkRead(userId, false);
        return this.subscriptionsDAO.selectFollowers(userId, pagingRequest);
    }

    @Override
    public int getFollowersCount(String userId) {
        this.checkEnabled();
        this.checkRead(userId, false);
        return this.subscriptionsDAO.countFollowers(userId);
    }

    @Override
    public void follow(String userId, String userToFollow) {
        this.checkEnabled();
        this.checkWrite(userId);
        this.subscriptionsDAO.insertSubscription(userId, this.getUserNodeRef(userToFollow));
        if (userId.equalsIgnoreCase(AuthenticationUtil.getRunAsUser())) {
            try {
                String activityDataJSON = null;
                NodeRef followerNode = this.personService.getPerson(userId, false);
                NodeRef userNode = this.personService.getPerson(userToFollow, false);
                JSONObject activityData = new JSONObject();
                activityData.put(FOLLOWER_USERNAME, (Object)userId);
                activityData.put(FOLLOWER_FIRSTNAME, (Object)this.nodeService.getProperty(followerNode, ContentModel.PROP_FIRSTNAME));
                activityData.put(FOLLOWER_LASTNAME, (Object)this.nodeService.getProperty(followerNode, ContentModel.PROP_LASTNAME));
                activityData.put(USER_USERNAME, (Object)userToFollow);
                activityData.put(USER_FIRSTNAME, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_FIRSTNAME));
                activityData.put(USER_LASTNAME, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_LASTNAME));
                activityDataJSON = activityData.toString();
                this.activityService.postActivity("org.alfresco.subscriptions.followed", null, ACTIVITY_TOOL, activityDataJSON);
            }
            catch (JSONException je) {
                logger.error((Object)("Failed to get activity data: " + (Object)((Object)je)));
            }
            try {
                this.sendFollowingMail(userId, userToFollow);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send following email: " + e));
            }
        }
    }

    @Override
    public void unfollow(String userId, String userToUnfollow) {
        this.checkEnabled();
        this.checkWrite(userId);
        this.subscriptionsDAO.deleteSubscription(userId, this.getUserNodeRef(userToUnfollow));
    }

    @Override
    public boolean follows(String userId, String userToFollow) {
        this.checkEnabled();
        this.checkRead(userId, true);
        return this.subscriptionsDAO.hasSubscribed(userId, this.getUserNodeRef(userToFollow));
    }

    @Override
    public void setSubscriptionListPrivate(String userId, boolean isPrivate) {
        this.checkEnabled();
        this.checkWrite(userId);
        this.nodeService.setProperty(this.getUserNodeRef(userId), ContentModel.PROP_SUBSCRIPTIONS_PRIVATE, (Serializable)Boolean.valueOf(isPrivate));
    }

    @Override
    public boolean isSubscriptionListPrivate(String userId) {
        this.checkEnabled();
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        Serializable privateList = this.nodeService.getProperty(this.getUserNodeRef(userId), ContentModel.PROP_SUBSCRIPTIONS_PRIVATE);
        if (privateList == null) {
            return false;
        }
        return !(privateList instanceof Boolean) || (Boolean)privateList != false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected void checkEnabled() {
        if (!this.isActive()) {
            throw new SubscriptionsDisabledException("subscription_service.err.disabled");
        }
    }

    protected void checkRead(String userId, boolean checkPrivate) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        if (!checkPrivate) {
            return;
        }
        String currentUser = AuthenticationUtil.getRunAsUser();
        if (currentUser == null) {
            throw new IllegalArgumentException("No current user!");
        }
        if (currentUser.equalsIgnoreCase(userId) || this.authorityService.isAdminAuthority(currentUser) || AuthenticationUtil.isRunAsUserTheSystemUser() || !this.isSubscriptionListPrivate(userId)) {
            return;
        }
        throw new PrivateSubscriptionListException("subscription_service.err.private-list");
    }

    protected void checkWrite(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("User Id may not be null!");
        }
        String currentUser = AuthenticationUtil.getRunAsUser();
        if (currentUser == null) {
            throw new IllegalArgumentException("No current user!");
        }
        if (currentUser.equalsIgnoreCase(userId) || this.authorityService.isAdminAuthority(currentUser) || AuthenticationUtil.isRunAsUserTheSystemUser()) {
            return;
        }
        throw new AccessDeniedException("subscription_service.err.write-denied");
    }

    protected NodeRef getUserNodeRef(String userId) {
        return this.personService.getPerson(userId, false);
    }

    protected void checkUserNode(NodeRef nodeRef) {
        if (!ContentModel.TYPE_USER.equals((Object)this.nodeService.getType(nodeRef))) {
            throw new IllegalArgumentException("Only user nodes supported!");
        }
    }

    protected void sendFollowingMail(String userId, String userToFollow) {
        NodeRef followerNode = this.personService.getPerson(userId, false);
        NodeRef userNode = this.personService.getPerson(userToFollow, false);
        Serializable emailFeedDisabled = this.nodeService.getProperty(userNode, ContentModel.PROP_EMAIL_FEED_DISABLED);
        if (emailFeedDisabled instanceof Boolean && ((Boolean)emailFeedDisabled).booleanValue()) {
            return;
        }
        Serializable emailAddress = this.nodeService.getProperty(userNode, ContentModel.PROP_EMAIL);
        if (emailAddress == null) {
            return;
        }
        NodeRef templateNodeRef = this.getEmailTemplateRef();
        if (templateNodeRef == null) {
            return;
        }
        String followerFullName = (this.nodeService.getProperty(followerNode, ContentModel.PROP_FIRSTNAME) + " " + this.nodeService.getProperty(followerNode, ContentModel.PROP_LASTNAME)).trim();
        String subjectText = I18NUtil.getMessage((String)"subscription.notification.email.subject", (Object[])new Object[]{followerFullName});
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(FOLLOWER_USERNAME, userId);
        model.put(FOLLOWER_FIRSTNAME, this.nodeService.getProperty(followerNode, ContentModel.PROP_FIRSTNAME));
        model.put(FOLLOWER_LASTNAME, this.nodeService.getProperty(followerNode, ContentModel.PROP_LASTNAME));
        model.put(FOLLOWER_JOBTITLE, this.nodeService.getProperty(followerNode, ContentModel.PROP_JOBTITLE));
        model.put(USER_USERNAME, userToFollow);
        model.put(USER_FIRSTNAME, this.nodeService.getProperty(userNode, ContentModel.PROP_FIRSTNAME));
        model.put(USER_LASTNAME, this.nodeService.getProperty(userNode, ContentModel.PROP_LASTNAME));
        model.put(FOLLOWING_COUNT, -1);
        try {
            model.put(FOLLOWING_COUNT, this.getFollowingCount(userId));
        }
        catch (Exception e) {
            // empty catch block
        }
        model.put(FOLLOWER_COUNT, -1);
        try {
            model.put(FOLLOWER_COUNT, this.getFollowersCount(userId));
        }
        catch (Exception e) {
            // empty catch block
        }
        Action mail = this.actionService.createAction("mail");
        mail.setParameterValue("to", emailAddress);
        mail.setParameterValue("subject", (Serializable)((Object)subjectText));
        mail.setParameterValue("template", (Serializable)templateNodeRef);
        mail.setParameterValue("template_model", model);
        mail.setParameterValue("ignore_send_failure", Boolean.valueOf(true));
        this.actionService.executeAction(mail, null, false, true);
    }

    protected NodeRef getEmailTemplateRef() {
        String xpath = "app:company_home/app:dictionary/app:email_templates/app:following/cm:following-email.html.ftl";
        try {
            NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            List nodeRefs = this.searchService.selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() > 1) {
                logger.error((Object)("Found too many email templates using: " + xpath));
                nodeRefs = Collections.singletonList(nodeRefs.get(0));
            } else if (nodeRefs.size() == 0) {
                logger.error((Object)("Cannot find the email template using " + xpath));
                return null;
            }
            NodeRef base = (NodeRef)nodeRefs.get(0);
            NodeRef local = this.fileFolderService.getLocalizedSibling(base);
            return local;
        }
        catch (SearcherException e) {
            logger.error((Object)"Cannot find the email template!", (Throwable)e);
            return null;
        }
    }
}

