/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.ext.dom.NodeModel;
import java.io.Serializable;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.BaseContentNode;
import org.alfresco.repo.template.BasePermissionsNode;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.template.TemplateProperties;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameMap;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLEncoder;
import org.xml.sax.InputSource;

public class AVMTemplateNode
extends BasePermissionsNode
implements NamespacePrefixResolverProvider {
    private static Log logger = LogFactory.getLog(AVMTemplateNode.class);
    private NodeRef nodeRef;
    private String name;
    private QName type;
    private String path;
    private int version;
    private boolean deleted;
    private QNameMap<String, Serializable> properties;
    private boolean propsRetrieved = false;
    private AVMTemplateNode parent = null;
    private AVMNodeDescriptor avmRef;

    public AVMTemplateNode(NodeRef nodeRef, ServiceRegistry services, TemplateImageResolver resolver) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.nodeRef = nodeRef;
        Pair<Integer, String> pair = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        this.services = services;
        this.imageResolver = resolver;
        this.init((Integer)pair.getFirst(), (String)pair.getSecond(), null);
    }

    public AVMTemplateNode(String path, int version, ServiceRegistry services, TemplateImageResolver resolver) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.nodeRef = AVMNodeConverter.ToNodeRef(version, path);
        this.services = services;
        this.imageResolver = resolver;
        this.init(version, path, null);
    }

    public AVMTemplateNode(AVMNodeDescriptor descriptor, ServiceRegistry services, TemplateImageResolver resolver) {
        if (descriptor == null) {
            throw new IllegalArgumentException("AVMNodeDescriptor must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.version = -1;
        this.path = descriptor.getPath();
        this.nodeRef = AVMNodeConverter.ToNodeRef(this.version, this.path);
        this.services = services;
        this.imageResolver = resolver;
        this.init(this.version, this.path, descriptor);
    }

    private void init(int version, String path, AVMNodeDescriptor descriptor) {
        this.version = version;
        this.path = path;
        this.properties = new QNameMap((NamespacePrefixResolverProvider)this);
        if (descriptor == null && (descriptor = this.services.getAVMService().lookup(version, path, true)) == null) {
            throw new IllegalArgumentException("Invalid node specified: " + this.nodeRef.toString());
        }
        this.avmRef = descriptor;
        this.deleted = descriptor.isDeleted();
    }

    @Override
    public String getId() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = AVMNodeConverter.SplitBase(this.path)[1];
        }
        return this.name;
    }

    public String getParentPath() {
        return AVMNodeConverter.SplitBase(this.path)[0];
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public QName getType() {
        if (this.type == null) {
            this.type = !this.deleted ? this.services.getNodeService().getType(this.nodeRef) : (this.avmRef.isDeletedDirectory() ? WCMModel.TYPE_AVM_FOLDER : WCMModel.TYPE_AVM_CONTENT);
        }
        return this.type;
    }

    public boolean getIsDeleted() {
        return this.avmRef.isDeleted();
    }

    public boolean getIsLocked() {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        AVMLockingService.LockState lockStatus = this.services.getAVMLockingService().getLockState(this.getWebProject(), this.path.substring(this.path.indexOf("/")), currentUser);
        return lockStatus != AVMLockingService.LockState.NO_LOCK;
    }

    public boolean getIsLockOwner() {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        AVMLockingService.LockState lockStatus = this.services.getAVMLockingService().getLockState(this.getWebProject(), this.path.substring(this.path.indexOf("/")), currentUser);
        return lockStatus == AVMLockingService.LockState.LOCK_OWNER;
    }

    public boolean getHasLockAccess() {
        return this.services.getAVMLockingService().hasAccess(this.getWebProject(), this.path, this.services.getAuthenticationService().getCurrentUserName());
    }

    @Override
    public TemplateProperties getParent() {
        String parentPath;
        if (this.parent == null && (parentPath = this.getParentPath()) != null) {
            this.parent = new AVMTemplateNode(parentPath, this.version, this.services, this.imageResolver);
        }
        return this.parent;
    }

    @Override
    public boolean getIsContainer() {
        return this.avmRef.isDirectory() || this.avmRef.isDeletedDirectory();
    }

    @Override
    public boolean getIsDocument() {
        return this.avmRef.isFile() || this.avmRef.isDeletedFile();
    }

    @Override
    public List<TemplateProperties> getChildren() {
        if (this.children == null) {
            List childRefs = this.services.getNodeService().getChildAssocs(this.nodeRef);
            this.children = new ArrayList(childRefs.size());
            for (ChildAssociationRef ref : childRefs) {
                AVMTemplateNode child = new AVMTemplateNode(ref.getChildRef(), this.services, this.imageResolver);
                this.children.add(child);
            }
        }
        return this.children;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        if (!this.propsRetrieved) {
            if (!this.deleted) {
                Map<QName, PropertyValue> props = this.services.getAVMService().getNodeProperties(this.version, this.path);
                for (QName qname : props.keySet()) {
                    Serializable propValue;
                    PropertyDefinition propertyDefinition = this.services.getDictionaryService().getProperty(qname);
                    QName currentPropertyType = DataTypeDefinition.ANY;
                    if (null != propertyDefinition) {
                        currentPropertyType = propertyDefinition.getDataType().getName();
                    }
                    if ((propValue = props.get(qname).getValue(currentPropertyType)) instanceof NodeRef) {
                        NodeRef nodeRef = (NodeRef)propValue;
                        propValue = "avm".equals(nodeRef.getStoreRef().getProtocol()) ? new AVMTemplateNode(nodeRef, this.services, this.imageResolver) : new TemplateNode(nodeRef, this.services, this.imageResolver);
                    } else if (propValue instanceof ContentData) {
                        propValue = new BaseContentNode.TemplateContentData(this, (ContentData)propValue, qname);
                    }
                    this.properties.put((Object)qname.toString(), (Object)propValue);
                }
            }
            this.properties.put((Object)"name", (Object)this.avmRef.getName());
            this.properties.put((Object)"created", (Object)new Date(this.avmRef.getCreateDate()));
            this.properties.put((Object)"modified", (Object)new Date(this.avmRef.getModDate()));
            this.properties.put((Object)"creator", (Object)this.avmRef.getCreator());
            this.properties.put((Object)"modifier", (Object)this.avmRef.getLastModifier());
            this.propsRetrieved = true;
        }
        return this.properties;
    }

    @Override
    public Set<QName> getAspects() {
        if (this.aspects == null) {
            this.aspects = this.services.getAVMService().getAspects(this.version, this.path);
        }
        return this.aspects;
    }

    @Override
    public String getContent() {
        ContentReader reader = this.services.getAVMService().getContentReader(this.version, this.path);
        return reader != null && reader.exists() ? reader.getContentString() : "";
    }

    @Override
    public String getUrl() {
        if (this.getIsDocument()) {
            return MessageFormat.format("/d/d/{0}/{1}/{2}/{3}", this.getNodeRef().getStoreRef().getProtocol(), this.getNodeRef().getStoreRef().getIdentifier(), this.getNodeRef().getId(), URLEncoder.encode((String)this.getName()));
        }
        return MessageFormat.format("/n/browse/{0}/{1}/{2}", this.getNodeRef().getStoreRef().getProtocol(), this.getNodeRef().getStoreRef().getIdentifier(), this.getNodeRef().getId());
    }

    @Override
    public String getDownloadUrl() {
        if (this.getIsDocument()) {
            return MessageFormat.format("/d/a/{0}/{1}/{2}/{3}", this.getNodeRef().getStoreRef().getProtocol(), this.getNodeRef().getStoreRef().getIdentifier(), this.getNodeRef().getId(), URLEncoder.encode((String)this.getName()));
        }
        return "";
    }

    @Override
    public String getMimetype() {
        if (this.getIsContainer()) {
            return null;
        }
        return this.services.getAVMService().getContentDataForRead(this.avmRef).getMimetype();
    }

    @Override
    public String getDisplayMimetype() {
        if (this.getIsContainer()) {
            return null;
        }
        String mimetype = this.services.getAVMService().getContentDataForRead(this.avmRef).getMimetype();
        return (String)this.services.getMimetypeService().getDisplaysByMimetype().get(mimetype);
    }

    @Override
    public String getEncoding() {
        if (this.getIsContainer()) {
            return null;
        }
        return this.services.getAVMService().getContentDataForRead(this.avmRef).getEncoding();
    }

    @Override
    public long getSize() {
        if (this.getIsContainer()) {
            return -1L;
        }
        return this.services.getAVMService().getContentDataForRead(this.avmRef).getSize();
    }

    public NodeModel getXmlNodeModel() {
        try {
            return NodeModel.parse((InputSource)new InputSource(new StringReader(this.getContent())));
        }
        catch (Throwable err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)err.getMessage(), err);
            }
            return null;
        }
    }

    @Override
    public String getDisplayPath() {
        return this.path;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.services.getNamespaceService();
    }

    private String getWebProject() {
        String webProject = this.path.substring(0, this.path.indexOf(58));
        int index = webProject.indexOf("--");
        if (index != -1) {
            webProject = webProject.substring(0, index);
        }
        return webProject;
    }
}

