/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.AbstractRoutingContentStore;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantRoutingContentStore;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractTenantRoutingContentStore
extends AbstractRoutingContentStore
implements ApplicationContextAware,
TenantRoutingContentStore {
    private String defaultRootDirectory;
    private TenantAdminDAO tenantAdminDAO;
    private TenantService tenantService;
    private ApplicationContext applicationContext;
    private SimpleCache<String, ContentStore> singletonCache;
    private final String KEY_CONTENT_STORE = "key.tenant.routing.content.store";

    public void setRootLocation(String defaultRootDirectory) {
        this.defaultRootDirectory = defaultRootDirectory;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTenantAdminDAO(TenantAdminDAO tenantAdminDAO) {
        this.tenantAdminDAO = tenantAdminDAO;
    }

    public void setSingletonCache(SimpleCache<String, ContentStore> singletonCache) {
        this.singletonCache = singletonCache;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public String getRootLocation() {
        return this.defaultRootDirectory;
    }

    @Override
    protected ContentStore selectWriteStore(ContentContext ctx) {
        return this.getTenantContentStore();
    }

    @Override
    public List<ContentStore> getAllStores() {
        String currentUser;
        if (this.tenantService.isEnabled() && ((currentUser = AuthenticationUtil.getFullyAuthenticatedUser()) == null || this.tenantService.getBaseNameUser(currentUser).equals(AuthenticationUtil.getSystemUserName()))) {
            final ArrayList<ContentStore> allEnabledStores = new ArrayList<ContentStore>();
            List<TenantEntity> tenants = this.tenantAdminDAO.listTenants();
            for (TenantEntity tenant : tenants) {
                if (!tenant.getEnabled().booleanValue()) continue;
                String tenantDomain = tenant.getTenantDomain();
                TenantUtil.runAsSystemTenant(new TenantUtil.TenantRunAsWork<Void>(){

                    @Override
                    public Void doWork() throws Exception {
                        allEnabledStores.add(AbstractTenantRoutingContentStore.this.getTenantContentStore());
                        return null;
                    }
                }, tenantDomain);
            }
            if (allEnabledStores.size() > 0) {
                allEnabledStores.add(this.getTenantContentStore());
                return allEnabledStores;
            }
        }
        return Arrays.asList(this.getTenantContentStore());
    }

    private ContentStore getTenantContentStore() {
        ContentStore cs = (ContentStore)this.singletonCache.get((Serializable)((Object)"key.tenant.routing.content.store"));
        if (cs == null) {
            this.init();
            cs = (ContentStore)this.singletonCache.get((Serializable)((Object)"key.tenant.routing.content.store"));
        }
        return cs;
    }

    private void putTenantContentStore(ContentStore contentStore) {
        this.singletonCache.put((Serializable)((Object)"key.tenant.routing.content.store"), (Object)contentStore);
    }

    private void removeTenantContentStore() {
        this.singletonCache.remove((Serializable)((Object)"key.tenant.routing.content.store"));
    }

    public void init() {
        String rootDir = this.getRootLocation();
        Tenant tenant = this.tenantService.getTenant(this.tenantService.getCurrentUserDomain());
        if (tenant != null && tenant.getRootContentStoreDir() != null) {
            rootDir = tenant.getRootContentStoreDir();
        }
        this.putTenantContentStore(this.initContentStore(this.applicationContext, rootDir));
    }

    public void destroy() {
        this.removeTenantContentStore();
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    protected abstract ContentStore initContentStore(ApplicationContext var1, String var2);
}

