/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.springframework.context.ApplicationContext;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class RepoUsageComponentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static final Log logger = LogFactory.getLog(RepoUsageComponentTest.class);
    private TransactionService transactionService;
    private RepoUsageComponent repoUsageComponent;
    private JobLockService jobLockService;
    private UserTransaction txn;
    private RepoUsage restrictionsBefore;

    protected void setUp() throws Exception {
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.repoUsageComponent = (RepoUsageComponent)ctx.getBean("repoUsageComponent");
        this.jobLockService = (JobLockService)ctx.getBean("jobLockService");
        AuthenticationUtil.setRunAsUserSystem();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.restrictionsBefore = this.repoUsageComponent.getRestrictions();
    }

    protected void tearDown() throws Exception {
        try {
            this.repoUsageComponent.setRestrictions(this.restrictionsBefore);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        if (this.txn != null) {
            try {
                this.txn.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void test1Setup() {
    }

    private RepoUsage getUsage() {
        RetryingTransactionHelper.RetryingTransactionCallback<RepoUsage> getCallback = new RetryingTransactionHelper.RetryingTransactionCallback<RepoUsage>(){

            @Override
            public RepoUsage execute() throws Throwable {
                return RepoUsageComponentTest.this.repoUsageComponent.getUsage();
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(getCallback, true);
    }

    private boolean updateUsage(final RepoUsage.UsageType usageType) {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> getCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return RepoUsageComponentTest.this.repoUsageComponent.updateUsage(usageType);
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(getCallback, false);
    }

    public void test2NoTxn() throws Throwable {
        this.txn.commit();
        try {
            this.repoUsageComponent.getUsage();
            RepoUsageComponentTest.fail((String)"Txn required for calls to RepoAdminComponent.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void test3GetUsage() {
        this.getUsage();
    }

    public void test4FullUse() throws Exception {
        RepoUsage restrictions = new RepoUsage(System.currentTimeMillis(), 7L, 600L, RepoUsage.LicenseMode.TEAM, System.currentTimeMillis() + 86400000L, false);
        this.repoUsageComponent.setRestrictions(restrictions);
        RepoUsage restrictionsCheck = this.repoUsageComponent.getRestrictions();
        RepoUsageComponentTest.assertEquals((String)"Restrictions should return without change.", (Object)restrictions, (Object)restrictionsCheck);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
        RepoUsageComponentTest.assertNotNull((String)"Usage is null", (Object)usage);
        RepoUsageComponentTest.assertNotNull((String)"Invalid user count", (Object)usage.getUsers());
        RepoUsageComponentTest.assertNotNull((String)"Invalid document count", (Object)usage.getDocuments());
        RepoUsageComponentTest.assertEquals((String)"License mode not set", (Object)((Object)restrictions.getLicenseMode()), (Object)((Object)usage.getLicenseMode()));
        RepoUsageComponentTest.assertEquals((String)"License expiry not set", (Object)restrictions.getLicenseExpiryDate(), (Object)usage.getLicenseExpiryDate());
        RepoUsageComponentTest.assertEquals((String)"Read-only state not set", (boolean)restrictions.isReadOnly(), (boolean)usage.isReadOnly());
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        logger.debug((Object)status);
    }

    public void test5LicenseUse() throws Exception {
        Long licenseUserLimit = 5L;
        Long licenseDocumentLimit = 100000L;
        RepoUsage.LicenseMode licenseMode = RepoUsage.LicenseMode.TEAM;
        Long licenseExpiry = System.currentTimeMillis() + 86400000L;
        RepoUsage restrictions = new RepoUsage(System.currentTimeMillis(), licenseUserLimit, licenseDocumentLimit, licenseMode, licenseExpiry, !this.transactionService.getAllowWrite());
        this.repoUsageComponent.setRestrictions(restrictions);
        this.updateUsage(RepoUsage.UsageType.USAGE_ALL);
        RepoUsage usage = this.getUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test6ConcurrentUpdates() throws Exception {
        RepoUsageComponentTest.assertTrue((String)"Failed to update all usages", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_ALL));
        RepoUsageComponentTest.assertTrue((String)"Failed to update user count", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_USERS));
        RepoUsageComponentTest.assertTrue((String)"Failed to update document count", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_DOCUMENTS));
        String lockToken = this.jobLockService.getLock(RepoUsageComponent.LOCK_USAGE, RepoUsageComponent.LOCK_TTL);
        try {
            RepoUsageComponentTest.assertFalse((String)"Expected usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_ALL));
            RepoUsageComponentTest.assertFalse((String)"Expected usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_USERS));
            RepoUsageComponentTest.assertFalse((String)"Expected usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_DOCUMENTS));
        }
        finally {
            this.jobLockService.releaseLock(lockToken, RepoUsageComponent.LOCK_USAGE);
        }
        lockToken = this.jobLockService.getLock(RepoUsageComponent.LOCK_USAGE_DOCUMENTS, RepoUsageComponent.LOCK_TTL);
        try {
            RepoUsageComponentTest.assertFalse((String)"Expected usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_ALL));
            RepoUsageComponentTest.assertTrue((String)"Failed to update user count", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_USERS));
            RepoUsageComponentTest.assertFalse((String)"Expected document usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_DOCUMENTS));
        }
        finally {
            this.jobLockService.releaseLock(lockToken, RepoUsageComponent.LOCK_USAGE_DOCUMENTS);
        }
        lockToken = this.jobLockService.getLock(RepoUsageComponent.LOCK_USAGE_USERS, RepoUsageComponent.LOCK_TTL);
        try {
            RepoUsageComponentTest.assertFalse((String)"Expected usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_ALL));
            RepoUsageComponentTest.assertFalse((String)"Expected user usage updates to be kicked out", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_USERS));
            RepoUsageComponentTest.assertTrue((String)"Failed to update document count", (boolean)this.updateUsage(RepoUsage.UsageType.USAGE_DOCUMENTS));
        }
        finally {
            this.jobLockService.releaseLock(lockToken, RepoUsageComponent.LOCK_USAGE_USERS);
        }
    }
}

