/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;

public abstract class BaseVersionStoreTest
extends BaseSpringTest {
    protected NodeService dbNodeService;
    protected VersionService versionService;
    protected ContentService contentService;
    protected DictionaryDAO dictionaryDAO;
    protected MutableAuthenticationService authenticationService;
    protected TransactionService transactionService;
    protected RetryingTransactionHelper txnHelper;
    protected MutableAuthenticationDao authenticationDAO;
    protected NodeArchiveService nodeArchiveService;
    protected NodeService nodeService;
    protected PermissionService permissionService;
    protected StoreRef testStoreRef;
    protected NodeRef rootNodeRef;
    protected Map<String, Serializable> versionProperties;
    protected HashMap<QName, Serializable> nodeProperties;
    protected HashMap<String, NodeRef> versionableNodes;
    protected static final String TEST_NAMESPACE = "http://www.alfresco.org/test/versionstorebasetest/1.0";
    protected static final QName TEST_TYPE_QNAME = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"testtype");
    protected static final QName TEST_ASPECT_QNAME = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"testaspect");
    protected static final QName PROP_1 = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"prop1");
    protected static final QName PROP_2 = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"prop2");
    protected static final QName PROP_3 = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"prop3");
    protected static final QName MULTI_PROP = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"multiProp");
    protected static final String VERSION_PROP_1 = "versionProp1";
    protected static final String VERSION_PROP_2 = "versionProp2";
    protected static final String VERSION_PROP_3 = "versionProp3";
    protected static final String VALUE_1 = "value1";
    protected static final String VALUE_2 = "value2";
    protected static final String VALUE_3 = "value3";
    protected static final QName TEST_CHILD_ASSOC_1 = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"childassoc1");
    protected static final QName TEST_CHILD_ASSOC_2 = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"childassoc2");
    protected static final QName TEST_ASSOC = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"assoc1");
    protected Collection<String> multiValue = null;
    protected static final String MULTI_VALUE_1 = "multi1";
    protected static final String MULTI_VALUE_2 = "multi2";
    protected MLText mlText;
    protected static final QName MLTEXT_PROP = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"propMl");
    protected static final String TEST_CONTENT = "This is the versioned test content.";
    private static final String PWD = "admin";

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected void onSetUpInTransaction() throws Exception {
        if (this.multiValue == null) {
            this.multiValue = new ArrayList<String>();
            this.multiValue.add(MULTI_VALUE_1);
            this.multiValue.add(MULTI_VALUE_2);
        }
        this.dbNodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.txnHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.authenticationDAO = (MutableAuthenticationDao)this.applicationContext.getBean("authenticationDao");
        this.nodeArchiveService = (NodeArchiveService)this.applicationContext.getBean("nodeArchiveService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.setVersionService((VersionService)this.applicationContext.getBean("versionService"));
        this.authenticationService.clearCurrentSecurityContext();
        this.createTestModel();
        this.versionProperties = new HashMap<String, Serializable>();
        this.versionProperties.put(VERSION_PROP_1, (Serializable)((Object)VALUE_1));
        this.versionProperties.put(VERSION_PROP_2, (Serializable)((Object)VALUE_2));
        this.versionProperties.put(VERSION_PROP_3, (Serializable)((Object)VALUE_3));
        this.nodeProperties = new HashMap();
        this.nodeProperties.put(PROP_1, (Serializable)((Object)VALUE_1));
        this.nodeProperties.put(PROP_2, (Serializable)((Object)VALUE_2));
        this.nodeProperties.put(PROP_3, (Serializable)((Object)VALUE_3));
        this.nodeProperties.put(MULTI_PROP, (Serializable)((Object)this.multiValue));
        this.nodeProperties.put(ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, "UTF-8"));
        this.mlText = new MLText(Locale.UK, "UK value");
        this.mlText.addValue(Locale.US, "Y'all US value");
        this.nodeProperties.put(MLTEXT_PROP, (Serializable)this.mlText);
        this.testStoreRef = this.dbNodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.dbNodeService.getRootNode(this.testStoreRef);
        if (!this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), PWD.toCharArray());
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    private void createTestModel() {
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("org/alfresco/repo/version/VersionStoreBaseTest_model.xml");
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.bootstrap();
    }

    protected NodeRef createNewVersionableNode() {
        return this.createNode(true, TEST_TYPE_QNAME);
    }

    protected NodeRef createNewNode() {
        return this.createNode(false, TEST_TYPE_QNAME);
    }

    protected NodeRef createNode(boolean versionable, QName nodeType) {
        this.versionableNodes = new HashMap();
        NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"), nodeType, this.nodeProperties).getChildRef();
        if (versionable) {
            this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        }
        BaseVersionStoreTest.assertNotNull((Object)nodeRef);
        this.versionableNodes.put(nodeRef.getId(), nodeRef);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(TEST_CONTENT);
        HashMap<QName, String> authorProps = new HashMap<QName, String>(1, 1.0f);
        authorProps.put(ContentModel.PROP_AUTHOR, "Charles Dickens");
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_AUTHOR, authorProps);
        NodeRef child1 = this.dbNodeService.createNode(nodeRef, TEST_CHILD_ASSOC_1, TEST_CHILD_ASSOC_1, nodeType, this.nodeProperties).getChildRef();
        if (versionable) {
            this.dbNodeService.addAspect(child1, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        }
        BaseVersionStoreTest.assertNotNull((Object)child1);
        this.versionableNodes.put(child1.getId(), child1);
        NodeRef child2 = this.dbNodeService.createNode(nodeRef, TEST_CHILD_ASSOC_2, TEST_CHILD_ASSOC_2, nodeType, this.nodeProperties).getChildRef();
        if (versionable) {
            this.dbNodeService.addAspect(child2, ContentModel.ASPECT_VERSIONABLE, new HashMap());
        }
        BaseVersionStoreTest.assertNotNull((Object)child2);
        this.versionableNodes.put(child2.getId(), child2);
        NodeRef assocNode = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyAssocNode"), nodeType, this.nodeProperties).getChildRef();
        BaseVersionStoreTest.assertNotNull((Object)assocNode);
        this.dbNodeService.createAssociation(nodeRef, assocNode, TEST_ASSOC);
        return nodeRef;
    }

    protected Version createVersion(NodeRef versionableNode) {
        return this.createVersion(versionableNode, this.versionProperties);
    }

    protected Version createVersion(NodeRef versionableNode, Map<String, Serializable> versionProperties) {
        String nextVersionLabel = this.peekNextVersionLabel(versionableNode, versionProperties);
        long beforeVersionTime = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Version newVersion = this.versionService.createVersion(versionableNode, this.versionProperties);
        this.checkNewVersion(beforeVersionTime, nextVersionLabel, newVersion, versionableNode);
        return newVersion;
    }

    protected Collection<Version> createVersion(NodeRef versionableNode, Map<String, Serializable> versionProperties, boolean versionChildren) {
        String nextVersionLabel = this.peekNextVersionLabel(versionableNode, versionProperties);
        long beforeVersionTime = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Collection<Version> versions = this.versionService.createVersion(versionableNode, this.versionProperties, versionChildren);
        this.checkVersionCollection(nextVersionLabel, beforeVersionTime, versions);
        return versions;
    }

    protected String peekNextVersionLabel(NodeRef nodeRef, Map<String, Serializable> versionProperties) {
        Version version = this.versionService.getCurrentVersion(nodeRef);
        SerialVersionLabelPolicy policy = new SerialVersionLabelPolicy();
        return policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, version, versionProperties);
    }

    protected void checkVersion(long beforeVersionTime, String expectedVersionLabel, Version newVersion, NodeRef versionableNode) {
        BaseVersionStoreTest.assertNotNull((Object)newVersion);
        BaseVersionStoreTest.assertEquals((String)"The expected version label was not used.", (String)expectedVersionLabel, (String)newVersion.getVersionLabel());
        long afterVersionTime = System.currentTimeMillis();
        long createdDate = newVersion.getFrozenModifiedDate().getTime();
        if (createdDate < beforeVersionTime || createdDate > afterVersionTime) {
            BaseVersionStoreTest.fail((String)"The created date of the version is incorrect.");
        }
        BaseVersionStoreTest.assertEquals((String)AuthenticationUtil.getAdminUserName(), (String)newVersion.getFrozenModifier());
        Map<String, Serializable> props = newVersion.getVersionProperties();
        BaseVersionStoreTest.assertNotNull((String)"The version properties collection should not be null.", props);
        if (this.versionProperties != null) {
            for (String key : this.versionProperties.keySet()) {
                BaseVersionStoreTest.assertEquals((Object)this.versionProperties.get(key), (Object)newVersion.getVersionProperty(key));
            }
        }
        NodeRef nodeRef = newVersion.getFrozenStateNodeRef();
        BaseVersionStoreTest.assertNotNull((Object)nodeRef);
        if (this.versionService.getVersionStoreReference().getIdentifier().equals("version2Store")) {
            BaseVersionStoreTest.assertEquals((String)"version2Store", (String)nodeRef.getStoreRef().getIdentifier());
            BaseVersionStoreTest.assertEquals((String)"versionStore", (String)nodeRef.getStoreRef().getProtocol());
            BaseVersionStoreTest.assertNotNull((Object)nodeRef.getId());
        } else if (this.versionService.getVersionStoreReference().getIdentifier().equals("lightWeightVersionStore")) {
            BaseVersionStoreTest.assertEquals((String)"lightWeightVersionStore", (String)nodeRef.getStoreRef().getIdentifier());
            BaseVersionStoreTest.assertEquals((String)"versionStore", (String)nodeRef.getStoreRef().getProtocol());
            BaseVersionStoreTest.assertNotNull((Object)nodeRef.getId());
        }
    }

    protected void checkNewVersion(long beforeVersionTime, String expectedVersionLabel, Version newVersion, NodeRef versionableNode) {
        this.checkVersion(beforeVersionTime, expectedVersionLabel, newVersion, versionableNode);
        String currentVersionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        BaseVersionStoreTest.assertEquals((String)newVersion.getVersionLabel(), (String)currentVersionLabel);
    }

    private void checkVersionCollection(String expectedVersionLabel, long beforeVersionTime, Collection<Version> versions) {
        for (Version version : versions) {
            String frozenNodeId = null;
            if (this.versionService.getVersionStoreReference().getIdentifier().equals("version2Store")) {
                frozenNodeId = ((NodeRef)version.getVersionProperty("frozenNodeRef")).getId();
            } else if (this.versionService.getVersionStoreReference().getIdentifier().equals("lightWeightVersionStore")) {
                frozenNodeId = (String)((Object)version.getVersionProperty("frozenNodeId"));
            }
            BaseVersionStoreTest.assertNotNull((String)"Unable to retrieve the frozen node id from the created version.", (Object)frozenNodeId);
            NodeRef origionaNodeRef = this.versionableNodes.get(frozenNodeId);
            BaseVersionStoreTest.assertNotNull((String)"The versionable node ref that relates to the frozen node id can not be found.", (Object)origionaNodeRef);
            this.checkNewVersion(beforeVersionTime, expectedVersionLabel, version, origionaNodeRef);
        }
    }
}

