/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.VersionMigrator;
import org.alfresco.repo.version.VersionServiceImpl;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class Version2ServiceImpl
extends VersionServiceImpl
implements VersionService,
Version2Model {
    private static Log logger = LogFactory.getLog(Version2ServiceImpl.class);
    protected boolean useDeprecatedV1 = false;
    private PermissionService permissionService;
    private VersionServiceImpl version1Service = new VersionServiceImpl();
    private VersionMigrator versionMigrator;
    private static Comparator<Version> versionComparatorAsc = new VersionHistoryImpl.VersionComparatorAsc();

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setVersionMigrator(VersionMigrator versionMigrator) {
        this.versionMigrator = versionMigrator;
    }

    public void setOnlyUseDeprecatedV1(boolean useDeprecatedV1) {
        this.useDeprecatedV1 = useDeprecatedV1;
    }

    @Override
    public void initialise() {
        super.initialise();
        if (this.useDeprecatedV1) {
            logger.warn((Object)"version.store.onlyUseDeprecatedV1=true - using deprecated 'lightWeightVersionStore' by default (not 'version2Store')");
        } else {
            this.version1Service.setNodeService(this.dbNodeService);
            this.version1Service.setDbNodeService(this.dbNodeService);
        }
    }

    @Override
    public StoreRef getVersionStoreReference() {
        if (this.useDeprecatedV1) {
            return super.getVersionStoreReference();
        }
        return new StoreRef("workspace", "version2Store");
    }

    @Override
    public Version createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        if (this.useDeprecatedV1) {
            return super.createVersion(nodeRef, versionProperties);
        }
        long startTime = System.currentTimeMillis();
        int versionNumber = 0;
        Version version = this.createVersion(nodeRef, versionProperties, versionNumber);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created version (" + VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()) + ") in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return version;
    }

    @Override
    public Collection<Version> createVersion(Collection<NodeRef> nodeRefs, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        if (this.useDeprecatedV1) {
            return super.createVersion(nodeRefs, versionProperties);
        }
        long startTime = System.currentTimeMillis();
        ArrayList<Version> result = new ArrayList<Version>(nodeRefs.size());
        int versionNumber = 0;
        for (NodeRef nodeRef : nodeRefs) {
            result.add(this.createVersion(nodeRef, versionProperties, versionNumber));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created version list (" + this.getVersionStoreReference() + ") in " + (System.currentTimeMillis() - startTime) + " ms (with " + nodeRefs.size() + " nodes)"));
        }
        return result;
    }

    @Override
    protected Version createVersion(NodeRef nodeRef, Map<String, Serializable> origVersionProperties, int versionNumber) throws ReservedVersionNameException {
        NodeRef oldVHRef;
        if (this.useDeprecatedV1) {
            return super.createVersion(nodeRef, origVersionProperties, versionNumber);
        }
        long startTime = System.currentTimeMillis();
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        if (origVersionProperties != null) {
            versionProperties.putAll(origVersionProperties);
        }
        this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        }
        this.invokeBeforeCreateVersion(nodeRef);
        String versionDescription = (String)versionProperties.get("description");
        versionProperties.remove("description");
        versionProperties.remove(ContentModel.PROP_VERSION_LABEL);
        VersionUtil.checkVersionPropertyNames(versionProperties.keySet());
        NodeRef versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
        Object currentVersionRef = null;
        if (versionHistoryRef == null && !this.versionMigrator.isMigrationComplete() && (oldVHRef = this.version1Service.getVersionHistoryNodeRef(nodeRef)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lazily migrate old version history (background migration in progress): " + oldVHRef));
            }
            try {
                this.versionMigrator.migrateVersion(oldVHRef, true);
            }
            catch (Throwable t) {
                throw new AlfrescoRuntimeException("Failed to lazily migrate old version history: " + oldVHRef, t);
            }
            versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
            if (versionHistoryRef == null) {
                throw new AlfrescoRuntimeException("Failed to find lazily migrated version history for node: " + nodeRef);
            }
        }
        Version currentVersion = null;
        if (versionHistoryRef == null) {
            versionHistoryRef = this.createVersionHistory(nodeRef);
        } else {
            this.checkForCorruptedVersions(versionHistoryRef, nodeRef);
            Pair<Boolean, Version> result = this.getCurrentVersionImpl(versionHistoryRef, nodeRef);
            boolean headVersion = false;
            if (result != null) {
                currentVersion = (Version)result.getSecond();
                headVersion = (Boolean)result.getFirst();
            }
            if (currentVersion == null) {
                throw new VersionServiceException("version_service.err_not_found");
            }
            if (!headVersion) {
                VersionHistory versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
                if (versionHistory.getSuccessors(currentVersion).size() == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Belt-and-braces: current version does seem to be head version [" + versionHistoryRef + ", " + nodeRef + "]"));
                    }
                } else {
                    throw new VersionServiceException("version_service.err_unsupported");
                }
            }
        }
        QName classRef = this.nodeService.getType(nodeRef);
        PolicyScope nodeDetails = new PolicyScope(classRef);
        this.invokeOnCreateVersion(nodeRef, versionProperties, nodeDetails);
        String versionLabel = this.invokeCalculateVersionLabel(classRef, currentVersion, versionNumber, versionProperties);
        QName sourceTypeRef = this.nodeService.getType(nodeRef);
        long nodeDbId = (Long)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID);
        Set nodeAspects = this.nodeService.getAspects(nodeRef);
        NodeRef newVersionRef = this.createNewVersion(sourceTypeRef, versionHistoryRef, this.getStandardVersionProperties(nodeRef, nodeDbId, nodeAspects, versionNumber, versionLabel, versionDescription), versionProperties, versionNumber, nodeDetails);
        if (currentVersionRef == null) {
            this.dbNodeService.createAssociation(versionHistoryRef, newVersionRef, Version2Model.ASSOC_ROOT_VERSION);
        }
        Version version = this.getVersion(newVersionRef);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)version.getVersionLabel()));
        this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        this.invokeAfterCreateVersion(nodeRef, version);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created version (" + this.getVersionStoreReference() + ") " + newVersionRef + " " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return version;
    }

    protected NodeRef createVersionHistory(NodeRef nodeRef) {
        long start = System.currentTimeMillis();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeRef.getId());
        props.put(Version2Model.PROP_QNAME_VERSIONED_NODE_ID, nodeRef.getId());
        ChildAssociationRef childAssocRef = this.dbNodeService.createNode(this.getRootNode(), Version2Model.CHILD_QNAME_VERSION_HISTORIES, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)nodeRef.getId()), Version2Model.TYPE_QNAME_VERSION_HISTORY, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created version history nodeRef: " + childAssocRef.getChildRef() + " for " + nodeRef + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return childAssocRef.getChildRef();
    }

    @Override
    public VersionHistory getVersionHistory(NodeRef nodeRef) {
        NodeRef oldVHRef;
        if (this.useDeprecatedV1) {
            return super.getVersionHistory(nodeRef);
        }
        VersionHistory versionHistory = null;
        NodeRef versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
        if (versionHistoryRef != null) {
            versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
        } else if (!this.versionMigrator.isMigrationComplete() && (oldVHRef = this.version1Service.getVersionHistoryNodeRef(nodeRef)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Get old version history (background migration in progress): " + oldVHRef));
            }
            versionHistory = this.version1Service.getVersionHistory(nodeRef);
        }
        return versionHistory;
    }

    @Override
    public Version getCurrentVersion(NodeRef nodeRef) {
        Pair<Boolean, Version> result;
        NodeRef versionHistoryRef;
        if (this.useDeprecatedV1) {
            return super.getCurrentVersion(nodeRef);
        }
        Version version = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && (versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef)) != null && (result = this.getCurrentVersionImpl(versionHistoryRef, nodeRef)) != null) {
            version = (Version)result.getSecond();
        }
        return version;
    }

    protected Map<QName, Serializable> getStandardVersionProperties(NodeRef nodeRef, long nodeDbId, Set<QName> nodeAspects, int versionNumber, String versionLabel, String versionDescription) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>(10);
        result.put(Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)versionLabel));
        result.put(Version2Model.PROP_QNAME_VERSION_DESCRIPTION, (Serializable)((Object)versionDescription));
        result.put(Version2Model.PROP_QNAME_FROZEN_NODE_REF, (Serializable)nodeRef);
        result.put(Version2Model.PROP_QNAME_FROZEN_NODE_DBID, Long.valueOf(nodeDbId));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeRef createNewVersion(QName sourceTypeRef, NodeRef versionHistoryRef, Map<QName, Serializable> standardVersionProperties, Map<String, Serializable> versionProperties, int versionNumber, PolicyScope nodeDetails) {
        ChildAssociationRef childAssocRef = null;
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        NodeRef versionNodeRef = null;
        try {
            childAssocRef = this.dbNodeService.createNode(versionHistoryRef, Version2Model.CHILD_QNAME_VERSIONS, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)("version-" + versionNumber)), sourceTypeRef, nodeDetails.getProperties());
            versionNodeRef = childAssocRef.getChildRef();
            if (sourceTypeRef.equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                this.permissionService.setPermission(versionNodeRef, "GROUP_EVERYONE", "All", true);
                this.permissionService.setPermission(versionNodeRef, AuthenticationUtil.getGuestUserName(), "All", true);
            }
            this.nodeService.addAspect(versionNodeRef, Version2Model.ASPECT_VERSION, standardVersionProperties);
            this.storeVersionMetaData(versionNodeRef, versionProperties);
            this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations());
            this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations());
            this.freezeAspects(nodeDetails, versionNodeRef, nodeDetails.getAspects());
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        }
        if (!this.dbNodeService.hasAspect(versionNodeRef, ContentModel.ASPECT_AUDITABLE)) {
            this.dbNodeService.addAspect(versionNodeRef, ContentModel.ASPECT_AUDITABLE, null);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("newVersion created (" + versionNumber + ") " + versionNodeRef));
        }
        return versionNodeRef;
    }

    private void storeVersionMetaData(NodeRef versionNodeRef, Map<String, Serializable> versionProperties) {
        for (Map.Entry<String, Serializable> entry : versionProperties.entrySet()) {
            this.dbNodeService.setProperty(versionNodeRef, QName.createQName((String)"http://www.alfresco.org/model/versionstore/2.0", (String)("metadata-" + entry.getKey())), entry.getValue());
        }
    }

    private void freezeAspects(PolicyScope nodeDetails, NodeRef versionNodeRef, Set<QName> aspects) {
        for (QName aspect : aspects) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("freezeAspect: " + versionNodeRef + " " + aspect));
            }
            if (aspect.equals((Object)ContentModel.ASPECT_AUDITABLE)) {
                for (Map.Entry<QName, Serializable> entry : nodeDetails.getProperties(aspect).entrySet()) {
                    if (entry.getKey().equals((Object)ContentModel.PROP_CREATOR)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_CREATOR, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_CREATED)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_CREATED, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_MODIFIER)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIER, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_MODIFIED)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_MODIFIED, entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals((Object)ContentModel.PROP_ACCESSED)) {
                        this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_FROZEN_ACCESSED, entry.getValue());
                        continue;
                    }
                    throw new AlfrescoRuntimeException("Unexpected auditable property: " + entry.getKey());
                }
            } else {
                this.dbNodeService.addAspect(versionNodeRef, aspect, nodeDetails.getProperties(aspect));
            }
            this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations(aspect));
            this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations(aspect));
        }
    }

    private void freezeChildAssociations(NodeRef versionNodeRef, List<ChildAssociationRef> childAssociations) {
        for (ChildAssociationRef childAssocRef : childAssociations) {
            HashMap<QName, NodeRef> properties = new HashMap<QName, NodeRef>();
            NodeRef childRef = childAssocRef.getChildRef();
            QName sourceTypeRef = this.nodeService.getType(childRef);
            properties.put(ContentModel.PROP_REFERENCE, childRef);
            this.dbNodeService.createNode(versionNodeRef, childAssocRef.getTypeQName(), childAssocRef.getQName(), sourceTypeRef, properties);
        }
    }

    private void freezeAssociations(NodeRef versionNodeRef, List<AssociationRef> associations) {
        for (AssociationRef targetAssocRef : associations) {
            HashMap<QName, Object> properties = new HashMap<QName, Object>();
            QName sourceTypeRef = this.nodeService.getType(targetAssocRef.getSourceRef());
            NodeRef targetRef = targetAssocRef.getTargetRef();
            properties.put(ContentModel.PROP_REFERENCE, targetRef);
            properties.put(Version2Model.PROP_QNAME_ASSOC_DBID, targetAssocRef.getId());
            this.dbNodeService.createNode(versionNodeRef, Version2Model.CHILD_QNAME_VERSIONED_ASSOCS, targetAssocRef.getTypeQName(), sourceTypeRef, properties);
        }
    }

    protected List<Version> getAllVersions(NodeRef versionHistoryRef) {
        List<ChildAssociationRef> versionAssocs = this.getVersionAssocs(versionHistoryRef, true);
        ArrayList<Version> versions = new ArrayList<Version>(versionAssocs.size());
        for (ChildAssociationRef versionAssoc : versionAssocs) {
            versions.add(this.getVersion(versionAssoc.getChildRef()));
        }
        return versions;
    }

    private List<ChildAssociationRef> getVersionAssocs(NodeRef versionHistoryRef, boolean preLoad) {
        return this.dbNodeService.getChildAssocs(versionHistoryRef, (QNamePattern)Version2Model.CHILD_QNAME_VERSIONS, RegexQNamePattern.MATCH_ALL, preLoad);
    }

    @Override
    protected VersionHistory buildVersionHistory(NodeRef versionHistoryRef, NodeRef nodeRef) {
        if (this.useDeprecatedV1) {
            return super.buildVersionHistory(versionHistoryRef, nodeRef);
        }
        VersionHistoryImpl versionHistory = null;
        List<Version> versions = this.getAllVersions(versionHistoryRef);
        Collections.sort(versions, versionComparatorAsc);
        boolean isRoot = true;
        Version preceeding = null;
        for (Version version : versions) {
            if (isRoot) {
                versionHistory = new VersionHistoryImpl(version);
                isRoot = false;
            } else {
                ((VersionHistoryImpl)versionHistory).addVersion(version, preceeding);
            }
            preceeding = version;
        }
        return versionHistory;
    }

    @Override
    protected Version getVersion(NodeRef versionRef) {
        if (this.useDeprecatedV1) {
            return super.getVersion(versionRef);
        }
        if (versionRef == null) {
            return null;
        }
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        Map nodeProperties = this.dbNodeService.getProperties(versionRef);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getVersion: " + versionRef + " nodeProperties=\n" + nodeProperties.keySet()));
        }
        for (QName key : nodeProperties.keySet()) {
            Serializable value = (Serializable)nodeProperties.get(key);
            String keyName = key.getLocalName();
            int idx = keyName.indexOf("metadata-");
            if (idx == 0) {
                versionProperties.put(keyName.substring("metadata-".length()), value);
                continue;
            }
            if (key.equals((Object)Version2Model.PROP_QNAME_VERSION_DESCRIPTION)) {
                versionProperties.put("description", (Serializable)((Object)((String)((Object)value))));
                continue;
            }
            if (key.equals((Object)Version2Model.PROP_QNAME_VERSION_LABEL)) {
                versionProperties.put("versionLabel", (Serializable)((Object)((String)((Object)value))));
                continue;
            }
            if (key.equals((Object)Version2Model.PROP_QNAME_VERSION_NUMBER) || keyName.equals("description") || keyName.equals("versionLabel") || keyName.equals("versionNumber")) continue;
            versionProperties.put(keyName, value);
        }
        NodeRef newNodeRef = new NodeRef(new StoreRef("versionStore", "version2Store"), versionRef.getId());
        VersionImpl result = new VersionImpl(versionProperties, newNodeRef);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getVersion: " + versionRef + " versionProperties=\n" + versionProperties.keySet()));
        }
        return result;
    }

    @Override
    protected NodeRef getVersionHistoryNodeRef(NodeRef nodeRef) {
        if (this.useDeprecatedV1) {
            return super.getVersionHistoryNodeRef(nodeRef);
        }
        NodeRef vhNodeRef = this.dbNodeService.getChildByName(this.getRootNode(), Version2Model.CHILD_QNAME_VERSION_HISTORIES, nodeRef.getId());
        if (vhNodeRef == null && this.nodeService.exists(nodeRef)) {
            vhNodeRef = this.dbNodeService.getChildByName(this.getRootNode(), Version2Model.CHILD_QNAME_VERSION_HISTORIES, (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_UUID)));
        }
        return vhNodeRef;
    }

    private Pair<Boolean, Version> getCurrentVersionImpl(NodeRef versionHistoryRef, NodeRef nodeRef) {
        int cnt;
        Pair result = null;
        String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        List<ChildAssociationRef> versionAssocs = this.getVersionAssocs(versionHistoryRef, false);
        for (int i = cnt = versionAssocs.size(); i > 0; --i) {
            boolean headVersion;
            ChildAssociationRef versionAssoc = versionAssocs.get(i - 1);
            String tempLabel = (String)((Object)this.dbNodeService.getProperty(versionAssoc.getChildRef(), Version2Model.PROP_QNAME_VERSION_LABEL));
            if (tempLabel == null || !tempLabel.equals(versionLabel)) continue;
            boolean bl = headVersion = i == cnt;
            if (!headVersion && logger.isDebugEnabled()) {
                logger.debug((Object)("Unexpected: current version does not appear to be 1st version in the list  [" + versionHistoryRef + ", " + nodeRef + "]"));
            }
            result = new Pair((Object)headVersion, (Object)this.getVersion(versionAssoc.getChildRef()));
            break;
        }
        return result;
    }

    private void checkForCorruptedVersions(NodeRef versionHistory, NodeRef nodeRef) {
        String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        if (versionLabel != null && versionLabel.equals("0")) {
            List<Version> versions = this.getAllVersions(versionHistory);
            Collections.sort(versions, new Comparator<Version>(){

                @Override
                public int compare(Version v1, Version v2) {
                    int result = v1.getFrozenModifiedDate().compareTo(v2.getFrozenModifiedDate());
                    if (result == 0) {
                        Long dbid1 = (Long)Version2ServiceImpl.this.nodeService.getProperty(v1.getFrozenStateNodeRef(), ContentModel.PROP_NODE_DBID);
                        Long dbid2 = (Long)Version2ServiceImpl.this.nodeService.getProperty(v2.getFrozenStateNodeRef(), ContentModel.PROP_NODE_DBID);
                        if (dbid1 != null && dbid2 != null) {
                            result = dbid1.compareTo(dbid2);
                        } else {
                            result = 0;
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("node-dbid property is missing for versions: " + v1.toString() + " or " + v2.toString()));
                            }
                        }
                    }
                    return result;
                }
            });
            SerialVersionLabelPolicy serialVersionLabelPolicy = new SerialVersionLabelPolicy();
            QName classRef = this.nodeService.getType(nodeRef);
            Version preceedingVersion = null;
            for (Version version : versions) {
                versionLabel = serialVersionLabelPolicy.calculateVersionLabel(classRef, preceedingVersion, 0, version.getVersionProperties());
                NodeRef versionNodeRef = new NodeRef("workspace", version.getFrozenStateNodeRef().getStoreRef().getIdentifier(), version.getFrozenStateNodeRef().getId());
                this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)versionLabel));
                version.getVersionProperties().put("versionLabel", (Serializable)((Object)versionLabel));
                preceedingVersion = version;
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)versionLabel));
        }
    }

    @Override
    public void revert(NodeRef nodeRef) {
        if (this.useDeprecatedV1) {
            super.revert(nodeRef, this.getCurrentVersion(nodeRef), true);
        } else {
            this.revert(nodeRef, this.getCurrentVersion(nodeRef), true);
        }
    }

    @Override
    public void revert(NodeRef nodeRef, boolean deep) {
        if (this.useDeprecatedV1) {
            super.revert(nodeRef, this.getCurrentVersion(nodeRef), deep);
        } else {
            this.revert(nodeRef, this.getCurrentVersion(nodeRef), deep);
        }
    }

    @Override
    public void revert(NodeRef nodeRef, Version version) {
        if (this.useDeprecatedV1) {
            super.revert(nodeRef, version, true);
        } else {
            this.revert(nodeRef, version, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(NodeRef nodeRef, Version version, boolean deep) {
        if (this.useDeprecatedV1) {
            super.revert(nodeRef, version, deep);
        } else {
            ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
            ParameterCheck.mandatory((String)"version", (Object)version);
            if (!nodeRef.getId().equals(((NodeRef)version.getVersionProperty("frozenNodeRef")).getId())) {
                throw new VersionServiceException("version_service.err_revert_mismatch");
            }
            this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
            try {
                String currentVersionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
                NodeRef versionNodeRef = version.getFrozenStateNodeRef();
                Map props = this.nodeService.getProperties(versionNodeRef);
                VersionUtil.convertFrozenToOriginalProps(props);
                this.nodeService.setProperties(nodeRef, props);
                HashSet aspects = new HashSet(this.nodeService.getAspects(nodeRef));
                for (QName versionAspect : this.nodeService.getAspects(versionNodeRef)) {
                    if (!aspects.contains(versionAspect)) {
                        this.nodeService.addAspect(nodeRef, versionAspect, null);
                        continue;
                    }
                    aspects.remove(versionAspect);
                }
                for (QName aspect : aspects) {
                    this.nodeService.removeAspect(nodeRef, aspect);
                }
                if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                    this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                }
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)currentVersionLabel));
                ArrayList children = new ArrayList(this.nodeService.getChildAssocs(nodeRef));
                for (ChildAssociationRef versionedChild : this.nodeService.getChildAssocs(versionNodeRef)) {
                    if (!children.contains(versionedChild)) {
                        if (this.nodeService.exists(versionedChild.getChildRef())) {
                            this.nodeService.addChild(nodeRef, versionedChild.getChildRef(), versionedChild.getTypeQName(), versionedChild.getQName());
                            continue;
                        }
                        if (!versionedChild.isPrimary() || !deep || this.getVersionHistoryNodeRef(versionedChild.getChildRef()) == null) continue;
                        this.restore(versionedChild.getChildRef(), nodeRef, versionedChild.getTypeQName(), versionedChild.getQName());
                        continue;
                    }
                    children.remove(versionedChild);
                }
                for (ChildAssociationRef ref : children) {
                    this.nodeService.removeChild(nodeRef, ref.getChildRef());
                }
                for (AssociationRef assocRef : this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL)) {
                    this.nodeService.removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
                }
                for (AssociationRef versionedAssoc : this.nodeService.getTargetAssocs(versionNodeRef, RegexQNamePattern.MATCH_ALL)) {
                    if (!this.nodeService.exists(versionedAssoc.getTargetRef())) continue;
                    this.nodeService.createAssociation(nodeRef, versionedAssoc.getTargetRef(), versionedAssoc.getTypeQName());
                }
            }
            finally {
                this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
            }
        }
    }

    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName) {
        if (this.useDeprecatedV1) {
            return super.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, true);
        }
        return this.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, boolean deep) {
        if (this.useDeprecatedV1) {
            return super.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, deep);
        }
        NodeRef restoredNodeRef = null;
        if (this.nodeService.exists(nodeRef)) {
            throw new VersionServiceException("version_service.err_restore_exists", new Object[]{nodeRef.toString()});
        }
        Version version = this.getHeadVersion(nodeRef);
        if (version == null) {
            throw new VersionServiceException("version_service.err_restore_no_version", new Object[]{nodeRef.toString()});
        }
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NODE_UUID, ((NodeRef)version.getVersionProperty("frozenNodeRef")).getId());
        QName type = this.dbNodeService.getType(VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()));
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            restoredNodeRef = this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, type, props).getChildRef();
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
        this.revert(restoredNodeRef, version, deep);
        return restoredNodeRef;
    }

    private Version getHeadVersion(NodeRef nodeRef) {
        VersionHistory versionHistory;
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        Version headVersion = null;
        if (versionHistoryNodeRef != null && (versionHistory = this.buildVersionHistory(versionHistoryNodeRef, nodeRef)) != null) {
            headVersion = versionHistory.getHeadVersion();
        }
        return headVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVersionHistory(NodeRef nodeRef) throws AspectMissingException {
        if (this.useDeprecatedV1) {
            super.deleteVersionHistory(nodeRef);
        } else {
            NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
            if (versionHistoryNodeRef != null) {
                try {
                    this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                    this.dbNodeService.deleteNode(versionHistoryNodeRef);
                    if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                        this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, null);
                    }
                }
                finally {
                    this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
                }
            }
        }
    }

    @Override
    public void deleteVersion(NodeRef nodeRef, Version version) {
        if (this.useDeprecatedV1) {
            super.deleteVersion(nodeRef, version);
        } else {
            ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
            ParameterCheck.mandatory((String)"version", (Object)version);
            Version currentVersion = this.getCurrentVersion(nodeRef);
            this.dbNodeService.deleteNode(VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()));
            if (currentVersion.getVersionLabel().equals(version.getVersionLabel())) {
                Version headVersion = this.getHeadVersion(nodeRef);
                if (headVersion != null) {
                    this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                    this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)headVersion.getVersionLabel()));
                } else {
                    this.deleteVersionHistory(nodeRef);
                }
            }
        }
    }
}

