/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;

public abstract class AbstractVersionServiceImpl {
    protected NodeService nodeService;
    protected PolicyComponent policyComponent;
    protected DictionaryService dictionaryService;
    private ClassPolicyDelegate<VersionServicePolicies.BeforeCreateVersionPolicy> beforeCreateVersionDelegate;
    private ClassPolicyDelegate<VersionServicePolicies.AfterCreateVersionPolicy> afterCreateVersionDelegate;
    private ClassPolicyDelegate<VersionServicePolicies.OnCreateVersionPolicy> onCreateVersionDelegate;
    private ClassPolicyDelegate<VersionServicePolicies.CalculateVersionLabelPolicy> calculateVersionLabelDelegate;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void initialise() {
        this.beforeCreateVersionDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.BeforeCreateVersionPolicy.class);
        this.afterCreateVersionDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.AfterCreateVersionPolicy.class);
        this.onCreateVersionDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.OnCreateVersionPolicy.class);
        this.calculateVersionLabelDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.CalculateVersionLabelPolicy.class);
    }

    protected void invokeBeforeCreateVersion(NodeRef nodeRef) {
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        this.beforeCreateVersionDelegate.get(nodeTypeQName).beforeCreateVersion(nodeRef);
        Set nodeAspectQNames = this.nodeService.getAspects(nodeRef);
        this.beforeCreateVersionDelegate.get(nodeAspectQNames).beforeCreateVersion(nodeRef);
    }

    protected void invokeAfterCreateVersion(NodeRef nodeRef, Version version) {
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        this.afterCreateVersionDelegate.get(nodeTypeQName).afterCreateVersion(nodeRef, version);
        Set nodeAspectQNames = this.nodeService.getAspects(nodeRef);
        this.afterCreateVersionDelegate.get(nodeAspectQNames).afterCreateVersion(nodeRef, version);
    }

    protected void invokeOnCreateVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        QName classRef = this.nodeService.getType(nodeRef);
        this.invokeOnCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
        Set aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            this.invokeOnCreateVersion(aspect, nodeRef, versionProperties, nodeDetails);
        }
    }

    private void invokeOnCreateVersion(QName classRef, NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        this.defaultOnCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
        Collection<VersionServicePolicies.OnCreateVersionPolicy> policies = this.onCreateVersionDelegate.getList(classRef);
        for (VersionServicePolicies.OnCreateVersionPolicy policy : policies) {
            policy.onCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
        }
    }

    protected abstract void defaultOnCreateVersion(QName var1, NodeRef var2, Map<String, Serializable> var3, PolicyScope var4);

    protected String invokeCalculateVersionLabel(QName classRef, Version preceedingVersion, int versionNumber, Map<String, Serializable> versionProperties) {
        String versionLabel = null;
        Collection<VersionServicePolicies.CalculateVersionLabelPolicy> behaviours = this.calculateVersionLabelDelegate.getList(classRef);
        if (behaviours.size() == 0) {
            SerialVersionLabelPolicy defaultVersionLabelPolicy = new SerialVersionLabelPolicy();
            versionLabel = defaultVersionLabelPolicy.calculateVersionLabel(classRef, preceedingVersion, versionNumber, versionProperties);
        } else if (behaviours.size() == 1) {
            VersionServicePolicies.CalculateVersionLabelPolicy[] arr = behaviours.toArray(new VersionServicePolicies.CalculateVersionLabelPolicy[0]);
            versionLabel = arr[0].calculateVersionLabel(classRef, preceedingVersion, versionNumber, versionProperties);
        } else {
            throw new VersionServiceException("More than one CalculateVersionLabelPolicy behaviour has been registered for the type " + classRef.toString());
        }
        return versionLabel;
    }

    public abstract StoreRef getVersionStoreReference();
}

