/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameCache;

public class WorkflowQNameConverter {
    private static final int MAX_QNAME_CACHE_SIZE = 5000;
    private final QNameCache cache = new QNameCache(5000);
    private final NamespacePrefixResolver prefixResolver;

    public WorkflowQNameConverter(NamespacePrefixResolver prefixResolver) {
        this.prefixResolver = prefixResolver;
    }

    public String mapQNameToName(QName qName) {
        String name = this.cache.getName(qName);
        if (name == null) {
            name = this.convertQNameToName(qName);
            this.cache.putQNameToName(qName, name);
            this.cache.putNameToQName(name, qName);
        }
        return name;
    }

    public QName mapNameToQName(String name) {
        QName qName = this.cache.getQName(name);
        if (qName == null) {
            qName = this.convertNameToQName(name);
            this.cache.putNameToQName(name, qName);
            this.cache.putQNameToName(qName, name);
        }
        return qName;
    }

    public void clearCache() {
        this.cache.clear();
    }

    private QName convertNameToQName(String name) {
        return WorkflowQNameConverter.convertNameToQName(name, this.prefixResolver);
    }

    public static QName convertNameToQName(String name, NamespacePrefixResolver prefixResolver) {
        if (name.indexOf(123) == 0) {
            return QName.createQName((String)name);
        }
        String qName = name;
        if (name.indexOf(58) == -1) {
            if (name.indexOf(95) == -1) {
                return QName.createQName((String)"", (String)name);
            }
            qName = name.replaceFirst("_", ":");
        }
        return QName.createQName((String)qName, (NamespacePrefixResolver)prefixResolver);
    }

    private String convertQNameToName(QName name) {
        return WorkflowQNameConverter.convertQNameToName(name, this.prefixResolver);
    }

    public static String convertQNameToName(QName name, NamespacePrefixResolver prefixResolver) {
        String nameStr = name.toPrefixString(prefixResolver);
        if (nameStr.indexOf(95) != -1 && nameStr.indexOf(95) < nameStr.indexOf(58)) {
            return name.toString();
        }
        return nameStr.replace(':', '_');
    }
}

