/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricDetailQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.workflow.WorkflowAuthorityManager;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowNodeConverter;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.WorkflowPropertyHandlerRegistry;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.ActivitiTaskTypeManager;
import org.alfresco.repo.workflow.activiti.ActivitiUtil;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassAttributeDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.EntryTransformer;
import org.alfresco.util.collections.Function;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivitiPropertyConverter {
    private static Log logger = LogFactory.getLog(ActivitiPropertyConverter.class);
    private static final String ERR_CONVERT_VALUE = "activiti.engine.convert.value.error";
    private static final String ERR_SET_TASK_PROPS_INVALID_VALUE = "activiti.engine.set.task.properties.invalid.value";
    private static final String ERR_MANDATORY_TASK_PROPERTIES_MISSING = "activiti.engine.mandatory.properties.missing";
    private final ActivitiTaskTypeManager typeManager;
    private final MessageService messageService;
    private final WorkflowObjectFactory factory;
    private final WorkflowAuthorityManager authorityManager;
    private final WorkflowPropertyHandlerRegistry handlerRegistry;
    private final WorkflowNodeConverter nodeConverter;
    private final ActivitiUtil activitiUtil;

    public ActivitiPropertyConverter(ActivitiUtil activitiUtil, WorkflowObjectFactory factory, WorkflowPropertyHandlerRegistry handlerRegistry, WorkflowAuthorityManager authorityManager, MessageService messageService, WorkflowNodeConverter nodeConverter) {
        this.activitiUtil = activitiUtil;
        this.factory = factory;
        this.handlerRegistry = handlerRegistry;
        this.authorityManager = authorityManager;
        this.messageService = messageService;
        this.nodeConverter = nodeConverter;
        this.typeManager = new ActivitiTaskTypeManager(factory, activitiUtil.getFormService());
    }

    public Map<QName, Serializable> getTaskProperties(Task task) {
        TypeDefinition taskDef = this.typeManager.getFullTaskDefinition(task);
        Map taskProperties = taskDef.getProperties();
        Map taskAssociations = taskDef.getAssociations();
        TaskService taskService = this.activitiUtil.getTaskService();
        Map variables = taskService.getVariables(task.getId());
        Map localVariables = taskService.getVariablesLocal(task.getId());
        Map<QName, Serializable> properties = this.mapArbitraryProperties(variables, localVariables, taskProperties, taskAssociations);
        properties.put(WorkflowModel.PROP_TASK_ID, (Serializable)((Object)task.getId()));
        properties.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)task.getDescription()));
        properties.put(WorkflowModel.PROP_START_DATE, task.getCreateTime());
        properties.put(WorkflowModel.PROP_DUE_DATE, task.getDueDate());
        properties.put(WorkflowModel.PROP_COMPLETION_DATE, null);
        properties.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(task.getPriority()));
        properties.put(ContentModel.PROP_CREATED, task.getCreateTime());
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)task.getAssignee()));
        String outcomeVarName = this.factory.mapQNameToName(WorkflowModel.PROP_OUTCOME);
        if (variables.get(outcomeVarName) != null) {
            properties.put(WorkflowModel.PROP_OUTCOME, (Serializable)variables.get(outcomeVarName));
        }
        List links = taskService.getIdentityLinksForTask(task.getId());
        this.mapPooledActors(links, properties);
        return this.filterTaskProperties(properties);
    }

    public Map<QName, Serializable> getPathProperties(String executionId) {
        Map<String, Object> variables = this.activitiUtil.getExecutionVariables(executionId);
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(variables.size());
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            QName qNameKey = this.factory.mapNameToQName(entry.getKey());
            Serializable value = this.convertPropertyValue(entry.getValue());
            properties.put(qNameKey, value);
        }
        return properties;
    }

    public List<NodeRef> getPooledActorsReference(Collection<IdentityLink> links) {
        ArrayList<NodeRef> pooledActorRefs = new ArrayList<NodeRef>();
        if (links != null) {
            for (IdentityLink link : links) {
                NodeRef pooledNodeRef;
                if (!"candidate".equals(link.getType())) continue;
                String id = link.getGroupId();
                if (id == null) {
                    id = link.getUserId();
                }
                if ((pooledNodeRef = this.authorityManager.mapNameToAuthority(id)) == null) continue;
                pooledActorRefs.add(pooledNodeRef);
            }
        }
        return pooledActorRefs;
    }

    private void mapPooledActors(Collection<IdentityLink> links, Map<QName, Serializable> properties) {
        List<NodeRef> pooledActorRefs = this.getPooledActorsReference(links);
        if (pooledActorRefs != null) {
            properties.put(WorkflowModel.ASSOC_POOLED_ACTORS, (Serializable)((Object)pooledActorRefs));
        }
    }

    public Map<QName, Serializable> getTaskProperties(DelegateTask task, TypeDefinition typeDefinition, boolean localOnly) {
        Map taskProperties = typeDefinition.getProperties();
        Map taskAssociations = typeDefinition.getAssociations();
        HashMap<String, Object> localVariables = task.getVariablesLocal();
        HashMap<String, Object> variables = null;
        if (!localOnly) {
            variables = new HashMap<String, Object>();
            variables.putAll(localVariables);
            Map executionVariables = task.getExecution().getVariables();
            for (Map.Entry entry : executionVariables.entrySet()) {
                String key = (String)entry.getKey();
                if (localVariables.containsKey(key)) continue;
                variables.put(key, entry.getValue());
            }
        } else {
            variables = localVariables;
        }
        Map<QName, Serializable> properties = this.mapArbitraryProperties(variables, localVariables, taskProperties, taskAssociations);
        properties.put(WorkflowModel.PROP_TASK_ID, (Serializable)((Object)task.getId()));
        properties.put(WorkflowModel.PROP_START_DATE, task.getCreateTime());
        properties.put(WorkflowModel.PROP_DUE_DATE, task.getDueDate());
        properties.put(WorkflowModel.PROP_COMPLETION_DATE, null);
        properties.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(task.getPriority()));
        properties.put(ContentModel.PROP_CREATED, task.getCreateTime());
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)task.getAssignee()));
        Set links = ((TaskEntity)task).getCandidates();
        this.mapPooledActors(links, properties);
        return this.filterTaskProperties(properties);
    }

    public Map<QName, Serializable> getTaskProperties(HistoricTaskInstance historicTask, Map<String, Object> localVariables) {
        String formKey = (String)localVariables.get("taskFormKey");
        TypeDefinition taskDef = this.typeManager.getFullTaskDefinition(formKey);
        Map taskProperties = taskDef.getProperties();
        Map taskAssociations = taskDef.getAssociations();
        Map<String, Object> allVariables = this.getHistoricProcessVariables(historicTask.getProcessInstanceId());
        allVariables.putAll(localVariables);
        Map<QName, Serializable> properties = this.mapArbitraryProperties(allVariables, localVariables, taskProperties, taskAssociations);
        properties.put(WorkflowModel.PROP_TASK_ID, (Serializable)((Object)historicTask.getId()));
        properties.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)historicTask.getDescription()));
        properties.put(WorkflowModel.PROP_START_DATE, historicTask.getStartTime());
        properties.put(WorkflowModel.PROP_DUE_DATE, historicTask.getDueDate());
        properties.put(WorkflowModel.PROP_COMPLETION_DATE, historicTask.getEndTime());
        properties.put(WorkflowModel.PROP_PRIORITY, Integer.valueOf(historicTask.getPriority()));
        properties.put(ContentModel.PROP_CREATED, historicTask.getStartTime());
        properties.put(ContentModel.PROP_OWNER, (Serializable)((Object)historicTask.getAssignee()));
        String outcomeVarName = this.factory.mapQNameToName(WorkflowModel.PROP_OUTCOME);
        if (localVariables.get(outcomeVarName) != null) {
            properties.put(WorkflowModel.PROP_OUTCOME, (Serializable)localVariables.get(outcomeVarName));
        }
        ArrayList<NodeRef> pooledActors = new ArrayList<NodeRef>();
        List pooledActorRefIds = (List)localVariables.get("pooledActorsHistory");
        if (pooledActorRefIds != null) {
            for (String nodeId : pooledActorRefIds) {
                pooledActors.add(new NodeRef(nodeId));
            }
        }
        properties.put(WorkflowModel.ASSOC_POOLED_ACTORS, pooledActors);
        return this.filterTaskProperties(properties);
    }

    public void setDefaultTaskProperties(DelegateTask task) {
        TypeDefinition typeDefinition = this.typeManager.getFullTaskDefinition(task);
        Map<QName, Serializable> existingValues = this.getTaskProperties(task, typeDefinition, true);
        HashMap<QName, Serializable> defaultValues = new HashMap<QName, Serializable>();
        Map propertyDefs = typeDefinition.getProperties();
        for (Map.Entry entry : propertyDefs.entrySet()) {
            QName key = (QName)entry.getKey();
            String defaultValue = ((PropertyDefinition)entry.getValue()).getDefaultValue();
            if (defaultValue == null || existingValues.get(key) != null) continue;
            defaultValues.put(key, (Serializable)((Object)defaultValue));
        }
        PropertyDefinition priorDef = (PropertyDefinition)propertyDefs.get(WorkflowModel.PROP_PRIORITY);
        Serializable existingValue = existingValues.get(WorkflowModel.PROP_PRIORITY);
        try {
            if (priorDef != null) {
                for (ConstraintDefinition constraintDef : priorDef.getConstraints()) {
                    constraintDef.getConstraint().evaluate((Object)existingValue);
                }
            }
        }
        catch (ConstraintException ce) {
            Integer defaultVal = Integer.valueOf(priorDef.getDefaultValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Task priority value (" + existingValue + ") was invalid so it was set to the default value of " + defaultVal + ". Task:" + task.getName()));
            }
            defaultValues.put(WorkflowModel.PROP_PRIORITY, defaultVal);
        }
        String description = (String)((Object)existingValues.get(WorkflowModel.PROP_DESCRIPTION));
        if (description == null || description.length() == 0) {
            String processDefinitionKey = ((ProcessDefinition)((TaskEntity)task).getExecution().getProcessDefinition()).getKey();
            description = this.factory.getTaskDescription(typeDefinition, this.factory.buildGlobalId(processDefinitionKey), null, task.getTaskDefinitionKey());
            if (description != null && description.length() > 0) {
                defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
            } else {
                String descriptionKey = this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DESCRIPTION);
                description = (String)task.getExecution().getVariable(descriptionKey);
                if (description != null && description.length() > 0) {
                    defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
                } else {
                    defaultValues.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)task.getName()));
                }
            }
        }
        if (defaultValues.size() > 0) {
            this.setTaskProperties(task, defaultValues);
        }
    }

    public Map<QName, Serializable> getStartTaskProperties(HistoricProcessInstance historicProcessInstance, String taskDefId, boolean completed) {
        TypeDefinition taskDef = this.typeManager.getStartTaskDefinition(taskDefId);
        Map taskProperties = taskDef.getProperties();
        Map taskAssociations = taskDef.getAssociations();
        Map<String, Object> variables = this.getStartVariables(historicProcessInstance);
        Map<QName, Serializable> properties = this.mapArbitraryProperties(variables, variables, taskProperties, taskAssociations);
        properties.put(WorkflowModel.PROP_TASK_ID, (Serializable)((Object)("start" + historicProcessInstance.getId())));
        properties.put(WorkflowModel.PROP_START_DATE, historicProcessInstance.getStartTime());
        String wfDueDateKey = this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_DUE_DATE);
        String dueDateKey = this.factory.mapQNameToName(WorkflowModel.PROP_DUE_DATE);
        Serializable dueDate = (Serializable)variables.get(wfDueDateKey);
        if (dueDate == null) {
            dueDate = (Serializable)variables.get(dueDateKey);
        }
        properties.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        properties.put(WorkflowModel.PROP_COMPLETION_DATE, historicProcessInstance.getStartTime());
        String priorityKey = this.factory.mapQNameToName(WorkflowModel.PROP_PRIORITY);
        Serializable priority = (Serializable)variables.get(priorityKey);
        if (priority == null) {
            String wfPriorityKey = this.factory.mapQNameToName(WorkflowModel.PROP_WORKFLOW_PRIORITY);
            priority = (Serializable)variables.get(wfPriorityKey);
        }
        properties.put(WorkflowModel.PROP_PRIORITY, priority);
        properties.put(ContentModel.PROP_CREATED, historicProcessInstance.getStartTime());
        ActivitiScriptNode ownerNode = (ActivitiScriptNode)variables.get("initiator");
        if (ownerNode != null && ownerNode.exists()) {
            properties.put(ContentModel.PROP_OWNER, (Serializable)ownerNode.getProperties().get("userName"));
        }
        if (completed) {
            properties.put(WorkflowModel.PROP_STATUS, (Serializable)((Object)"Completed"));
            properties.put(WorkflowModel.PROP_OUTCOME, (Serializable)((Object)"Next"));
        }
        return this.filterTaskProperties(properties);
    }

    public Map<String, Object> getStartVariables(HistoricProcessInstance historicProcessInstance) {
        HistoricActivityInstance startEvent = (HistoricActivityInstance)this.activitiUtil.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(historicProcessInstance.getId()).activityId(historicProcessInstance.getStartActivityId()).singleResult();
        Map<String, Object> variables = this.getHistoricActivityVariables(startEvent.getId());
        return variables;
    }

    public Map<String, Object> getHistoricProcessVariables(String processId) {
        HistoricDetailQuery query = this.activitiUtil.getHistoryService().createHistoricDetailQuery().processInstanceId(processId).excludeTaskDetails();
        return this.getHistoricVariables(query);
    }

    public Map<String, Object> getHistoricTaskVariables(String taskId) {
        HistoricDetailQuery query = this.activitiUtil.getHistoryService().createHistoricDetailQuery().taskId(taskId);
        return this.getHistoricVariables(query);
    }

    public Map<String, Object> getHistoricActivityVariables(String activityId) {
        HistoricDetailQuery query = this.activitiUtil.getHistoryService().createHistoricDetailQuery().activityInstanceId(activityId);
        return this.getHistoricVariables(query);
    }

    private Map<String, Object> getHistoricVariables(HistoricDetailQuery query) {
        List historicDetails = ((HistoricDetailQuery)((HistoricDetailQuery)((HistoricDetailQuery)query.variableUpdates().orderByVariableName().asc()).orderByTime().desc()).orderByVariableRevision().desc()).list();
        return this.convertHistoricDetails(historicDetails);
    }

    private Map<QName, Serializable> mapArbitraryProperties(Map<String, Object> variables, final Map<String, Object> localVariables, final Map<QName, PropertyDefinition> taskProperties, final Map<QName, AssociationDefinition> taskAssociations) {
        EntryTransformer<String, Object, QName, Serializable> transformer = new EntryTransformer<String, Object, QName, Serializable>(){

            public Pair<QName, Serializable> apply(Map.Entry<String, Object> entry) {
                String key = entry.getKey();
                QName qname = ActivitiPropertyConverter.this.factory.mapNameToQName(key);
                if (taskProperties.containsKey(qname) || taskAssociations.containsKey(qname) || localVariables.containsKey(key)) {
                    Serializable value = ActivitiPropertyConverter.this.convertPropertyValue(entry.getValue());
                    return new Pair((Object)qname, (Object)value);
                }
                return null;
            }
        };
        return CollectionUtils.transform(variables, (Function)transformer);
    }

    public Serializable convertPropertyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (this.nodeConverter.isSupported(value)) {
            return this.nodeConverter.convert(value);
        }
        if (value instanceof Serializable) {
            return (Serializable)value;
        }
        String msg = this.messageService.getMessage(ERR_CONVERT_VALUE, value);
        throw new WorkflowException(msg);
    }

    public Object convertPropertyToValue(Object property) {
        if (property instanceof NodeRef) {
            return this.nodeConverter.convertNode((NodeRef)property);
        }
        if (property instanceof Collection) {
            boolean allNodes = true;
            for (Object item : (Collection)property) {
                if (item instanceof NodeRef) continue;
                allNodes = false;
                break;
            }
            if (allNodes) {
                return this.nodeConverter.convertNodes((Collection)property);
            }
            return property;
        }
        return property;
    }

    public Serializable convertValueToPropertyType(Task task, Serializable value, QName propertyName) {
        TypeDefinition taskDef = this.typeManager.getFullTaskDefinition(task);
        PropertyDefinition propDef = (PropertyDefinition)taskDef.getProperties().get(propertyName);
        if (propDef != null) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(propDef.getDataType(), (Object)value);
        }
        return value;
    }

    private Map<QName, Serializable> getNewTaskProperties(Task task, Map<QName, Serializable> properties, Map<QName, List<NodeRef>> add, Map<QName, List<NodeRef>> remove) {
        Map<QName, Serializable> newProperties = properties;
        if (add != null || remove != null) {
            if (newProperties == null) {
                newProperties = new HashMap<QName, Serializable>(10);
            }
            Map<QName, Serializable> existingProperties = this.getTaskProperties(task);
            if (add != null) {
                for (Map.Entry<QName, List<NodeRef>> toAdd : add.entrySet()) {
                    Serializable existingAdd = newProperties.get(toAdd.getKey());
                    if (existingAdd == null) {
                        existingAdd = existingProperties.get(toAdd.getKey());
                        newProperties.put(toAdd.getKey(), existingAdd);
                    }
                    if (existingAdd == null) {
                        newProperties.put(toAdd.getKey(), (Serializable)((Object)toAdd.getValue()));
                        continue;
                    }
                    if (existingAdd instanceof List) {
                        List existingList = (List)((Object)existingAdd);
                        for (NodeRef nodeRef : toAdd.getValue()) {
                            if (existingList.contains(nodeRef)) continue;
                            existingList.add(nodeRef);
                        }
                        continue;
                    }
                    if (toAdd.getValue().size() <= 0) continue;
                    newProperties.put(toAdd.getKey(), (Serializable)toAdd.getValue().get(0));
                }
            }
            if (remove != null) {
                for (Map.Entry<QName, List<NodeRef>> toRemove : remove.entrySet()) {
                    boolean isAlreadyNewProperty;
                    ArrayList existingRemove = newProperties.get(toRemove.getKey());
                    boolean bl = isAlreadyNewProperty = existingRemove != null;
                    if (existingRemove == null) {
                        existingRemove = existingProperties.get(toRemove.getKey());
                    }
                    if (existingRemove == null) continue;
                    if (existingRemove instanceof List) {
                        existingRemove = new ArrayList(existingRemove);
                        for (NodeRef nodeRef : toRemove.getValue()) {
                            ((List)existingRemove).remove(nodeRef);
                        }
                        newProperties.put(toRemove.getKey(), existingRemove);
                        continue;
                    }
                    if (isAlreadyNewProperty) continue;
                    newProperties.put(toRemove.getKey(), null);
                }
            }
        }
        return newProperties;
    }

    public void setTaskProperties(DelegateTask task, Map<QName, Serializable> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        TypeDefinition type = this.typeManager.getFullTaskDefinition(task);
        Map<String, Object> variablesToSet = this.handlerRegistry.handleVariablesToSet(properties, type, task, DelegateTask.class);
        if (variablesToSet.size() > 0) {
            task.setVariablesLocal(variablesToSet);
        }
    }

    public void setTaskProperties(Task task, Map<QName, Serializable> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        TypeDefinition type = this.typeManager.getFullTaskDefinition(task);
        Map<String, Object> variablesToSet = this.handlerRegistry.handleVariablesToSet(properties, type, task, Task.class);
        TaskService taskService = this.activitiUtil.getTaskService();
        taskService.saveTask(task);
        taskService.setVariablesLocal(task.getId(), variablesToSet);
        this.setTaskOwner(task, properties);
    }

    private void setTaskOwner(Task task, Map<QName, Serializable> properties) {
        QName ownerKey = ContentModel.PROP_OWNER;
        if (properties.containsKey(ownerKey)) {
            Serializable owner = properties.get(ownerKey);
            if (owner != null && !(owner instanceof String)) {
                throw this.getInvalidPropertyValueException(ownerKey, owner);
            }
            String assignee = (String)((Object)owner);
            String currentAssignee = task.getAssignee();
            if (!ObjectUtils.equals((Object)currentAssignee, (Object)assignee)) {
                this.activitiUtil.getTaskService().setAssignee(task.getId(), assignee);
            }
        }
    }

    private WorkflowException getInvalidPropertyValueException(QName key, Serializable value) {
        String msg = this.messageService.getMessage(ERR_SET_TASK_PROPS_INVALID_VALUE, value, key);
        return new WorkflowException(msg);
    }

    private Map<QName, Serializable> filterTaskProperties(Map<QName, Serializable> properties) {
        if (properties != null) {
            properties.remove(QName.createQName(null, (String)"pooledActorsHistory"));
            properties.remove(QName.createQName(null, (String)"taskFormKey"));
        }
        return properties;
    }

    public Map<String, Object> convertHistoricDetails(List<HistoricDetail> details) {
        Collections.sort(details, new Comparator<HistoricDetail>(){

            @Override
            public int compare(HistoricDetail o1, HistoricDetail o2) {
                Long id1 = Long.valueOf(o1.getId());
                Long id2 = Long.valueOf(o2.getId());
                return -id1.compareTo(id2);
            }
        });
        HashMap<String, Object> variables = new HashMap<String, Object>();
        for (HistoricDetail detail : details) {
            HistoricVariableUpdate varUpdate = (HistoricVariableUpdate)detail;
            if (variables.containsKey(varUpdate.getVariableName())) continue;
            variables.put(varUpdate.getVariableName(), varUpdate.getValue());
        }
        return variables;
    }

    public Map<String, Object> getStartVariables(String processDefId, Map<QName, Serializable> properties) {
        String description;
        ProcessDefinition procDef = this.activitiUtil.getProcessDefinition(processDefId);
        String startTaskTypeName = this.activitiUtil.getStartTaskTypeName(processDefId);
        TypeDefinition startTaskType = this.factory.getTaskFullTypeDefinition(startTaskTypeName, true);
        Map taskProperties = startTaskType.getProperties();
        HashMap<QName, Serializable> defaultProperties = new HashMap<QName, Serializable>();
        for (Map.Entry entry : taskProperties.entrySet()) {
            String defaultValue = ((PropertyDefinition)entry.getValue()).getDefaultValue();
            if (defaultValue == null) continue;
            defaultProperties.put((QName)entry.getKey(), (Serializable)((Object)defaultValue));
        }
        if (properties != null) {
            defaultProperties.putAll(properties);
        }
        if ((description = (String)defaultProperties.get(WorkflowModel.PROP_DESCRIPTION)) == null) {
            String wfDescription = (String)defaultProperties.get(WorkflowModel.PROP_WORKFLOW_DESCRIPTION);
            String procDefKey = procDef.getKey();
            ReadOnlyProcessDefinition deployedDef = this.activitiUtil.getDeployedProcessDefinition(processDefId);
            String startEventName = deployedDef.getInitial().getId();
            String wfDefKey = this.factory.buildGlobalId(procDefKey);
            description = this.factory.getTaskDescription(startTaskType, wfDefKey, wfDescription, startEventName);
            defaultProperties.put(WorkflowModel.PROP_DESCRIPTION, (Serializable)((Object)description));
        }
        if (!defaultProperties.containsKey(WorkflowModel.PROP_WORKFLOW_DUE_DATE) && taskProperties.containsKey(WorkflowModel.PROP_WORKFLOW_DUE_DATE)) {
            defaultProperties.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, null);
        }
        return this.handlerRegistry.handleVariablesToSet(defaultProperties, startTaskType, null, Void.class);
    }

    public void checkMandatoryProperties(DelegateTask task) {
        List<QName> missingProps = this.getMissingMandatoryTaskProperties(task);
        if (missingProps != null && missingProps.size() > 0) {
            String missingPropString = StringUtils.join(missingProps.iterator(), (String)", ");
            throw new WorkflowException(this.messageService.getMessage(ERR_MANDATORY_TASK_PROPERTIES_MISSING, missingPropString));
        }
    }

    private List<QName> getMissingMandatoryTaskProperties(DelegateTask task) {
        TypeDefinition typeDefinition = this.typeManager.getFullTaskDefinition(task);
        Map<QName, Serializable> existingValues = this.getTaskProperties(task, typeDefinition, false);
        Map propertyDefs = typeDefinition.getProperties();
        Map assocDefs = typeDefinition.getAssociations();
        List<QName> missingProps = this.findMissingProperties(existingValues, propertyDefs);
        List<QName> missingAssocs = this.findMissingProperties(existingValues, assocDefs);
        missingProps.addAll(missingAssocs);
        return missingProps;
    }

    private List<QName> findMissingProperties(Map<QName, Serializable> existingValues, Map<QName, ? extends ClassAttributeDefinition> definitions) {
        ArrayList<QName> missingProps = new ArrayList<QName>();
        for (Map.Entry<QName, ? extends ClassAttributeDefinition> entry : definitions.entrySet()) {
            Serializable value;
            QName name = entry.getKey();
            if (name.getNamespaceURI().equals("http://www.alfresco.org/model/content/1.0") || name.getNamespaceURI().equals("http://www.alfresco.org/model/system/1.0") || !this.isMandatory(entry.getValue()) || (value = existingValues.get(entry.getKey())) != null && !this.isEmptyString(value)) continue;
            missingProps.add(entry.getKey());
        }
        return missingProps;
    }

    private boolean isMandatory(ClassAttributeDefinition definition) {
        if (definition instanceof PropertyDefinition) {
            PropertyDefinition propDef = (PropertyDefinition)definition;
            return propDef.isMandatory();
        }
        AssociationDefinition assocDSef = (AssociationDefinition)definition;
        return assocDSef.isTargetMandatory();
    }

    private boolean isEmptyString(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return str.isEmpty();
        }
        return false;
    }

    public Task updateTask(Task task, Map<QName, Serializable> properties, Map<QName, List<NodeRef>> add, Map<QName, List<NodeRef>> remove) {
        Map<QName, Serializable> newProperties = this.getNewTaskProperties(task, properties, add, remove);
        if (newProperties != null) {
            this.setTaskProperties(task, newProperties);
            return this.activitiUtil.getTaskInstance(task.getId());
        }
        return task;
    }
}

