/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowTestHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.hibernate.HibernateException;
import org.springframework.context.ApplicationContext;

public class JbpmTimerTest
extends TestCase {
    private static final String simpleDefLocation = "jbpmresources/test_simpleTimer.xml";
    private static final String exceptionDefLocation = "jbpmresources/test_timerException.xml";
    private WorkflowService workflowService;
    private WorkflowTestHelper testHelper;
    private String defId;

    public void testTimerException() throws Exception {
        this.defId = this.deployDefinition(exceptionDefLocation);
        NodeRef pckg = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckg);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        WorkflowPath path = this.workflowService.startWorkflow(this.defId, params);
        String instanceId = path.getInstance().getId();
        WorkflowTask start = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(start.getId(), null);
        Thread.sleep(30000L);
        System.out.println("Done!");
    }

    public void testTimerIsReassignable() throws Exception {
        this.defId = this.deployDefinition(simpleDefLocation);
        NodeRef pckg = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckg);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)((Object)AuthenticationUtil.getAdminUserName()));
        WorkflowPath path = this.workflowService.startWorkflow(this.defId, params);
        String instanceId = path.getInstance().getId();
        WorkflowTask start = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(start.getId(), null);
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        WorkflowTask task = tasks.get(0);
        JbpmTimerTest.assertTrue((boolean)this.workflowService.isTaskReassignable(task, AuthenticationUtil.getAdminUserName()));
        Thread.sleep(30000L);
        JbpmTimerTest.assertFalse((boolean)this.workflowService.isTaskReassignable(task, AuthenticationUtil.getAdminUserName()));
    }

    protected void setUp() throws Exception {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry services = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.workflowService = services.getWorkflowService();
        WorkflowAdminServiceImpl adminService = (WorkflowAdminServiceImpl)ctx.getBean("workflowAdminService");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.testHelper = new WorkflowTestHelper(adminService, "jbpm", false);
        this.testHelper.setVisible(true);
    }

    private String deployDefinition(String location) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream(exceptionDefLocation);
        input = classLoader.getResourceAsStream(location);
        WorkflowDeployment deployment = this.workflowService.deployDefinition("jbpm", input, "text/xml");
        return deployment.getDefinition().getId();
    }

    protected void tearDown() throws Exception {
        this.workflowService.undeployDefinition(this.defId);
        this.testHelper.tearDown();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public static void throwException() throws HibernateException {
        throw new HibernateException("My Timer Exception");
    }
}

