/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMNodeList;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.jbpm.context.exe.converter.SerializableToByteArrayConverter;
import org.jbpm.graph.def.ProcessDefinition;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springmodules.workflow.jbpm31.JbpmFactoryLocator;

public class NodeListConverter
extends SerializableToByteArrayConverter {
    private static final long serialVersionUID = 1L;
    private static BeanFactoryLocator jbpmFactoryLocator = new JbpmFactoryLocator();

    public boolean supports(Object value) {
        if (value == null) {
            return true;
        }
        return value.getClass() == JBPMNodeList.class;
    }

    public Object convert(Object o) {
        Object converted = null;
        if (o != null) {
            JBPMNodeList nodes = (JBPMNodeList)o;
            ArrayList<NodeRef> values = new ArrayList<NodeRef>(nodes.size());
            for (JBPMNode node : nodes) {
                values.add(node.getNodeRef());
            }
            converted = super.convert(values);
        }
        return converted;
    }

    public Object revert(Object o) {
        JBPMNodeList reverted = null;
        if (o != null) {
            Object nodeRefs = super.revert(o);
            reverted = this.revertNodes(nodeRefs);
        }
        return reverted;
    }

    public Object revert(Object o, ProcessDefinition processDefinition) {
        JBPMNodeList reverted = null;
        if (o != null) {
            Object nodeRefs = super.revert(o, processDefinition);
            reverted = this.revertNodes(nodeRefs);
        }
        return reverted;
    }

    private JBPMNodeList revertNodes(Object value) {
        BeanFactoryReference factory = jbpmFactoryLocator.useBeanFactory(null);
        ServiceRegistry serviceRegistry = (ServiceRegistry)factory.getFactory().getBean("ServiceRegistry");
        JBPMNodeList nodes = new JBPMNodeList();
        Collection nodeRefs = (Collection)value;
        for (NodeRef nodeRef : nodeRefs) {
            nodes.add(new JBPMNode(nodeRef, serviceRegistry));
        }
        return nodes;
    }
}

