/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;
import org.alfresco.repo.workflow.TaskComponent;
import org.alfresco.repo.workflow.WorkflowComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.springframework.core.io.ClassPathResource;

public class ReviewAndApproveTest
extends BaseSpringTest {
    AuthenticationComponent authenticationComponent;
    PersonService personService;
    WorkflowComponent workflowComponent;
    TaskComponent taskComponent;
    WorkflowDefinition testWorkflowDef;
    NodeRef testNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        BPMEngineRegistry registry = (BPMEngineRegistry)this.applicationContext.getBean("bpm_engineRegistry");
        this.workflowComponent = registry.getWorkflowComponent("jbpm");
        this.taskComponent = registry.getTaskComponent("jbpm");
        ClassPathResource processDef = new ClassPathResource("alfresco/workflow/review_processdefinition.xml");
        WorkflowDeployment deployment = this.workflowComponent.deployDefinition(processDef.getInputStream(), "text/xml");
        this.testWorkflowDef = deployment.getDefinition();
        ReviewAndApproveTest.assertNotNull((Object)this.testWorkflowDef);
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        NodeService nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        this.testNodeRef = nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
    }

    protected void onTearDownInTransaction() {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testSubmitForReview() {
        WorkflowDefinition workflowDef = this.testWorkflowDef;
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)this.testNodeRef);
        Date reviewDueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, reviewDueDate);
        NodeRef reviewer = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)reviewer);
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, (Serializable)((Object)"Test review"));
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), params);
        ReviewAndApproveTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        ReviewAndApproveTest.assertNotNull(tasks1);
        ReviewAndApproveTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        ReviewAndApproveTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.ASSOC_PACKAGE));
        WorkflowTask endedTask = this.taskComponent.endTask(task.getId(), null);
        ReviewAndApproveTest.assertNotNull((Object)endedTask);
        ReviewAndApproveTest.assertTrue((boolean)endedTask.getProperties().containsKey(WorkflowModel.PROP_OUTCOME));
        ReviewAndApproveTest.assertEquals((Object)"", (Object)endedTask.getProperties().get(WorkflowModel.PROP_OUTCOME));
        ReviewAndApproveTest.assertEquals((Object)"Test review", (Object)endedTask.getProperties().get(WorkflowModel.PROP_DESCRIPTION));
        ReviewAndApproveTest.assertEquals((String)"Test review", (String)endedTask.getPath().getInstance().getDescription());
        List<WorkflowTask> assignedTasks = this.taskComponent.getAssignedTasks(AuthenticationUtil.getAdminUserName(), WorkflowTaskState.IN_PROGRESS);
        ReviewAndApproveTest.assertNotNull(assignedTasks);
        assignedTasks = this.filterTasksByWorkflowInstance(assignedTasks, path.getInstance().getId());
        ReviewAndApproveTest.assertEquals((Object)this.testNodeRef, (Object)assignedTasks.get(0).getProperties().get(WorkflowModel.ASSOC_PACKAGE));
        ReviewAndApproveTest.assertEquals((Object)reviewDueDate, (Object)assignedTasks.get(0).getProperties().get(WorkflowModel.PROP_DUE_DATE));
    }

    public void testCompletedItems() {
        WorkflowDefinition workflowDef = this.testWorkflowDef;
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        nodeRefs.add(this.testNodeRef);
        nodeRefs.add(this.testNodeRef);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)this.testNodeRef);
        params.put(WorkflowModel.PROP_COMPLETED_ITEMS, nodeRefs);
        Date reviewDueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, reviewDueDate);
        NodeRef reviewer = this.personService.getPerson(AuthenticationUtil.getAdminUserName());
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)reviewer);
        WorkflowPath path = this.workflowComponent.startWorkflow(workflowDef.getId(), params);
        ReviewAndApproveTest.assertNotNull((Object)path);
        List<WorkflowTask> tasks1 = this.workflowComponent.getTasksForWorkflowPath(path.getId());
        ReviewAndApproveTest.assertNotNull(tasks1);
        ReviewAndApproveTest.assertEquals((int)1, (int)tasks1.size());
        WorkflowTask task = tasks1.get(0);
        ReviewAndApproveTest.assertTrue((boolean)task.getProperties().containsKey(WorkflowModel.PROP_COMPLETED_ITEMS));
        ReviewAndApproveTest.assertEquals((int)2, (int)((List)((Object)task.getProperties().get(WorkflowModel.PROP_COMPLETED_ITEMS))).size());
    }

    private List<WorkflowTask> filterTasksByWorkflowInstance(List<WorkflowTask> tasks, String workflowInstanceId) {
        ArrayList<WorkflowTask> filteredTasks = new ArrayList<WorkflowTask>();
        for (WorkflowTask task : tasks) {
            if (!task.getPath().getInstance().getId().equals(workflowInstanceId)) continue;
            filteredTasks.add(task);
        }
        return filteredTasks;
    }
}

