/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.lock;

import java.util.Collection;
import java.util.List;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.UnableToAquireLockException;
import org.alfresco.service.cmr.lock.UnableToReleaseLockException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public interface LockService {
    @Auditable(parameters={"nodeRef", "lockType"})
    public void lock(NodeRef var1, LockType var2) throws UnableToAquireLockException;

    @Auditable(parameters={"nodeRef", "lockType", "timeToExpire"})
    public void lock(NodeRef var1, LockType var2, int var3) throws UnableToAquireLockException;

    @Auditable(parameters={"nodeRef", "lockType", "timeToExpire", "lockChildren"})
    public void lock(NodeRef var1, LockType var2, int var3, boolean var4) throws UnableToAquireLockException;

    @Auditable(parameters={"nodeRefs", "lockType", "timeToExpire"})
    public void lock(Collection<NodeRef> var1, LockType var2, int var3) throws UnableToAquireLockException;

    @Auditable(parameters={"nodeRef"})
    public void unlock(NodeRef var1) throws UnableToReleaseLockException;

    @Auditable(parameters={"nodeRef", "lockChildren"})
    public void unlock(NodeRef var1, boolean var2) throws UnableToReleaseLockException;

    @Auditable(parameters={"nodeRefs"})
    public void unlock(Collection<NodeRef> var1) throws UnableToReleaseLockException;

    @Auditable(parameters={"nodeRef"})
    public LockStatus getLockStatus(NodeRef var1);

    @Auditable(parameters={"nodeRef", "userName"})
    public LockStatus getLockStatus(NodeRef var1, String var2);

    @Auditable(parameters={"nodeRef"})
    public LockType getLockType(NodeRef var1);

    @Auditable(parameters={"nodeRef"})
    public void checkForLock(NodeRef var1);

    @Auditable(parameters={"storeRef"})
    public List<NodeRef> getLocks(StoreRef var1);

    @Auditable(parameters={"storeRef", "lockType"})
    public List<NodeRef> getLocks(StoreRef var1, LockType var2);

    public void suspendLocks();

    public void enableLocks();
}

