/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public final class JSONtoFmModel {
    public static String ROOT_ARRAY = "root";
    private static String REGEXP_ISO8061 = "^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})(.([0-9]){3})?(Z|[\\+\\-]([0-9]{2}):([0-9]{2}))$";
    private static Pattern matcherISO8601 = Pattern.compile(REGEXP_ISO8061);
    public static boolean autoConvertISO8601 = true;

    public static Map<String, Object> convertJSONObjectToMap(String jsonString) throws JSONException {
        JSONObject jo = new JSONObject(new JSONTokener(jsonString));
        return JSONtoFmModel.convertJSONObjectToMap(jo);
    }

    public static Map<String, Object> convertJSONObjectToMap(JSONObject jo) throws JSONException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Iterator itr = jo.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object o = jo.get(key);
            if (o instanceof JSONObject) {
                model.put(key, JSONtoFmModel.convertJSONObjectToMap((JSONObject)o));
                continue;
            }
            if (o instanceof JSONArray) {
                model.put(key, JSONtoFmModel.convertJSONArrayToList((JSONArray)o));
                continue;
            }
            if (o == JSONObject.NULL) {
                model.put(key, null);
                continue;
            }
            if (o instanceof String && autoConvertISO8601 && matcherISO8601.matcher((String)o).matches()) {
                o = ISO8601DateFormat.parse((String)((String)o));
            }
            model.put(key, o);
        }
        return model;
    }

    public static Map<String, Object> convertJSONArrayToMap(String jsonString) throws JSONException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        JSONArray ja = new JSONArray(new JSONTokener(jsonString));
        model.put(ROOT_ARRAY, JSONtoFmModel.convertJSONArrayToList(ja));
        return model;
    }

    public static List<Object> convertJSONArrayToList(JSONArray ja) throws JSONException {
        ArrayList<Object> model = new ArrayList<Object>();
        for (int i = 0; i < ja.length(); ++i) {
            Object o = ja.get(i);
            if (o instanceof JSONArray) {
                model.add(JSONtoFmModel.convertJSONArrayToList((JSONArray)o));
                continue;
            }
            if (o instanceof JSONObject) {
                model.add(JSONtoFmModel.convertJSONObjectToMap((JSONObject)o));
                continue;
            }
            if (o == JSONObject.NULL) {
                model.add(null);
                continue;
            }
            if (o instanceof String && autoConvertISO8601 && matcherISO8601.matcher((String)o).matches()) {
                o = ISO8601DateFormat.parse((String)((String)o));
            }
            model.add(o);
        }
        return model;
    }

    public static String toString(Map<String, Object> map) {
        return JSONtoFmModel.toStringBuffer(map, 0).toString();
    }

    private static StringBuffer toStringBuffer(Map<String, Object> unsortedMap, int indent) {
        StringBuffer tabs = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            tabs.append("\t");
        }
        StringBuffer sb = new StringBuffer();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.putAll(unsortedMap);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                sb.append(tabs).append((String)entry.getKey()).append(":").append(entry.getValue().getClass()).append("\n");
                sb.append(JSONtoFmModel.toStringBuffer((Map)entry.getValue(), indent + 1));
                continue;
            }
            if (entry.getValue() instanceof List) {
                sb.append(tabs).append("[\n");
                List l = (List)entry.getValue();
                for (int i = 0; i < l.size(); ++i) {
                    sb.append(tabs).append(l.get(i)).append(":").append(l.get(i) != null ? l.get(i).getClass() : "null").append("\n");
                }
                sb.append(tabs).append("]\n");
                continue;
            }
            sb.append(tabs).append((String)entry.getKey()).append(":").append(entry.getValue()).append(":").append(entry.getValue() != null ? entry.getValue().getClass() : "null").append("\n");
        }
        return sb;
    }
}

