/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.OpenOfficeCommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenOfficeVariant {
    private static final String[] EXTENSIONS = new String[]{"", ".exe", ".com", ".bat", ".cmd"};
    private static final Log logger = LogFactory.getLog(OpenOfficeCommandLine.class);
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private final boolean windows = this.isWindows();

    public File getOfficeHome(File executable) {
        File officeHome = executable;
        for (int i = 1; officeHome != null && i <= 2; officeHome = officeHome.getParentFile(), ++i) {
        }
        if (officeHome == null && executable != null) {
            throw new AlfrescoRuntimeException("Did not find OppenOffice home from executable " + executable.getAbsolutePath());
        }
        return officeHome;
    }

    public File findExecutable(String executableName) {
        File file = new File(executableName);
        file = file.isAbsolute() ? this.canExecute(file) : this.findExecutableOnPath(executableName);
        return file;
    }

    private File findExecutableOnPath(String executableName) {
        String systemPath = System.getenv("PATH");
        systemPath = systemPath == null ? System.getenv("path") : systemPath;
        String[] pathDirs = systemPath.split(File.pathSeparator);
        File fullyQualifiedExecutable = null;
        for (String pathDir : pathDirs) {
            File file = this.canExecute(new File(pathDir, executableName));
            if (file == null) continue;
            fullyQualifiedExecutable = file;
            break;
        }
        return fullyQualifiedExecutable;
    }

    private File canExecute(File file) {
        File fullyQualifiedExecutable = null;
        File dir = file.getParentFile();
        String name = file.getName();
        for (String ext : EXTENSIONS) {
            file = new File(dir, name + ext);
            if (file.canExecute()) {
                fullyQualifiedExecutable = file;
                break;
            }
            if (!this.windows) break;
        }
        return fullyQualifiedExecutable;
    }

    public boolean isLibreOffice3Dot5(File officeHome) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("System.getProperty(\"os.name\")=" + System.getProperty("os.name")));
            logger.debug((Object)("officeHome=" + (officeHome == null ? null : "'" + officeHome.getAbsolutePath() + "'")));
            logger.debug((Object)("basis-link:" + new File(officeHome, "basis-link").isFile()));
            logger.debug((Object)("basis-link:" + new File(officeHome, "basis-link").isDirectory()));
            logger.debug((Object)("  ure-link:" + new File(officeHome, "ure-link").isFile()));
            logger.debug((Object)("  ure-link:" + new File(officeHome, "ure-link").isDirectory()));
            logger.debug((Object)("    NOTICE:" + new File(officeHome, "NOTICE").isFile()));
        }
        return officeHome != null && !new File(officeHome, "basis-link").isFile() && (new File(officeHome, "ure-link").isFile() || new File(officeHome, "ure-link").isDirectory());
    }

    public boolean isLibreOffice3Dot6(File officeHome) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("    NOTICE:" + new File(officeHome, "NOTICE").isFile()));
        }
        return this.isLibreOffice3Dot5(officeHome) && new File(officeHome, "NOTICE").isFile();
    }

    public boolean isLinux() {
        return OS_NAME.startsWith("linux");
    }

    public boolean isMac() {
        return OS_NAME.startsWith("mac");
    }

    public boolean isWindows() {
        return OS_NAME.startsWith("windows");
    }
}

