/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.Path;

public class PathUtil {
    public static String getDisplayPath(Path path, boolean showLeaf) {
        StringBuilder buf = new StringBuilder(64);
        int count = path.size() - (showLeaf ? 0 : 1);
        for (int i = 0; i < count; ++i) {
            String elementString = null;
            Path.Element element = path.get(i);
            if (element instanceof Path.ChildAssocElement) {
                ChildAssociationRef elementRef = ((Path.ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    elementString = elementRef.getQName().getLocalName();
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString == null) continue;
            buf.append("/");
            buf.append(elementString);
        }
        return buf.toString();
    }
}

