/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;

public abstract class RetryingTransactionHelperTestCase
extends TestCase {
    public abstract RetryingTransactionHelper getRetryingTransactionHelper();

    protected <A> A doTestInTransaction(Test<A> test) {
        return this.doTestInTransaction(test, AuthenticationUtil.getAdminUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <A> A doTestInTransaction(final Test<A> test, String asUser) {
        String origUser = AuthenticationUtil.getFullyAuthenticatedUser();
        AuthenticationUtil.setFullyAuthenticatedUser((String)asUser);
        try {
            RetryingTransactionHelper.RetryingTransactionCallback doRun = new RetryingTransactionHelper.RetryingTransactionCallback<A>(){

                @Override
                public A execute() throws Throwable {
                    return test.run();
                }
            };
            final Object result = this.getRetryingTransactionHelper().doInTransaction(doRun);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> doTest = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    test.test(result);
                    return null;
                }
            };
            this.getRetryingTransactionHelper().doInTransaction(doTest);
            Object r = result;
            return (A)r;
        }
        finally {
            if (origUser != null) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)origUser);
            } else {
                AuthenticationUtil.clearCurrentSecurityContext();
            }
        }
    }

    protected void doTestInTransaction(FailureTest test) {
        this.doTestInTransaction(test, AuthenticationUtil.getAdminUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestInTransaction(final FailureTest test, String asUser) {
        String origUser = AuthenticationUtil.getFullyAuthenticatedUser();
        AuthenticationUtil.setFullyAuthenticatedUser((String)asUser);
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Void> doRun = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    Class<?> eType = test.getExpectedExceptionClass();
                    try {
                        test.run();
                    }
                    catch (Throwable exception) {
                        if (!eType.isInstance(exception)) {
                            throw exception;
                        }
                        return null;
                    }
                    Assert.fail((String)test.getMessage());
                    return null;
                }
            };
            this.getRetryingTransactionHelper().doInTransaction(doRun);
        }
        finally {
            if (origUser != null) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)origUser);
            } else {
                AuthenticationUtil.clearCurrentSecurityContext();
            }
        }
    }

    protected abstract class FailureTest {
        private String message = "This test was expected to fail.";
        private Class<?> expectedExceptionClass = AlfrescoRuntimeException.class;

        public FailureTest(String message) {
            this.message = message;
        }

        public FailureTest(Class<?> expectedExceptionClass) {
            this.expectedExceptionClass = expectedExceptionClass;
        }

        public FailureTest(String message, Class<?> expectedExceptionClass) {
            this.message = message;
            this.expectedExceptionClass = expectedExceptionClass;
        }

        public Class<?> getExpectedExceptionClass() {
            return this.expectedExceptionClass;
        }

        public String getMessage() {
            return this.message;
        }

        public FailureTest() {
        }

        public abstract void run() throws Exception;
    }

    protected abstract class Test<A> {
        protected Map<String, Object> model = new HashMap<String, Object>(5);

        protected Test() {
        }

        protected String setString(String key, String value) {
            if (value != null) {
                this.model.put(key, value);
            }
            return value;
        }

        protected String getString(String key) {
            return (String)this.model.get(key);
        }

        protected NodeRef setNodeRef(String key, NodeRef nodeRef) {
            if (nodeRef != null) {
                this.model.put(key, nodeRef);
            }
            return nodeRef;
        }

        protected NodeRef getNodeRef(String key) {
            return (NodeRef)this.model.get(key);
        }

        public abstract A run() throws Exception;

        public void test(A result) throws Exception {
        }
    }
}

