/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.util.ValueProtectingMap;

public class ValueProtectingMapTest
extends TestCase {
    private static Set<Class<?>> moreImmutableClasses = new HashSet(13);
    private List<String> valueList;
    private Map<String, String> valueMap;
    private Date valueDate;
    private TestImmutable valueImmutable;
    private TestMutable valueMutable;
    private ValueProtectingMap<String, Serializable> map;
    private Map<String, Serializable> holyMap;

    protected void setUp() throws Exception {
        this.valueList = new ArrayList<String>(4);
        this.valueList.add("ONE");
        this.valueList.add("TWO");
        this.valueList.add("THREE");
        this.valueList.add("FOUR");
        this.valueList = Collections.unmodifiableList(this.valueList);
        this.valueMap = new HashMap<String, String>(5);
        this.valueMap.put("ONE", "ONE");
        this.valueMap.put("TWO", "TWO");
        this.valueMap.put("THREE", "THREE");
        this.valueMap.put("FOUR", "FOUR");
        this.valueMap = Collections.unmodifiableMap(this.valueMap);
        this.valueDate = new Date();
        this.valueImmutable = new TestImmutable();
        this.valueMutable = new TestMutable();
        this.holyMap = new HashMap<String, Serializable>();
        this.holyMap.put("DATE", this.valueDate);
        this.holyMap.put("LIST", (Serializable)((Object)this.valueList));
        this.holyMap.put("MAP", (Serializable)((Object)this.valueMap));
        this.holyMap.put("IMMUTABLE", this.valueImmutable);
        this.holyMap.put("MUTABLE", this.valueMutable);
        this.holyMap = Collections.unmodifiableMap(this.holyMap);
        this.map = new ValueProtectingMap<String, Serializable>(this.holyMap, moreImmutableClasses);
    }

    private void checkMaps(boolean expectMapClone) {
        ValueProtectingMapTest.assertEquals((String)"Holy map size is wrong: ", (int)5, (int)this.holyMap.size());
        if (expectMapClone) {
            ValueProtectingMapTest.assertTrue((String)"Expect holy map to have been released: ", (this.map.getProtectedMap() != this.holyMap ? 1 : 0) != 0);
            Map<String, Serializable> mapClone = this.map.getProtectedMap();
            mapClone.put("ONE", (Serializable)((Object)"ONE"));
            ValueProtectingMapTest.assertEquals((String)"Modified the backing directly but value is not visible: ", (Object)this.map.get("ONE"), (Object)"ONE");
            this.map.put("TWO", (Serializable)((Object)"TWO"));
            ValueProtectingMapTest.assertTrue((String)"Backing map was changed again!", (mapClone == this.map.getProtectedMap() ? 1 : 0) != 0);
            mapClone.containsKey("TWO");
        } else {
            ValueProtectingMapTest.assertTrue((String)"Expect holy map to still be in use: ", (this.map.getProtectedMap() == this.holyMap ? 1 : 0) != 0);
        }
    }

    public void testSetup() {
        this.checkMaps(false);
    }

    public void testMapWrapping() {
        ValueProtectingMap<String, Serializable> mapTwo = new ValueProtectingMap<String, Serializable>(this.map);
        ValueProtectingMapTest.assertTrue((String)"Backing map must be shared: ", (mapTwo.getProtectedMap() == this.map.getProtectedMap() ? 1 : 0) != 0);
        ValueProtectingMap<String, Serializable> mapThree = new ValueProtectingMap<String, Serializable>(this.map);
        ValueProtectingMapTest.assertTrue((String)"Backing map must be shared: ", (mapThree.getProtectedMap() == this.map.getProtectedMap() ? 1 : 0) != 0);
    }

    public void testMapClear() {
        this.map.clear();
        ValueProtectingMapTest.assertEquals((String)"Map should be empty: ", (int)0, (int)this.map.size());
        this.checkMaps(true);
    }

    public void testMapContainsKey() {
        ValueProtectingMapTest.assertTrue((boolean)this.map.containsKey("LIST"));
        ValueProtectingMapTest.assertFalse((boolean)this.map.containsKey("LISTXXX"));
        this.checkMaps(false);
    }

    public void testMapContainsValue() {
        ValueProtectingMapTest.assertTrue((boolean)this.map.containsValue(this.valueMutable));
        ValueProtectingMapTest.assertFalse((boolean)this.map.containsValue("Dassie"));
        this.checkMaps(false);
    }

    public void testMapEntrySet() {
        this.map.entrySet();
        this.checkMaps(true);
    }

    public void testMapGetImmutable() {
        ValueProtectingMapTest.assertTrue((String)"Immutable value instance incorrect", (this.map.get("IMMUTABLE") == this.valueImmutable ? 1 : 0) != 0);
        this.checkMaps(false);
    }

    public void testMapGetMutable() {
        TestMutable mutable = (TestMutable)this.map.get("MUTABLE");
        ValueProtectingMapTest.assertFalse((String)"Mutable value instance incorrect", (mutable == this.valueMutable ? 1 : 0) != 0);
        this.checkMaps(false);
        mutable.increment();
        ValueProtectingMapTest.assertEquals((String)"Backing mutable should not have changed: ", (int)0, (int)this.valueMutable.i);
    }

    public void testMapIsEmpty() {
        ValueProtectingMapTest.assertFalse((boolean)this.map.isEmpty());
        this.checkMaps(false);
    }

    public void testMapKeySet() {
        this.map.keySet();
        this.checkMaps(true);
    }

    public void testMapPut() {
        this.map.put("ANOTHER", (Serializable)((Object)"VALUE"));
        this.checkMaps(true);
    }

    public void testMapPutAll() {
        this.map.putAll(this.holyMap);
        this.checkMaps(true);
    }

    public void testSerializability() throws Exception {
        this.map.put("MORE", (Serializable)((Object)"STUFF"));
        this.checkMaps(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(this.map);
        os.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        ValueProtectingMap reloadedMap = (ValueProtectingMap)ois.readObject();
        ois.close();
        ValueProtectingMapTest.assertEquals((String)"Reloaded object not same.", (Object)"STUFF", (Object)reloadedMap.get("MORE"));
    }

    static {
        moreImmutableClasses.add(TestImmutable.class);
    }

    private static class TestMutable
    extends TestImmutable {
        public int i = 0;

        private TestMutable() {
        }

        public void increment() {
            ++this.i;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestMutable other = (TestMutable)obj;
            return this.i == other.i;
        }
    }

    private static class TestImmutable
    implements Serializable {
        private TestImmutable() {
        }
    }
}

