/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.schemacomp.DbToXML;
import org.springframework.context.ApplicationContext;

public class MultiFileDumper {
    private final String[] dbPrefixes;
    private final File directory;
    private final String fileNameTemplate;
    private final DbToXMLFactory dbToXMLFactory;
    private static final String fileNameSuffix = ".xml";
    public static final String[] DEFAULT_PREFIXES = new String[]{"alf_", "avm_", "jbpm_", "act_"};

    public MultiFileDumper(String[] dbPrefixes, File directory, String fileNameTemplate, DbToXMLFactory dbToXMLFactory) {
        ParameterCheck.mandatory((String)"dbPrefixes", (Object)dbPrefixes);
        ParameterCheck.mandatory((String)"directory", (Object)directory);
        ParameterCheck.mandatory((String)"fileNameTemplate", (Object)fileNameTemplate);
        ParameterCheck.mandatory((String)"dbToXMLFactory", (Object)dbToXMLFactory);
        if (dbPrefixes.length == 0) {
            throw new IllegalArgumentException("At least one database object prefix is required.");
        }
        this.dbPrefixes = dbPrefixes;
        this.directory = directory;
        this.fileNameTemplate = fileNameTemplate;
        this.dbToXMLFactory = dbToXMLFactory;
    }

    public MultiFileDumper(File directory, String fileNameTemplate, DbToXMLFactory dbToXMLFactory) {
        this(DEFAULT_PREFIXES, directory, fileNameTemplate, dbToXMLFactory);
    }

    public List<File> dumpFiles() {
        ArrayList<File> files = new ArrayList<File>(this.dbPrefixes.length);
        for (String dbPrefix : this.dbPrefixes) {
            String fileNamePrefix = this.getFileNamePrefix(dbPrefix);
            File outputFile = TempFileProvider.createTempFile((String)fileNamePrefix, (String)fileNameSuffix, (File)this.directory);
            files.add(outputFile);
            DbToXML dbToXML = this.dbToXMLFactory.create(outputFile, dbPrefix);
            dbToXML.execute();
        }
        return files;
    }

    private String getFileNamePrefix(String dbPrefix) {
        MessageFormat formatter = new MessageFormat(this.fileNameTemplate);
        return formatter.format(new Object[]{dbPrefix});
    }

    public static class DbToXMLFactoryImpl
    implements DbToXMLFactory {
        private ApplicationContext ctx;

        public DbToXMLFactoryImpl(ApplicationContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public DbToXML create(File outputFile, String dbPrefix) {
            return new DbToXML(this.ctx, outputFile, dbPrefix);
        }
    }

    public static interface DbToXMLFactory {
        public DbToXML create(File var1, String var2);
    }
}

