/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FriendIdList {
    private final List<String> list;

    @JsonCreator
    public FriendIdList(@JsonProperty(value="data") @JsonDeserialize(using=IdDeserializer.class) List<String> list) {
        this.list = list;
    }

    public List<String> getList() {
        return this.list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdDeserializer
    extends JsonDeserializer<List<String>> {
        private IdDeserializer() {
        }

        public List<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = jp.readValueAsTree();
            ArrayList<String> idList = new ArrayList<String>(tree.size());
            for (JsonNode entryNode : tree) {
                if (!entryNode.has("id")) continue;
                idList.add(entryNode.get("id").getValueAsText());
            }
            return idList;
        }
    }
}

