/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.social.facebook.api.Account;
import org.springframework.social.facebook.api.FacebookLink;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.PageAdministrationException;
import org.springframework.social.facebook.api.PageOperations;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.AccountList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class PageTemplate
extends AbstractFacebookOperations
implements PageOperations {
    private final GraphApi graphApi;
    private Map<String, Account> accountCache = new HashMap<String, Account>();

    public PageTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    public Page getPage(String pageId) {
        return this.graphApi.fetchObject(pageId, Page.class);
    }

    public boolean isPageAdmin(String pageId) {
        this.requireAuthorization();
        return this.getAccount(pageId) != null;
    }

    public String post(String pageId, String message) {
        this.requireAuthorization();
        String pageAccessToken = this.getPageAccessToken(pageId);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"message", (Object)message);
        map.set((Object)"access_token", (Object)pageAccessToken);
        return this.graphApi.publish(pageId, "feed", (MultiValueMap<String, Object>)map);
    }

    public String post(String pageId, String message, FacebookLink link) {
        this.requireAuthorization();
        String pageAccessToken = this.getPageAccessToken(pageId);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.set((Object)"link", (Object)link.getLink());
        map.set((Object)"name", (Object)link.getName());
        map.set((Object)"caption", (Object)link.getCaption());
        map.set((Object)"description", (Object)link.getDescription());
        map.set((Object)"message", (Object)message);
        map.set((Object)"access_token", (Object)pageAccessToken);
        return this.graphApi.publish(pageId, "feed", (MultiValueMap<String, Object>)map);
    }

    public String postPhoto(String pageId, String albumId, Resource photo) {
        return this.postPhoto(pageId, albumId, photo, null);
    }

    public String postPhoto(String pageId, String albumId, Resource photo, String caption) {
        this.requireAuthorization();
        String pageAccessToken = this.getPageAccessToken(pageId);
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.set((Object)"source", (Object)photo);
        if (caption != null) {
            parts.set((Object)"message", (Object)caption);
        }
        parts.set((Object)"access_token", (Object)pageAccessToken);
        return this.graphApi.publish(albumId, "photos", (MultiValueMap<String, Object>)parts);
    }

    private String getPageAccessToken(String pageId) {
        Account account = this.getAccount(pageId);
        if (account == null) {
            throw new PageAdministrationException(pageId);
        }
        return account.getAccessToken();
    }

    private Account getAccount(String pageId) {
        if (!this.accountCache.containsKey(pageId)) {
            List<Account> accounts = this.graphApi.fetchConnections("me", "accounts", AccountList.class, new String[0]).getList();
            for (Account account : accounts) {
                this.accountCache.put(account.getId(), account);
            }
        }
        return this.accountCache.get(pageId);
    }
}

