/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl;

import java.util.List;
import org.springframework.social.facebook.api.FacebookProfile;
import org.springframework.social.facebook.api.GraphApi;
import org.springframework.social.facebook.api.ImageType;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.UserOperations;
import org.springframework.social.facebook.api.impl.AbstractFacebookOperations;
import org.springframework.social.facebook.api.impl.ReferenceList;
import org.springframework.social.facebook.api.impl.UserPermissionsList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UserTemplate
extends AbstractFacebookOperations
implements UserOperations {
    private final GraphApi graphApi;

    public UserTemplate(GraphApi graphApi, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.graphApi = graphApi;
    }

    @Override
    public FacebookProfile getUserProfile() {
        this.requireAuthorization();
        return this.getUserProfile("me");
    }

    @Override
    public FacebookProfile getUserProfile(String facebookId) {
        return this.graphApi.fetchObject(facebookId, FacebookProfile.class);
    }

    @Override
    public byte[] getUserProfileImage() {
        this.requireAuthorization();
        return this.getUserProfileImage("me", ImageType.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(String userId) {
        return this.getUserProfileImage(userId, ImageType.NORMAL);
    }

    @Override
    public byte[] getUserProfileImage(ImageType imageType) {
        this.requireAuthorization();
        return this.getUserProfileImage("me", imageType);
    }

    @Override
    public byte[] getUserProfileImage(String userId, ImageType imageType) {
        return this.graphApi.fetchImage(userId, "picture", imageType);
    }

    @Override
    public List<String> getUserPermissions() {
        this.requireAuthorization();
        return this.graphApi.fetchConnections("me", "permissions", UserPermissionsList.class, new String[0]).getList();
    }

    @Override
    public List<Reference> search(String query) {
        this.requireAuthorization();
        LinkedMultiValueMap queryMap = new LinkedMultiValueMap();
        queryMap.add((Object)"q", (Object)query);
        queryMap.add((Object)"type", (Object)"user");
        return this.graphApi.fetchObject("search", ReferenceList.class, (MultiValueMap<String, String>)queryMap).getList();
    }
}

