/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.BoxDataImpl;
import com.google.gdata.data.geo.impl.GeoRssBox;
import com.google.gdata.data.geo.impl.GeoRssPoint;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import com.google.gdata.data.geo.impl.GmlEnvelope;
import com.google.gdata.data.geo.impl.GmlPoint;
import com.google.gdata.data.geo.impl.PointDataImpl;
import com.google.gdata.data.geo.impl.W3CPoint;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.photos.AlbumData;
import com.google.gdata.data.photos.AlbumFeed;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.GphotoAccess;
import com.google.gdata.data.photos.GphotoBytesUsed;
import com.google.gdata.data.photos.GphotoCommentCount;
import com.google.gdata.data.photos.GphotoCommentsEnabled;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoLocation;
import com.google.gdata.data.photos.GphotoName;
import com.google.gdata.data.photos.GphotoNickname;
import com.google.gdata.data.photos.GphotoPhotosLeft;
import com.google.gdata.data.photos.GphotoPhotosUsed;
import com.google.gdata.data.photos.GphotoTimestamp;
import com.google.gdata.data.photos.GphotoUsername;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@Kind.Term(value="http://schemas.google.com/photos/2007#album")
public class AlbumEntry
extends GphotoEntry<AlbumEntry>
implements AtomData,
AlbumData {
    public static final String KIND = "http://schemas.google.com/photos/2007#album";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/photos/2007#album");

    public AlbumEntry() {
        this.getCategories().add(CATEGORY);
    }

    public AlbumEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(AlbumEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(AlbumEntry.class, GphotoAccess.class);
        extProfile.declare(AlbumEntry.class, GphotoBytesUsed.class);
        extProfile.declare(AlbumEntry.class, GphotoCommentCount.class);
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(GphotoCommentsEnabled.class, new XmlNamespace("gphoto", "http://schemas.google.com/photos/2007"), "commentingEnabled", false, false, false));
        extProfile.declare(AlbumEntry.class, GphotoTimestamp.class);
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(W3CPoint.class, new XmlNamespace("geo", "http://www.w3.org/2003/01/geo/wgs84_pos#"), "Point", false, false, false));
        new W3CPoint().declareExtensions(extProfile);
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(GeoRssBox.class, new XmlNamespace("georss", "http://www.georss.org/georss"), "box", false, false, false));
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(GeoRssPoint.class, new XmlNamespace("georss", "http://www.georss.org/georss"), "point", false, false, false));
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(GeoRssWhere.class, new XmlNamespace("georss", "http://www.georss.org/georss"), "where", false, false, false));
        new GeoRssWhere().declareExtensions(extProfile);
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(GmlEnvelope.class, new XmlNamespace("gml", "http://www.opengis.net/gml"), "Envelope", false, false, false));
        new GmlEnvelope().declareExtensions(extProfile);
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(GmlPoint.class, new XmlNamespace("gml", "http://www.opengis.net/gml"), "Point", false, false, false));
        new GmlPoint().declareExtensions(extProfile);
        extProfile.declare(AlbumEntry.class, GphotoLocation.class);
        extProfile.declare(AlbumEntry.class, new ExtensionDescription(MediaGroup.class, new XmlNamespace("media", "http://search.yahoo.com/mrss/"), "group", false, false, false));
        new MediaGroup().declareExtensions(extProfile);
        extProfile.declare(AlbumEntry.class, GphotoName.class);
        extProfile.declare(AlbumEntry.class, GphotoNickname.class);
        extProfile.declare(AlbumEntry.class, GphotoPhotosLeft.class);
        extProfile.declare(AlbumEntry.class, GphotoPhotosUsed.class);
        extProfile.declare(AlbumEntry.class, GphotoUsername.class);
    }

    public GphotoAccess getAccessExt() {
        return (GphotoAccess)this.getExtension(GphotoAccess.class);
    }

    public void setAccessExt(GphotoAccess accessExt) {
        if (accessExt == null) {
            this.removeExtension(GphotoAccess.class);
        } else {
            this.setExtension((Extension)accessExt);
        }
    }

    public boolean hasAccessExt() {
        return this.hasExtension(GphotoAccess.class);
    }

    public GphotoBytesUsed getBytesUsedExt() {
        return (GphotoBytesUsed)this.getExtension(GphotoBytesUsed.class);
    }

    public void setBytesUsedExt(GphotoBytesUsed bytesUsedExt) {
        if (bytesUsedExt == null) {
            this.removeExtension(GphotoBytesUsed.class);
        } else {
            this.setExtension((Extension)bytesUsedExt);
        }
    }

    public boolean hasBytesUsedExt() {
        return this.hasExtension(GphotoBytesUsed.class);
    }

    public GphotoCommentCount getCommentCountExt() {
        return (GphotoCommentCount)this.getExtension(GphotoCommentCount.class);
    }

    public void setCommentCountExt(GphotoCommentCount commentCountExt) {
        if (commentCountExt == null) {
            this.removeExtension(GphotoCommentCount.class);
        } else {
            this.setExtension((Extension)commentCountExt);
        }
    }

    public boolean hasCommentCountExt() {
        return this.hasExtension(GphotoCommentCount.class);
    }

    public GphotoCommentsEnabled getCommentsEnabledExt() {
        return (GphotoCommentsEnabled)this.getExtension(GphotoCommentsEnabled.class);
    }

    public void setCommentsEnabledExt(GphotoCommentsEnabled commentsEnabledExt) {
        if (commentsEnabledExt == null) {
            this.removeExtension(GphotoCommentsEnabled.class);
        } else {
            this.setExtension((Extension)commentsEnabledExt);
        }
    }

    public boolean hasCommentsEnabledExt() {
        return this.hasExtension(GphotoCommentsEnabled.class);
    }

    public GphotoTimestamp getDateExt() {
        return (GphotoTimestamp)this.getExtension(GphotoTimestamp.class);
    }

    public void setDateExt(GphotoTimestamp dateExt) {
        if (dateExt == null) {
            this.removeExtension(GphotoTimestamp.class);
        } else {
            this.setExtension((Extension)dateExt);
        }
    }

    public boolean hasDateExt() {
        return this.hasExtension(GphotoTimestamp.class);
    }

    public W3CPoint getGeoPoint() {
        return (W3CPoint)this.getExtension(W3CPoint.class);
    }

    public void setGeoPoint(W3CPoint geoPoint) {
        if (geoPoint == null) {
            this.removeExtension(W3CPoint.class);
        } else {
            this.setExtension((Extension)geoPoint);
        }
    }

    public boolean hasGeoPoint() {
        return this.hasExtension(W3CPoint.class);
    }

    public GeoRssBox getGeoRssBox() {
        return (GeoRssBox)this.getExtension(GeoRssBox.class);
    }

    public void setGeoRssBox(GeoRssBox geoRssBox) {
        if (geoRssBox == null) {
            this.removeExtension(GeoRssBox.class);
        } else {
            this.setExtension((Extension)geoRssBox);
        }
    }

    public boolean hasGeoRssBox() {
        return this.hasExtension(GeoRssBox.class);
    }

    public GeoRssPoint getGeoRssPoint() {
        return (GeoRssPoint)this.getExtension(GeoRssPoint.class);
    }

    public void setGeoRssPoint(GeoRssPoint geoRssPoint) {
        if (geoRssPoint == null) {
            this.removeExtension(GeoRssPoint.class);
        } else {
            this.setExtension((Extension)geoRssPoint);
        }
    }

    public boolean hasGeoRssPoint() {
        return this.hasExtension(GeoRssPoint.class);
    }

    public GeoRssWhere getGeoRssWhere() {
        return (GeoRssWhere)this.getExtension(GeoRssWhere.class);
    }

    public void setGeoRssWhere(GeoRssWhere geoRssWhere) {
        if (geoRssWhere == null) {
            this.removeExtension(GeoRssWhere.class);
        } else {
            this.setExtension((Extension)geoRssWhere);
        }
    }

    public boolean hasGeoRssWhere() {
        return this.hasExtension(GeoRssWhere.class);
    }

    public GmlEnvelope getGmlEnvelope() {
        return (GmlEnvelope)this.getExtension(GmlEnvelope.class);
    }

    public void setGmlEnvelope(GmlEnvelope gmlEnvelope) {
        if (gmlEnvelope == null) {
            this.removeExtension(GmlEnvelope.class);
        } else {
            this.setExtension((Extension)gmlEnvelope);
        }
    }

    public boolean hasGmlEnvelope() {
        return this.hasExtension(GmlEnvelope.class);
    }

    public GmlPoint getGmlPoint() {
        return (GmlPoint)this.getExtension(GmlPoint.class);
    }

    public void setGmlPoint(GmlPoint gmlPoint) {
        if (gmlPoint == null) {
            this.removeExtension(GmlPoint.class);
        } else {
            this.setExtension((Extension)gmlPoint);
        }
    }

    public boolean hasGmlPoint() {
        return this.hasExtension(GmlPoint.class);
    }

    public GphotoLocation getLocationExt() {
        return (GphotoLocation)this.getExtension(GphotoLocation.class);
    }

    public void setLocationExt(GphotoLocation locationExt) {
        if (locationExt == null) {
            this.removeExtension(GphotoLocation.class);
        } else {
            this.setExtension((Extension)locationExt);
        }
    }

    public boolean hasLocationExt() {
        return this.hasExtension(GphotoLocation.class);
    }

    @Override
    public MediaGroup getMediaGroup() {
        return (MediaGroup)this.getExtension(MediaGroup.class);
    }

    public void setMediaGroup(MediaGroup mediaGroup) {
        if (mediaGroup == null) {
            this.removeExtension(MediaGroup.class);
        } else {
            this.setExtension(mediaGroup);
        }
    }

    public boolean hasMediaGroup() {
        return this.hasExtension(MediaGroup.class);
    }

    public GphotoName getNameExt() {
        return (GphotoName)this.getExtension(GphotoName.class);
    }

    public void setNameExt(GphotoName nameExt) {
        if (nameExt == null) {
            this.removeExtension(GphotoName.class);
        } else {
            this.setExtension((Extension)nameExt);
        }
    }

    public boolean hasNameExt() {
        return this.hasExtension(GphotoName.class);
    }

    public GphotoNickname getNicknameExt() {
        return (GphotoNickname)this.getExtension(GphotoNickname.class);
    }

    public void setNicknameExt(GphotoNickname nicknameExt) {
        if (nicknameExt == null) {
            this.removeExtension(GphotoNickname.class);
        } else {
            this.setExtension((Extension)nicknameExt);
        }
    }

    public boolean hasNicknameExt() {
        return this.hasExtension(GphotoNickname.class);
    }

    public GphotoPhotosLeft getPhotosLeftExt() {
        return (GphotoPhotosLeft)this.getExtension(GphotoPhotosLeft.class);
    }

    public void setPhotosLeftExt(GphotoPhotosLeft photosLeftExt) {
        if (photosLeftExt == null) {
            this.removeExtension(GphotoPhotosLeft.class);
        } else {
            this.setExtension((Extension)photosLeftExt);
        }
    }

    public boolean hasPhotosLeftExt() {
        return this.hasExtension(GphotoPhotosLeft.class);
    }

    public GphotoPhotosUsed getPhotosUsedExt() {
        return (GphotoPhotosUsed)this.getExtension(GphotoPhotosUsed.class);
    }

    public void setPhotosUsedExt(GphotoPhotosUsed photosUsedExt) {
        if (photosUsedExt == null) {
            this.removeExtension(GphotoPhotosUsed.class);
        } else {
            this.setExtension((Extension)photosUsedExt);
        }
    }

    public boolean hasPhotosUsedExt() {
        return this.hasExtension(GphotoPhotosUsed.class);
    }

    public GphotoUsername getUsernameExt() {
        return (GphotoUsername)this.getExtension(GphotoUsername.class);
    }

    public void setUsernameExt(GphotoUsername usernameExt) {
        if (usernameExt == null) {
            this.removeExtension(GphotoUsername.class);
        } else {
            this.setExtension((Extension)usernameExt);
        }
    }

    public boolean hasUsernameExt() {
        return this.hasExtension(GphotoUsername.class);
    }

    protected void validate() {
    }

    public String toString() {
        return "{AlbumEntry " + super.toString() + "}";
    }

    public AlbumFeed getFeed(String ... kinds) throws IOException, ServiceException {
        return this.getFeed(AlbumFeed.class, kinds);
    }

    @Override
    public String getAccess() {
        GphotoAccess access = this.getAccessExt();
        return access == null ? null : access.getValue().toLowerCase();
    }

    @Override
    public Long getBytesUsed() {
        GphotoBytesUsed bytesUsed = this.getBytesUsedExt();
        return bytesUsed == null ? null : bytesUsed.getValue();
    }

    @Override
    public Integer getCommentCount() {
        GphotoCommentCount commentCount = this.getCommentCountExt();
        return commentCount == null ? null : commentCount.getValue();
    }

    @Override
    public Boolean getCommentsEnabled() {
        GphotoCommentsEnabled commentsEnabled = this.getCommentsEnabledExt();
        return commentsEnabled == null ? null : commentsEnabled.getValue();
    }

    @Override
    public Date getDate() {
        GphotoTimestamp date = this.getDateExt();
        if (date == null) {
            return null;
        }
        return new Date(date.getValue());
    }

    @Override
    public String getLocation() {
        GphotoLocation location = this.getLocationExt();
        return location == null ? null : location.getValue();
    }

    @Override
    public String getName() {
        GphotoName name = this.getNameExt();
        return name == null ? null : name.getValue();
    }

    @Override
    public String getNickname() {
        GphotoNickname nickname = this.getNicknameExt();
        return nickname == null ? null : nickname.getValue();
    }

    @Override
    public Integer getPhotosLeft() {
        GphotoPhotosLeft photosLeft = this.getPhotosLeftExt();
        return photosLeft == null ? null : photosLeft.getValue();
    }

    @Override
    public Integer getPhotosUsed() {
        GphotoPhotosUsed photosUsed = this.getPhotosUsedExt();
        return photosUsed == null ? null : photosUsed.getValue();
    }

    @Override
    public String getUsername() {
        GphotoUsername username = this.getUsernameExt();
        return username == null ? null : username.getValue();
    }

    @Override
    public void setAccess(String access) {
        GphotoAccess accessExt = null;
        if (access != null) {
            accessExt = new GphotoAccess(access);
        }
        this.setAccessExt(accessExt);
    }

    @Override
    public void setBytesUsed(Long bytesUsed) {
        GphotoBytesUsed usedExt = null;
        if (bytesUsed != null) {
            usedExt = new GphotoBytesUsed(bytesUsed);
        }
        this.setBytesUsedExt(usedExt);
    }

    @Override
    public void setCommentCount(Integer commentCount) {
        GphotoCommentCount countExt = null;
        if (commentCount != null) {
            countExt = new GphotoCommentCount(commentCount);
        }
        this.setCommentCountExt(countExt);
    }

    @Override
    public void setCommentsEnabled(Boolean commentsEnabled) {
        GphotoCommentsEnabled enabledExt = null;
        if (commentsEnabled != null) {
            enabledExt = new GphotoCommentsEnabled(commentsEnabled);
        }
        this.setCommentsEnabledExt(enabledExt);
    }

    @Override
    public void setDate(Date date) {
        GphotoTimestamp dateExt = null;
        if (date != null) {
            dateExt = new GphotoTimestamp(date);
        }
        this.setDateExt(dateExt);
    }

    @Override
    public void setLocation(String location) {
        GphotoLocation locExt = null;
        if (location != null) {
            locExt = new GphotoLocation(location);
        }
        this.setLocationExt(locExt);
    }

    @Override
    public void setName(String name) {
        GphotoName nameExt = null;
        if (name != null) {
            nameExt = new GphotoName(name);
        }
        this.setNameExt(nameExt);
    }

    @Override
    public void setNickname(String nickname) {
        GphotoNickname nicknameExt = null;
        if (nickname != null) {
            nicknameExt = new GphotoNickname(nickname);
        }
        this.setNicknameExt(nicknameExt);
    }

    @Override
    public void setPhotosLeft(Integer photosLeft) {
        GphotoPhotosLeft leftExt = null;
        if (photosLeft != null) {
            leftExt = new GphotoPhotosLeft(photosLeft);
        }
        this.setPhotosLeftExt(leftExt);
    }

    @Override
    public void setPhotosUsed(Integer photosUsed) {
        GphotoPhotosUsed usedExt = null;
        if (photosUsed != null) {
            usedExt = new GphotoPhotosUsed(photosUsed);
        }
        this.setPhotosUsedExt(usedExt);
    }

    @Override
    public void setUsername(String username) {
        GphotoUsername usernameExt = null;
        if (username != null) {
            usernameExt = new GphotoUsername(username);
        }
        this.setUsernameExt(usernameExt);
    }

    public Point getGeoLocation() {
        return PointDataImpl.getPoint((ExtensionPoint)this);
    }

    public void setGeoLocation(Double lat, Double lon) {
        this.setGeoLocation((Point)new GeoRssWhere(lat, lon));
    }

    public void setGeoLocation(Point point) {
        PointDataImpl.setPoint((ExtensionPoint)this, (Point)point);
    }

    public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
        this.setGeoBoundingBox((Box)new GeoRssWhere(lowerLeft, upperRight));
    }

    public void setGeoBoundingBox(Box boundingBox) {
        BoxDataImpl.setBox((ExtensionPoint)this, (Box)boundingBox);
    }

    public Box getGeoBoundingBox() {
        return BoxDataImpl.getBox((ExtensionPoint)this);
    }

    public void clearPoint() {
        PointDataImpl.clearPoint((ExtensionPoint)this);
    }

    public void clearGeoBoundingBox() {
        BoxDataImpl.clearBox((ExtensionPoint)this);
    }

    @Override
    public List<MediaCategory> getMediaCategories() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getCategories();
    }

    @Override
    public List<MediaContent> getMediaContents() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getContents();
    }

    @Override
    public List<MediaCredit> getMediaCredits() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getCredits();
    }

    @Override
    public MediaKeywords getMediaKeywords() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return null;
        }
        return group.getKeywords();
    }

    @Override
    public List<MediaThumbnail> getMediaThumbnails() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getThumbnails();
    }

    @Override
    public void setKeywords(MediaKeywords keywords) {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            group = new MediaGroup();
            this.setMediaGroup(group);
        }
        group.setKeywords(keywords);
    }
}

