/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.CommentAuthor;
import com.google.gdata.data.photos.CommentData;
import com.google.gdata.data.photos.GphotoAlbumId;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoPhotoId;

@Kind.Term(value="http://schemas.google.com/photos/2007#comment")
public class CommentEntry
extends GphotoEntry<CommentEntry>
implements AtomData,
CommentData {
    public static final String KIND = "http://schemas.google.com/photos/2007#comment";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/photos/2007#comment");

    public CommentEntry() {
        this.getCategories().add(CATEGORY);
    }

    public CommentEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(CommentEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(CommentEntry.class, GphotoAlbumId.class);
        extProfile.declare(CommentEntry.class, CommentAuthor.getDefaultDescription(false, true));
        new CommentAuthor().declareExtensions(extProfile);
        extProfile.declare(CommentEntry.class, GphotoPhotoId.class);
    }

    public GphotoAlbumId getAlbumIdExt() {
        return (GphotoAlbumId)this.getExtension(GphotoAlbumId.class);
    }

    public void setAlbumIdExt(GphotoAlbumId albumIdExt) {
        if (albumIdExt == null) {
            this.removeExtension(GphotoAlbumId.class);
        } else {
            this.setExtension((Extension)albumIdExt);
        }
    }

    public boolean hasAlbumIdExt() {
        return this.hasExtension(GphotoAlbumId.class);
    }

    public GphotoPhotoId getPhotoIdExt() {
        return (GphotoPhotoId)this.getExtension(GphotoPhotoId.class);
    }

    public void setPhotoIdExt(GphotoPhotoId photoIdExt) {
        if (photoIdExt == null) {
            this.removeExtension(GphotoPhotoId.class);
        } else {
            this.setExtension((Extension)photoIdExt);
        }
    }

    public boolean hasPhotoIdExt() {
        return this.hasExtension(GphotoPhotoId.class);
    }

    protected void validate() {
    }

    public String toString() {
        return "{CommentEntry " + super.toString() + "}";
    }

    @Override
    public String getAlbumId() {
        GphotoAlbumId ext = this.getAlbumIdExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getPhotoId() {
        GphotoPhotoId ext = this.getPhotoIdExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setAlbumId(Long albumId) {
        GphotoAlbumId ext = null;
        if (albumId != null) {
            ext = GphotoAlbumId.from(albumId);
        }
        this.setAlbumIdExt(ext);
    }

    @Override
    public void setAlbumId(String albumId) {
        GphotoAlbumId ext = null;
        if (albumId != null) {
            ext = new GphotoAlbumId(albumId);
        }
        this.setAlbumIdExt(ext);
    }

    @Override
    public void setPhotoId(Long photoId) {
        GphotoPhotoId ext = null;
        if (photoId != null) {
            ext = GphotoPhotoId.from(photoId);
        }
        this.setPhotoIdExt(ext);
    }

    @Override
    public void setPhotoId(String photoId) {
        GphotoPhotoId ext = null;
        if (photoId != null) {
            ext = new GphotoPhotoId(photoId);
        }
        this.setPhotoIdExt(ext);
    }
}

