/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.photos.Extensible;
import com.google.gdata.data.photos.Namespaces;
import com.google.gdata.data.photos.impl.ExifTag;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.xml.sax.Attributes;

public class ExifTags
extends ExtensionPoint
implements Extensible,
Extension {
    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(ExifTags.class, ExifTag.getDefaultDescription());
        extProfile.declareArbitraryXmlExtension(ExifTags.class);
        super.declareExtensions(extProfile);
    }

    public static ExtensionDescription getDefaultDescription() {
        return new ExtensionDescription(ExifTags.class, Namespaces.EXIF_NAMESPACE, "tags");
    }

    public Collection<ExifTag> getExifTags() {
        return this.getRepeatingExtension(ExifTag.class);
    }

    public ExifTag getExifTag(String exifName) {
        Collection<ExifTag> tags = this.getExifTags();
        for (ExifTag tag : tags) {
            if (!tag.getName().equals(exifName)) continue;
            return tag;
        }
        return null;
    }

    public String getExifTagValue(String exifName) {
        ExifTag tag = this.getExifTag(exifName);
        return tag == null ? null : tag.getValue();
    }

    public void setExifTagValue(String name, Number value) {
        if (value != null && value.floatValue() != 0.0f) {
            this.setExifTagValue(name, value.toString());
        } else {
            this.setExifTagValue(name, (String)null);
        }
    }

    public void setExifTagValue(String name, String value) {
        ExifTag tag = this.getExifTag(name);
        if (tag != null) {
            this.removeRepeatingExtension((Extension)tag);
        }
        if (value != null) {
            this.addRepeatingExtension((Extension)new ExifTag(name, value));
        }
    }

    public String getCameraMake() {
        return this.getExifTagValue("make");
    }

    public void setCameraMake(String make) {
        this.setExifTagValue("make", make);
    }

    public String getCameraModel() {
        return this.getExifTagValue("model");
    }

    public void setCameraModel(String model) {
        this.setExifTagValue("model", model);
    }

    public Integer getIsoEquivalent() throws ParseException {
        String iso = this.getExifTagValue("iso");
        if (iso == null) {
            return null;
        }
        try {
            return Integer.valueOf(iso);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid Iso field " + iso, (Throwable)nfe);
        }
    }

    public void setIsoEquivalent(Integer iso) {
        this.setExifTagValue("iso", iso);
    }

    public Float getExposureTime() throws ParseException {
        String exposure = this.getExifTagValue("exposure");
        if (exposure == null) {
            return null;
        }
        try {
            return Float.valueOf(exposure);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid exposure field " + exposure, (Throwable)nfe);
        }
    }

    public void setExposureTime(Float exposure) {
        this.setExifTagValue("exposure", exposure);
    }

    public Float getApetureFNumber() throws ParseException {
        String fstop = this.getExifTagValue("fstop");
        if (fstop == null) {
            return null;
        }
        try {
            return Float.valueOf(fstop);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid fstop field " + fstop, (Throwable)nfe);
        }
    }

    public void setApetureFNumber(Float fstop) {
        this.setExifTagValue("fstop", fstop);
    }

    public Float getDistance() throws ParseException {
        String distance = this.getExifTagValue("distance");
        if (distance == null) {
            return null;
        }
        try {
            return Float.valueOf(distance);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid distance field " + distance, (Throwable)nfe);
        }
    }

    public void setDistance(Float distance) {
        this.setExifTagValue("distance", distance);
    }

    public Date getTime() throws ParseException {
        String time = this.getExifTagValue("time");
        if (time == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(time));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid time field " + time, (Throwable)nfe);
        }
    }

    public void setTime(Date time) {
        this.setExifTagValue("time", time == null ? null : Long.toString(time.getTime()));
    }

    public Float getFocalLength() throws ParseException {
        String focalLength = this.getExifTagValue("focallength");
        if (focalLength == null) {
            return null;
        }
        try {
            return Float.valueOf(focalLength);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid focal length " + focalLength, (Throwable)nfe);
        }
    }

    public void setFocalLength(Float focalLength) {
        this.setExifTagValue("focallength", focalLength);
    }

    public Boolean getFlashUsed() {
        String flash = this.getExifTagValue("flash");
        return flash == null ? null : Boolean.valueOf(flash);
    }

    public void setFlashUsed(Boolean flash) {
        this.setExifTagValue("flash", flash == null ? null : flash.toString());
    }

    public String getImageUniqueID() {
        return this.getExifTagValue("imageUniqueID");
    }

    public void setImageUniqueID(String imageUniqueID) {
        this.setExifTagValue("imageUniqueID", imageUniqueID);
    }

    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        w.startElement(Namespaces.EXIF_NAMESPACE, "tags", null, null);
        Collection<ExifTag> fields = this.getExifTags();
        for (ExifTag field : fields) {
            field.generate(w, extProfile);
        }
        w.endElement();
    }

    public XmlParser.ElementHandler getHandler(final ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new XmlParser.ElementHandler(){

            public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
                if ("http://schemas.google.com/photos/exif/2007".equals(namespace)) {
                    ExifTag field = new ExifTag(localName);
                    ExifTags.this.addRepeatingExtension((Extension)field);
                    return field.getHandler(extProfile, namespace, localName, attrs);
                }
                return ExifTags.this.getExtensionHandler(extProfile, ExifTags.class, namespace, localName, attrs);
            }
        };
    }
}

