/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoMaxPhotos;
import com.google.gdata.data.photos.GphotoNickname;
import com.google.gdata.data.photos.GphotoQuotaLimit;
import com.google.gdata.data.photos.GphotoQuotaUsed;
import com.google.gdata.data.photos.GphotoThumbnail;
import com.google.gdata.data.photos.GphotoUsername;
import com.google.gdata.data.photos.UserData;
import com.google.gdata.data.photos.UserFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;

@Kind.Term(value="http://schemas.google.com/photos/2007#user")
public class UserEntry
extends GphotoEntry<UserEntry>
implements AtomData,
UserData {
    public static final String KIND = "http://schemas.google.com/photos/2007#user";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/photos/2007#user");

    public UserEntry() {
        this.getCategories().add(CATEGORY);
    }

    public UserEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(UserEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(UserEntry.class, GphotoMaxPhotos.class);
        extProfile.declare(UserEntry.class, GphotoNickname.class);
        extProfile.declare(UserEntry.class, GphotoQuotaLimit.class);
        extProfile.declare(UserEntry.class, GphotoQuotaUsed.class);
        extProfile.declare(UserEntry.class, GphotoThumbnail.class);
        extProfile.declare(UserEntry.class, GphotoUsername.class);
    }

    public GphotoMaxPhotos getMaxPhotosExt() {
        return (GphotoMaxPhotos)this.getExtension(GphotoMaxPhotos.class);
    }

    public void setMaxPhotosExt(GphotoMaxPhotos maxPhotosExt) {
        if (maxPhotosExt == null) {
            this.removeExtension(GphotoMaxPhotos.class);
        } else {
            this.setExtension((Extension)maxPhotosExt);
        }
    }

    public boolean hasMaxPhotosExt() {
        return this.hasExtension(GphotoMaxPhotos.class);
    }

    public GphotoNickname getNicknameExt() {
        return (GphotoNickname)this.getExtension(GphotoNickname.class);
    }

    public void setNicknameExt(GphotoNickname nicknameExt) {
        if (nicknameExt == null) {
            this.removeExtension(GphotoNickname.class);
        } else {
            this.setExtension((Extension)nicknameExt);
        }
    }

    public boolean hasNicknameExt() {
        return this.hasExtension(GphotoNickname.class);
    }

    public GphotoQuotaLimit getQuotaLimitExt() {
        return (GphotoQuotaLimit)this.getExtension(GphotoQuotaLimit.class);
    }

    public void setQuotaLimitExt(GphotoQuotaLimit quotaLimitExt) {
        if (quotaLimitExt == null) {
            this.removeExtension(GphotoQuotaLimit.class);
        } else {
            this.setExtension((Extension)quotaLimitExt);
        }
    }

    public boolean hasQuotaLimitExt() {
        return this.hasExtension(GphotoQuotaLimit.class);
    }

    public GphotoQuotaUsed getQuotaUsedExt() {
        return (GphotoQuotaUsed)this.getExtension(GphotoQuotaUsed.class);
    }

    public void setQuotaUsedExt(GphotoQuotaUsed quotaUsedExt) {
        if (quotaUsedExt == null) {
            this.removeExtension(GphotoQuotaUsed.class);
        } else {
            this.setExtension((Extension)quotaUsedExt);
        }
    }

    public boolean hasQuotaUsedExt() {
        return this.hasExtension(GphotoQuotaUsed.class);
    }

    public GphotoThumbnail getThumbnailExt() {
        return (GphotoThumbnail)this.getExtension(GphotoThumbnail.class);
    }

    public void setThumbnailExt(GphotoThumbnail thumbnailExt) {
        if (thumbnailExt == null) {
            this.removeExtension(GphotoThumbnail.class);
        } else {
            this.setExtension((Extension)thumbnailExt);
        }
    }

    public boolean hasThumbnailExt() {
        return this.hasExtension(GphotoThumbnail.class);
    }

    public GphotoUsername getUsernameExt() {
        return (GphotoUsername)this.getExtension(GphotoUsername.class);
    }

    public void setUsernameExt(GphotoUsername usernameExt) {
        if (usernameExt == null) {
            this.removeExtension(GphotoUsername.class);
        } else {
            this.setExtension((Extension)usernameExt);
        }
    }

    public boolean hasUsernameExt() {
        return this.hasExtension(GphotoUsername.class);
    }

    protected void validate() {
    }

    public String toString() {
        return "{UserEntry " + super.toString() + "}";
    }

    public UserFeed getFeed(String ... kinds) throws IOException, ServiceException {
        return this.getFeed(UserFeed.class, kinds);
    }

    @Override
    public Integer getMaxPhotos() {
        GphotoMaxPhotos ext = this.getMaxPhotosExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getNickname() {
        GphotoNickname ext = this.getNicknameExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Long getQuotaLimit() {
        GphotoQuotaLimit ext = this.getQuotaLimitExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Long getQuotaUsed() {
        GphotoQuotaUsed ext = this.getQuotaUsedExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getThumbnail() {
        GphotoThumbnail ext = this.getThumbnailExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getUsername() {
        GphotoUsername ext = this.getUsernameExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setMaxPhotos(Integer max) {
        GphotoMaxPhotos ext = null;
        if (max != null) {
            ext = new GphotoMaxPhotos(max);
        }
        this.setMaxPhotosExt(ext);
    }

    @Override
    public void setNickname(String nickname) {
        GphotoNickname ext = null;
        if (nickname != null) {
            ext = new GphotoNickname(nickname);
        }
        this.setNicknameExt(ext);
    }

    @Override
    public void setQuotaLimit(Long quota) {
        GphotoQuotaLimit ext = null;
        if (quota != null) {
            ext = new GphotoQuotaLimit(quota);
        }
        this.setQuotaLimitExt(ext);
    }

    @Override
    public void setQuotaUsed(Long quota) {
        GphotoQuotaUsed ext = null;
        if (quota != null) {
            ext = new GphotoQuotaUsed(quota);
        }
        this.setQuotaUsedExt(ext);
    }

    @Override
    public void setThumbnail(String thumbnail) {
        GphotoThumbnail ext = null;
        if (thumbnail != null) {
            ext = new GphotoThumbnail(thumbnail);
        }
        this.setThumbnailExt(ext);
    }

    @Override
    public void setUsername(String username) {
        GphotoUsername ext = null;
        if (username != null) {
            ext = new GphotoUsername(username);
        }
        this.setUsernameExt(ext);
    }
}

