/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos.impl;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Person;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.photos.GphotoData;
import com.google.gdata.data.photos.GphotoId;
import com.google.gdata.data.photos.GphotoNickname;
import com.google.gdata.data.photos.GphotoThumbnail;
import com.google.gdata.data.photos.GphotoType;
import com.google.gdata.data.photos.GphotoUsername;
import java.util.List;

public class GphotoDataImpl
implements GphotoData {
    private final ExtensionPoint extPoint;
    private final Class<? extends ExtensionPoint> extClass;

    public GphotoDataImpl(ExtensionPoint extensionPoint) {
        this.extPoint = extensionPoint;
        this.extClass = extensionPoint.getClass();
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        this.declare(extProfile, GphotoId.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoType.getDefaultDescription(false, false));
        extProfile.declareArbitraryXmlExtension(this.extClass);
        extProfile.declare(Person.class, GphotoUsername.getDefaultDescription(false, false));
        extProfile.declare(Person.class, GphotoNickname.getDefaultDescription(false, false));
        extProfile.declare(Person.class, GphotoThumbnail.getDefaultDescription(false, false));
    }

    protected void declare(ExtensionProfile extProfile, ExtensionDescription description) {
        extProfile.declare(this.extClass, description);
        if (BaseEntry.class.isAssignableFrom(this.extClass)) {
            extProfile.declare(BaseEntry.class, description);
        }
    }

    @Override
    public String getGphotoId() {
        return this.getSimpleValue(GphotoId.class);
    }

    @Override
    public void setGphotoId(Long id) {
        if (id != null) {
            this.setExtension((Extension)GphotoId.from(id));
        } else {
            this.removeExtension(GphotoId.class);
        }
    }

    @Override
    public void setGphotoId(String id) {
        if (id != null) {
            this.setExtension((Extension)new GphotoId(id));
        } else {
            this.removeExtension(GphotoId.class);
        }
    }

    protected String getSimpleValue(Class<? extends ValueConstruct> extClass) {
        ValueConstruct construct = this.getExtension(extClass);
        return construct == null ? null : construct.getValue();
    }

    protected <T extends Extension> T getExtension(Class<T> extClass) {
        return (T)this.extPoint.getExtension(extClass);
    }

    protected <T extends Extension> List<T> getRepeatingExtension(Class<T> extClass) {
        return this.extPoint.getRepeatingExtension(extClass);
    }

    @Override
    public void setExtension(Extension extension) {
        this.extPoint.setExtension(extension);
    }

    @Override
    public void addExtension(Extension extension) {
        this.extPoint.addExtension(extension);
    }

    @Override
    public void addRepeatingExtension(Extension extension) {
        this.extPoint.addRepeatingExtension(extension);
    }

    @Override
    public void removeExtension(Class<? extends Extension> extensionClass) {
        this.extPoint.removeExtension(extensionClass);
    }

    @Override
    public void removeExtension(Extension extension) {
        this.extPoint.removeExtension(extension);
    }

    @Override
    public void removeRepeatingExtension(Extension ext) {
        this.extPoint.removeRepeatingExtension(ext);
    }
}

