/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.config.Config;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.core.Member;
import com.hazelcast.impl.AbstractJoiner;
import com.hazelcast.impl.AddressPicker;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.SplitBrainHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.AddressUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIpJoiner
extends AbstractJoiner {
    volatile boolean approved = true;
    final AtomicInteger responseCounter = new AtomicInteger();
    volatile boolean askingForApproval = false;

    public TcpIpJoiner(Node node) {
        super(node);
    }

    private void joinViaRequiredMember(AtomicBoolean joined) {
        try {
            Address requiredAddress = this.getAddressFor(this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember());
            this.logger.log(Level.FINEST, "Joining over required member " + requiredAddress);
            if (requiredAddress == null) {
                throw new RuntimeException("Invalid required member " + this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember());
            }
            if (requiredAddress.equals(this.node.address)) {
                this.node.setAsMaster();
                return;
            }
            this.node.connectionManager.getOrConnect(requiredAddress);
            Connection conn = null;
            while (conn == null) {
                conn = this.node.connectionManager.getOrConnect(requiredAddress);
                Thread.sleep(2000L);
            }
            while (!joined.get()) {
                Connection connection = this.node.connectionManager.getOrConnect(requiredAddress);
                if (connection == null) {
                    this.joinViaRequiredMember(joined);
                }
                this.logger.log(Level.FINEST, "Sending joinRequest " + requiredAddress);
                this.node.clusterManager.sendJoinRequest(requiredAddress);
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void joinViaPossibleMembers(AtomicBoolean joined) {
        try {
            this.node.getFailedConnections().clear();
            Collection<Address> colPossibleAddresses = this.getPossibleMembers(this.config, this.node.address, this.logger);
            colPossibleAddresses.remove(this.node.address);
            for (Address possibleAddress : colPossibleAddresses) {
                this.logger.log(Level.INFO, "connecting to " + possibleAddress);
                this.node.connectionManager.getOrConnect(possibleAddress);
            }
            boolean foundConnection = false;
            int numberOfSeconds = 0;
            int connectionTimeoutSeconds = this.config.getNetworkConfig().getJoin().getTcpIpConfig().getConnectionTimeoutSeconds();
            while (!foundConnection && numberOfSeconds < connectionTimeoutSeconds) {
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) break;
                Thread.sleep(1000L);
                ++numberOfSeconds;
                this.logger.log(Level.FINEST, "we are going to try to connect to each address");
                for (Address possibleAddress : colPossibleAddresses) {
                    Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
                    if (conn == null) continue;
                    foundConnection = true;
                    this.logger.log(Level.FINEST, "found and sending join request for " + possibleAddress);
                    this.node.clusterManager.sendJoinRequest(possibleAddress);
                }
            }
            this.logger.log(Level.FINEST, "FOUND " + foundConnection);
            if (!foundConnection) {
                this.logger.log(Level.FINEST, "This node will assume master role since no possible member where connected to");
                this.node.setAsMaster();
            } else if (!this.node.joined()) {
                if (connectionTimeoutSeconds - numberOfSeconds > 0) {
                    this.logger.log(Level.FINEST, "Sleeping for " + (connectionTimeoutSeconds - numberOfSeconds) + " seconds.");
                    Thread.sleep((long)(connectionTimeoutSeconds - numberOfSeconds) * 1000L);
                }
                colPossibleAddresses.removeAll(this.node.getFailedConnections());
                if (colPossibleAddresses.size() == 0) {
                    this.logger.log(Level.FINEST, "This node will assume master role since all possible members didn't accept join request");
                    this.node.setAsMaster();
                } else {
                    boolean masterCandidate = true;
                    for (Address address : colPossibleAddresses) {
                        if (this.node.connectionManager.getConnection(address) == null || this.node.address.hashCode() <= address.hashCode()) continue;
                        masterCandidate = false;
                    }
                    if (masterCandidate) {
                        this.askingForApproval = true;
                        for (Address address : colPossibleAddresses) {
                            Connection conn = this.node.getConnectionManager().getConnection(address);
                            if (conn == null) continue;
                            this.responseCounter.incrementAndGet();
                            this.node.clusterManager.sendProcessableTo((RemotelyProcessable)new MasterQuestion(), conn);
                        }
                        int waitCount = 0;
                        while (waitCount++ < 10) {
                            Thread.sleep(1000L);
                            if (this.responseCounter.get() != 0) continue;
                            if (this.approved) {
                                this.logger.log(Level.FINEST, this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " possible addresses " + colPossibleAddresses.size() + "" + colPossibleAddresses);
                                this.node.setAsMaster();
                                return;
                            }
                            this.lookForMaster(colPossibleAddresses);
                            break;
                        }
                    } else {
                        this.lookForMaster(colPossibleAddresses);
                    }
                }
            }
            colPossibleAddresses.clear();
            this.node.getFailedConnections().clear();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private void lookForMaster(Collection<Address> colPossibleAddresses) throws InterruptedException {
        int tryCount = 0;
        while (!this.node.joined() && tryCount++ < 20 && this.node.getMasterAddress() == null) {
            this.connectAndSendJoinRequest(colPossibleAddresses);
            Thread.sleep(1000L);
        }
        int requestCount = 0;
        colPossibleAddresses.removeAll(this.node.getFailedConnections());
        if (colPossibleAddresses.size() == 0) {
            this.node.setAsMaster();
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " Setting myself as master! group " + this.node.getConfig().getGroupConfig().getName() + " no possible addresses without failed connection");
            return;
        }
        this.logger.log(Level.FINEST, this.node.getThisAddress() + " joining to master " + this.node.getMasterAddress() + ", group " + this.node.getConfig().getGroupConfig().getName());
        while (!this.node.joined()) {
            Thread.sleep(1000L);
            Address master = this.node.getMasterAddress();
            if (master != null) {
                this.node.clusterManager.sendJoinRequest(master);
                if (requestCount++ <= this.node.getGroupProperties().MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger() + 10) continue;
                this.logger.log(Level.WARNING, "Couldn't join to the master : " + master);
                return;
            }
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " couldn't find a master! but there was connections available: " + colPossibleAddresses);
            return;
        }
    }

    private Address getAddressFor(String host) {
        int port = this.config.getPort();
        int indexColon = host.indexOf(58);
        if (indexColon != -1) {
            port = Integer.parseInt(host.substring(indexColon + 1));
            host = host.substring(0, indexColon);
        }
        boolean ip = this.isIP(host);
        try {
            InetAddress[] allAddresses;
            if (ip) {
                return new Address(host, port, true);
            }
            for (InetAddress inetAddress : allAddresses = InetAddress.getAllByName(host)) {
                boolean shouldCheck = true;
                Interfaces interfaces = this.config.getNetworkConfig().getInterfaces();
                if (interfaces.isEnabled()) {
                    Address address = new Address(inetAddress.getAddress(), port);
                    shouldCheck = AddressPicker.matchAddress(address.getHost(), interfaces.getInterfaces());
                }
                if (!shouldCheck) continue;
                return new Address(inetAddress.getAddress(), port);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void doJoin(AtomicBoolean joined) {
        if (this.config.getNetworkConfig().getJoin().getTcpIpConfig().getRequiredMember() != null) {
            this.joinViaRequiredMember(joined);
        } else {
            this.joinViaPossibleMembers(joined);
        }
    }

    private List<Address> getPossibleIpAddresses(String host, int port, boolean portSet) throws UnknownHostException {
        ArrayList<Address> list;
        if (portSet) {
            list = Collections.singletonList(new Address(host, port, true));
        } else {
            list = new ArrayList(3);
            for (int i = 0; i < 3; ++i) {
                list.add(new Address(host, port + i, true));
            }
        }
        return list;
    }

    boolean isIP(String address) {
        if (address.indexOf(46) == -1) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(address, ".");
        int tokenCount = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            ++tokenCount;
            try {
                Integer.parseInt(token);
            }
            catch (Exception e) {
                return false;
            }
        }
        return tokenCount == 4;
    }

    Collection<Address> getPossibleMembers(Config config, Address thisAddress, ILogger logger) {
        HashSet<String> lsJoinMembers = new HashSet<String>();
        List<String> members = this.getMembers(config);
        for (String member : members) {
            lsJoinMembers.addAll(AddressUtil.handleMember(member));
        }
        HashSet<Address> setPossibleAddresses = new HashSet<Address>();
        for (String lsJoinMember : lsJoinMembers) {
            try {
                InetAddress[] allAddresses;
                boolean ip;
                String host = lsJoinMember;
                int port = config.getPort();
                int indexColon = host.indexOf(58);
                if (indexColon >= 0) {
                    port = Integer.parseInt(host.substring(indexColon + 1));
                    host = host.substring(0, indexColon);
                }
                if (ip = this.isIP(host)) {
                    for (Address addrs : this.getPossibleIpAddresses(host, port, indexColon >= 0 || !config.isPortAutoIncrement())) {
                        if (addrs.equals(thisAddress)) continue;
                        setPossibleAddresses.add(addrs);
                    }
                    continue;
                }
                for (InetAddress inetAddress : allAddresses = InetAddress.getAllByName(host)) {
                    if (inetAddress instanceof Inet6Address) {
                        logger.log(Level.FINEST, "This address [" + inetAddress + "] is not usable. " + "Hazelcast does not have support for IPv6 at the moment.");
                        continue;
                    }
                    boolean shouldCheck = true;
                    Interfaces interfaces = config.getNetworkConfig().getInterfaces();
                    if (interfaces.isEnabled()) {
                        Address addrs = new Address(inetAddress.getAddress(), port);
                        shouldCheck = AddressPicker.matchAddress(addrs.getHost(), interfaces.getInterfaces());
                    }
                    if (indexColon < 0) {
                        if (!shouldCheck) continue;
                        if (config.isPortAutoIncrement()) {
                            for (int i = 0; i < 3; ++i) {
                                Address addressProper = new Address(inetAddress.getAddress(), port + i);
                                if (addressProper.equals(thisAddress)) continue;
                                setPossibleAddresses.add(addressProper);
                            }
                            continue;
                        }
                        Address addressProper = new Address(inetAddress.getAddress(), port);
                        if (addressProper.equals(thisAddress)) continue;
                        setPossibleAddresses.add(addressProper);
                        continue;
                    }
                    Address addressProper = new Address(inetAddress.getAddress(), port);
                    if (addressProper.equals(thisAddress)) continue;
                    setPossibleAddresses.add(addressProper);
                }
            }
            catch (UnknownHostException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        setPossibleAddresses.addAll(config.getNetworkConfig().getJoin().getTcpIpConfig().getAddresses());
        return setPossibleAddresses;
    }

    protected List<String> getMembers(Config config) {
        Join join = config.getNetworkConfig().getJoin();
        return join.getTcpIpConfig().getMembers();
    }

    @Override
    public void searchForOtherClusters(SplitBrainHandler splitBrainHandler) {
        Collection<Address> colPossibleAddresses;
        try {
            colPossibleAddresses = this.getPossibleMembers(this.node.getConfig(), this.node.getThisAddress(), this.logger);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        colPossibleAddresses.remove(this.node.getThisAddress());
        for (Member member : this.node.getClusterImpl().getMembers()) {
            colPossibleAddresses.remove(((MemberImpl)member).getAddress());
        }
        if (colPossibleAddresses.size() == 0) {
            return;
        }
        for (Address possibleAddress : colPossibleAddresses) {
            this.logger.log(Level.FINEST, this.node.getThisAddress() + " is connecting to " + possibleAddress);
            this.node.connectionManager.getOrConnect(possibleAddress);
        }
        for (Address possibleAddress : colPossibleAddresses) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
            Connection conn = this.node.connectionManager.getOrConnect(possibleAddress);
            if (conn == null) continue;
            JoinInfo response = this.node.clusterManager.checkJoin(conn);
            if (this.shouldMerge(response)) {
                this.logger.log(Level.WARNING, this.node.address + " is merging [tcp/ip] to " + possibleAddress);
                splitBrainHandler.restart();
            }
            return;
        }
    }

    public static class MasterAnswer
    extends AbstractRemotelyProcessable {
        Address respondingAddress = null;
        boolean approved = false;

        public MasterAnswer(Address respondingAddress, boolean approved) {
            this.respondingAddress = respondingAddress;
            this.approved = approved;
        }

        public MasterAnswer() {
        }

        public void process() {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)this.getNode().getJoiner();
            if (!this.approved) {
                tcpIpJoiner.approved = false;
            }
            tcpIpJoiner.responseCounter.decrementAndGet();
        }

        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            out.writeBoolean(this.approved);
            this.respondingAddress.writeData(out);
        }

        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.approved = in.readBoolean();
            this.respondingAddress = new Address();
            this.respondingAddress.readData(in);
        }
    }

    public static class MasterQuestion
    extends AbstractRemotelyProcessable {
        public void process() {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)this.getNode().getJoiner();
            boolean shouldApprove = !tcpIpJoiner.askingForApproval && !this.node.isMaster();
            this.getNode().clusterManager.sendProcessableTo((RemotelyProcessable)new MasterAnswer(this.node.getThisAddress(), shouldApprove), this.getConnection());
        }
    }
}

