/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingBuilder;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.ITypeBinding;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.ObjectStringConversion;
import org.jibx.binding.def.PrimitiveStringConversion;
import org.jibx.binding.def.StringConversion;
import org.jibx.binding.util.ArrayMap;
import org.jibx.binding.util.IntegerCache;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.runtime.impl.GrowableStringArray;

public class BindingDefinition
extends BindingBuilder.ContainerBase
implements IContainer {
    static final QName OBJECT_DEFAULT_NAME = new QName("Object.default");
    public static final int BASE_USER_NAMESPACE = 3;
    public static final String CURRENT_VERSION_NAME = "jibx_1_2_3_SNAPSHOT";
    static final String DEFAULT_AUTOPREFIX = "id_";
    private static final int TYPEMAP_MINIMUM_SIZE = 5;
    private static ArrayList s_bindings;
    private static ArrayMap s_mappedClasses;
    private static final StringConversion s_byteConversion;
    private static final StringConversion s_charConversion;
    private static final StringConversion s_doubleConversion;
    private static final StringConversion s_floatConversion;
    private static final StringConversion s_intConversion;
    private static final StringConversion s_longConversion;
    private static final StringConversion s_shortConversion;
    private static final StringConversion s_booleanConversion;
    private static final StringConversion s_dateConversion;
    private static final StringConversion s_sqlDateConversion;
    private static final StringConversion s_sqlTimeConversion;
    private static final StringConversion s_timestampConversion;
    private static final StringConversion s_jodaLocalDateConversion;
    private static final StringConversion s_jodaZonedDateMidnightConversion;
    private static final StringConversion s_jodaLocalUnzonedDateMidnightConversion;
    private static final StringConversion s_jodaUTCDateMidnightConversion;
    private static final StringConversion s_jodaUnzonedLocalTimeConversion;
    private static final StringConversion s_jodaUnzonedUTCLocalTimeConversion;
    private static final StringConversion s_jodaZonedDateTimeConversion;
    private static final StringConversion s_jodaUTCDateTimeConversion;
    private static final StringConversion s_jodaLocalDateTimeConversion;
    private static final StringConversion s_jodaStrictLocalDateTimeConversion;
    private static final StringConversion s_jodaStrictUTCDateTimeConversion;
    private static final StringConversion s_java5DecimalConversion;
    private static final StringConversion s_base64Conversion;
    private static final StringConversion s_wrappedBooleanConversion;
    private static final StringConversion s_qnameConversion;
    static final StringConversion s_stringConversion;
    private static final StringConversion s_objectConversion;
    private static final String FACTORY_SUFFIX = "Factory";
    private static final String FACTORY_INTERFACE = "org.jibx.runtime.IBindingFactory";
    private static final String FACTORY_BASE = "org.jibx.runtime.impl.BindingFactoryBase";
    private static final String[] FACTORY_INTERFACES;
    private static final String FACTORY_INSTNAME = "m_inst";
    private static final int PRIVATESTATIC_ACCESS = 10;
    private static final int PRIVATESTATICFINAL_ACCESS = 26;
    private static final String TYPEMAP_NAME = "m_typeMap";
    private static final String GETINST_METHODNAME = "getInstance";
    private static final String GETVERSION_METHODNAME = "getCompilerVersion";
    private static final String GETDISTRIB_METHODNAME = "getCompilerDistribution";
    private static final String GETTYPEINDEX_METHODNAME = "getTypeIndex";
    private static final String STRINGINT_MAPTYPE = "org.jibx.runtime.impl.StringIntHashMap";
    private static final String STRINGINTINIT_SIGNATURE = "(I)V";
    private static final String STRINGINTADD_METHOD = "org.jibx.runtime.impl.StringIntHashMap.add";
    private static final String STRINGINTADD_SIGNATURE = "(Ljava/lang/String;I)I";
    private static final String STRINGINTGET_METHOD = "org.jibx.runtime.impl.StringIntHashMap.get";
    private static final String STRINGINTGET_SIGNATURE = "(Ljava/lang/String;)I";
    private static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    private static final String CLASSLIST_METHOD_NAME = "getClassList";
    private static final String CLASSLIST_METHOD_SIGNATURE = "()Ljava/lang/String;";
    private final String m_name;
    private final int m_index;
    private final boolean m_isInput;
    private final boolean m_isOutput;
    private final boolean m_isIdGlobal;
    private final boolean m_isForwards;
    private final boolean m_isTrackSource;
    private final boolean m_isForceClasses;
    private final int m_majorVersion;
    private final int m_minorVersion;
    private boolean m_isAddConstructors;
    private String m_targetPackage;
    private File m_targetRoot;
    private String m_factoryName;
    private ArrayMap m_uniqueIds;
    private ArrayMap m_namespaceUris;
    private GrowableStringArray m_namespacePrefixes;
    private int m_highBasePrefix;
    private DefinitionContext m_outerContext;
    private DefinitionContext m_activeContext;
    private boolean m_isMappedDone;
    private boolean m_isSchemaInstanceUsed;
    private int m_mumIndex;
    private ArrayMap m_extraClasses;
    private GrowableStringArray m_extraMarshallers;
    private GrowableStringArray m_extraUnmarshallers;
    private GrowableStringArray m_baseBindings;
    private GrowableStringArray m_baseBindingFactories;
    private ArrayList m_baseHashes;
    private ArrayList m_baseNamespaceTables;
    private GrowableStringArray m_closureFactories;
    private ArrayList m_closureNamespaceTables;
    private ClassFile m_factoryClass;
    private static byte[] s_blanks;

    public BindingDefinition(String name, boolean ibind, boolean obind, String tpack, boolean glob, boolean forward, boolean source, boolean force, boolean add, boolean trim, int major, int minor) throws JiBXException {
        super(null);
        this.m_name = name;
        this.m_isInput = ibind;
        this.m_isOutput = obind;
        this.m_targetPackage = tpack;
        this.m_isIdGlobal = glob;
        this.m_isForwards = forward;
        this.m_isTrackSource = source;
        this.m_isForceClasses = force;
        this.m_isAddConstructors = add;
        this.m_majorVersion = major;
        this.m_minorVersion = minor;
        this.m_baseBindings = new GrowableStringArray();
        this.m_baseBindingFactories = new GrowableStringArray();
        this.m_baseHashes = new ArrayList();
        this.m_baseNamespaceTables = new ArrayList();
        this.m_closureFactories = new GrowableStringArray();
        this.m_closureNamespaceTables = new ArrayList();
        this.m_styleDefault = 1;
        this.m_autoLink = 1;
        this.m_accessLevel = 0;
        this.m_nameStyle = 0;
        this.m_outerContext = this.m_activeContext = new DefinitionContext(this);
        this.m_activeContext = new DefinitionContext(this);
        this.m_namespaceUris = new ArrayMap();
        this.m_namespaceUris.findOrAdd("");
        this.m_namespacePrefixes = new GrowableStringArray();
        this.m_namespacePrefixes.add("");
        this.m_outerContext.addNamespace(NamespaceDefinition.buildNamespace("http://www.w3.org/XML/1998/namespace", "xml"));
        this.getNamespaceUriIndex("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        String conv = trim ? "org.jibx.runtime.WhitespaceConversions.trim" : null;
        this.m_outerContext.setDefaultConversion(new QName("byte.default"), s_byteConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("char.default"), s_charConversion.derive(null, null, conv, null, null));
        StringConversion schar = s_charConversion.derive("char", "org.jibx.runtime.Utility.serializeCharString", null, "org.jibx.runtime.Utility.parseCharString", null);
        this.m_outerContext.setNamedConversion(new QName("char.string"), schar);
        this.m_outerContext.setDefaultConversion(new QName("double.default"), s_doubleConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("float.default"), s_floatConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("int.default"), s_intConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("long.default"), s_longConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("short.default"), s_shortConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("boolean.default"), s_booleanConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("Date.default"), s_dateConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("SqlDate.default"), s_sqlDateConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("SqlTime.default"), s_sqlTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("Timestamp.default"), s_timestampConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("LocalDate.default"), s_jodaLocalDateConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("DateMidnight.zoned"), s_jodaZonedDateMidnightConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("DateMidnight.local"), s_jodaLocalUnzonedDateMidnightConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("DateMidnight.UTC"), s_jodaUTCDateMidnightConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("LocalTime.local"), s_jodaUnzonedLocalTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("LocalTime.UTC"), s_jodaUnzonedUTCLocalTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("DateTime.zoned"), s_jodaZonedDateTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("DateTime.UTC"), s_jodaUTCDateTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("DateTime.local"), s_jodaLocalDateTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("DateTime.strict-local"), s_jodaStrictLocalDateTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setNamedConversion(new QName("DateTime.strict-UTC"), s_jodaStrictUTCDateTimeConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("BigDecimal.java5"), s_java5DecimalConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("byte-array.default"), s_base64Conversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("Boolean.default"), s_wrappedBooleanConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("QName.default"), s_qnameConversion.derive(null, null, conv, null, null));
        this.m_outerContext.setDefaultConversion(new QName("String.default"), s_stringConversion);
        this.m_outerContext.setDefaultConversion(OBJECT_DEFAULT_NAME, s_objectConversion.derive(null, null, conv, null, null));
        this.m_index = s_bindings.size();
        s_bindings.add(this);
    }

    public BoundClass getBoundClass() {
        return null;
    }

    public int getStyleDefault() {
        return this.m_styleDefault;
    }

    public boolean setIdChild(IComponent child) {
        throw new IllegalStateException("Internal error - setIdChild for root");
    }

    public String getDefaultPackage() {
        return this.m_targetPackage;
    }

    public File getDefaultRoot() {
        return this.m_targetRoot;
    }

    public void setFactoryLocation(String tpack, File root) {
        this.m_targetPackage = tpack;
        this.m_targetRoot = root;
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean isInput() {
        return this.m_isInput;
    }

    public boolean isOutput() {
        return this.m_isOutput;
    }

    public boolean isIdGlobal() {
        return this.m_isIdGlobal;
    }

    public boolean isForwards() {
        return this.m_isForwards;
    }

    public boolean isTrackSource() {
        return this.m_isTrackSource;
    }

    public boolean isAddConstructors() {
        return this.m_isAddConstructors;
    }

    public String getPrefix() {
        return "JiBX_" + this.m_name;
    }

    public void addMappingName(String name) {
        if (this.m_isMappedDone) {
            throw new IllegalStateException("Internal error: Call out of sequence");
        }
        s_mappedClasses.findOrAdd(name);
    }

    public String getMarshallerUnmarshallerName(String clas) {
        if (!this.m_isMappedDone) {
            this.m_isMappedDone = true;
            this.m_mumIndex = s_mappedClasses.size();
            if (this.m_extraClasses == null) {
                this.m_extraClasses = new ArrayMap();
                this.m_extraMarshallers = new GrowableStringArray();
                this.m_extraUnmarshallers = new GrowableStringArray();
            }
        }
        int variant = 0;
        String name = clas;
        while (this.m_extraClasses.find(name = clas + '-' + variant++) >= 0) {
        }
        this.m_extraClasses.findOrAdd(name);
        this.m_extraMarshallers.add(null);
        this.m_extraUnmarshallers.add(null);
        return name;
    }

    public void setMarshallerUnmarshallerClasses(String name, String mclas, String uclas) {
        int index = this.m_extraClasses.find(name);
        this.m_extraMarshallers.set(index, mclas);
        this.m_extraUnmarshallers.set(index, uclas);
    }

    public int getIdClassIndex(String name) {
        if (this.m_isIdGlobal) {
            return 0;
        }
        if (this.m_uniqueIds == null) {
            this.m_uniqueIds = new ArrayMap();
        }
        return this.m_uniqueIds.findOrAdd(name);
    }

    public int getNamespaceUriIndex(String uri, String prefix) {
        int size;
        int index = this.m_namespaceUris.findOrAdd(uri);
        if (index == (size = this.m_namespacePrefixes.size())) {
            this.m_namespacePrefixes.add(prefix);
        } else if (index > size) {
            throw new IllegalStateException("Internal error - prefixes not matched with namespaces");
        }
        return index;
    }

    public void setSchemaInstanceUsed() {
        this.m_isSchemaInstanceUsed = true;
    }

    public int[] addPrecompiledBinding(IBindingFactory factory, int major, int minor) {
        this.m_baseBindings.add(factory.getBindingName());
        this.m_baseBindingFactories.add(factory.getClass().getName());
        this.m_baseHashes.add(new Integer(factory.getHash()));
        String[] namespaces = factory.getNamespaces();
        String[] prefixes = factory.getPrefixes();
        int[] indexes = new int[namespaces.length];
        boolean xlate = false;
        for (int i = 1; i < namespaces.length; ++i) {
            int index;
            indexes[i] = index = this.getNamespaceUriIndex(namespaces[i], prefixes[i]);
            if (i == index) continue;
            xlate = true;
        }
        this.m_highBasePrefix = this.m_namespacePrefixes.size();
        if (xlate) {
            this.m_baseNamespaceTables.add(indexes);
            String[] basefacts = factory.getBaseBindingFactories();
            Map basemap = factory.getNamespaceTranslationTableMap();
            for (int i = 0; i < basefacts.length; ++i) {
                String factname = basefacts[i];
                int[] basetable = (int[])basemap.get(factname);
                if (basetable == null) continue;
                int[] baseindexes = new int[basetable.length];
                for (int j = 0; j < basetable.length; ++j) {
                    baseindexes[j] = indexes[basetable[j]];
                }
                this.m_closureFactories.add(factname);
                this.m_closureNamespaceTables.add(baseindexes);
            }
            return indexes;
        }
        this.m_baseNamespaceTables.add(null);
        return null;
    }

    private void fixPrefixes() {
        if (this.m_highBasePrefix > 0) {
            HashSet<String> prefset = new HashSet<String>();
            prefset.add("");
            for (int i = this.m_highBasePrefix; i < this.m_namespacePrefixes.size(); ++i) {
                prefset.add(this.m_namespacePrefixes.get(i));
            }
            int genindex = 0;
            for (int i = 3; i < this.m_highBasePrefix; ++i) {
                String prefix = this.m_namespacePrefixes.get(i);
                while (prefset.contains(prefix)) {
                    StringBuffer buff = new StringBuffer();
                    buff.append((char)(97 + genindex++ % 26));
                    for (int remain = genindex / 26; remain > 0; remain /= 36) {
                        int next = remain % 36;
                        if (next < 10) {
                            buff.append((char)(48 + next));
                            continue;
                        }
                        buff.append((char)(97 + next));
                    }
                    prefix = buff.toString();
                }
                prefset.add(prefix);
                this.m_namespacePrefixes.set(i, prefix);
            }
        }
    }

    public String getPrefix(String uri) {
        int index = this.m_namespaceUris.find(uri);
        if (index >= 0) {
            return this.m_namespacePrefixes.get(index);
        }
        throw new IllegalStateException("Internal error - URI not registered");
    }

    private static String buildClassNamesBlob(String[] names) {
        StringBuffer buff = new StringBuffer();
        String last = "";
        for (int i = 0; i < names.length; ++i) {
            char chr;
            String name;
            if (i > 0) {
                buff.append('|');
            }
            if ((name = names[i]) == null) continue;
            int base = 0;
            int limit = Math.min(last.length(), name.length());
            int scan = -1;
            while (++scan < limit && (chr = last.charAt(scan)) == name.charAt(scan)) {
                if (chr == '.') {
                    buff.append('.');
                    base = scan + 1;
                    continue;
                }
                if (chr != '$') continue;
                buff.append('$');
                base = scan + 1;
            }
            if (scan < limit || scan == limit && last.length() != name.length()) {
                buff.append(name.substring(base));
            }
            last = name;
        }
        return buff.toString();
    }

    private static String buildClassNamesBlob(List names) {
        String[] strings = names.toArray(new String[names.size()]);
        return BindingDefinition.buildClassNamesBlob(strings);
    }

    private static String buildNamespaceIndexBlob(String[] uris, String[] nss) {
        HashMap<String, Integer> indexmap = new HashMap<String, Integer>();
        for (int i = 0; i < uris.length; ++i) {
            indexmap.put(uris[i], IntegerCache.getInteger(i + 2));
        }
        StringBuffer buff = new StringBuffer(nss.length);
        for (int i = 0; i < nss.length; ++i) {
            String uri = nss[i];
            if (uri == null) {
                buff.append('\u0001');
                continue;
            }
            buff.append((char)((Integer)indexmap.get(uri)).intValue());
        }
        return buff.toString();
    }

    private static String buildNamesBlob(String[] names) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                buff.append('|');
            }
            if (names[i] == null) continue;
            buff.append(names[i]);
        }
        return buff.toString();
    }

    private static String buildIntsBlob(int[] ints) {
        char[] chars = new char[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            int value = ints[i];
            if (value < 0 || value >= 65535) {
                throw new IllegalArgumentException("Internal error - only 16-bit values supported at present");
            }
            chars[i] = (char)(value + 1);
        }
        return new String(chars);
    }

    private static String buildIntsBlob(List values) {
        int[] ints = new int[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            ints[i] = (Integer)values.get(i);
        }
        return BindingDefinition.buildIntsBlob(ints);
    }

    private static void codegenString(String string, MethodBuilder mb) {
        if (string.length() < Short.MAX_VALUE) {
            mb.appendLoadConstant(string);
        } else {
            mb.appendCreateNew("java.lang.StringBuffer");
            mb.appendDUP();
            mb.appendLoadConstant(string.length());
            mb.appendCallInit("java.lang.StringBuffer", STRINGINTINIT_SIGNATURE);
            int base = 0;
            while (base < string.length()) {
                int end = Math.min(base + Short.MAX_VALUE, string.length());
                mb.appendLoadConstant(string.substring(base, end));
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                base = end;
            }
            mb.appendCallVirtual("java.lang.StringBuffer.toString", CLASSLIST_METHOD_SIGNATURE);
        }
    }

    public String getFactoryName() {
        return this.m_factoryName;
    }

    public void generateCode(boolean verbose1, boolean verbose2) throws JiBXException {
        int i;
        int i2;
        int i3;
        IMapping map;
        String cname;
        int i4;
        if (this.m_isSchemaInstanceUsed) {
            NamespaceDefinition xsins = NamespaceDefinition.buildNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            ArrayList mappings = this.m_activeContext.getMappings();
            for (int i5 = 0; i5 < mappings.size(); ++i5) {
                Object mapping = mappings.get(i5);
                if (!(mapping instanceof MappingDefinition)) continue;
                ((MappingDefinition)mapping).addNamespace(xsins);
            }
        }
        this.m_factoryName = this.m_targetPackage.length() == 0 ? this.getPrefix() + FACTORY_SUFFIX : this.m_targetPackage + '.' + this.getPrefix() + FACTORY_SUFFIX;
        BoundClass.setModify(this.m_targetRoot, this.m_targetPackage, this.m_name);
        this.fixPrefixes();
        this.m_activeContext.linkMappings();
        this.m_activeContext.setLinkages();
        this.m_activeContext.generateCode(verbose1, this.m_isForceClasses);
        if (verbose2) {
            System.out.println("After linking view of binding " + this.m_name + ':');
            this.print();
        }
        ClassFile base = ClassCache.requireClassFile(FACTORY_BASE);
        ClassFile cf = new ClassFile(this.m_factoryName, this.m_targetRoot, base, 1, FACTORY_INTERFACES);
        ClassItem inst = cf.addField(FACTORY_INTERFACE, FACTORY_INSTNAME, 10);
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder(CLASSLIST_METHOD_NAME, (Type)Type.STRING, new Type[0], cf, 10);
        mb.appendACONST_NULL();
        mb.appendReturn((Type)Type.STRING);
        mb.codeComplete(false);
        ClassItem clasblobmeth = mb.addMethod();
        mb = new ExceptionMethodBuilder("<init>", (Type)Type.VOID, new Type[0], cf, 2);
        mb.appendLoadLocal(0);
        mb.appendLoadConstant(this.m_name);
        mb.appendLoadConstant(this.m_majorVersion);
        mb.appendLoadConstant(this.m_minorVersion);
        mb.appendCall(clasblobmeth);
        int count = s_mappedClasses.size();
        int mcnt = this.m_extraClasses == null ? count : count + this.m_extraClasses.size();
        String[] names = new String[mcnt];
        for (i4 = 0; i4 < count; ++i4) {
            names[i4] = (String)s_mappedClasses.get(i4);
        }
        for (i4 = count; i4 < mcnt; ++i4) {
            names[i4] = (String)this.m_extraClasses.get(i4 - count);
        }
        BindingDefinition.codegenString(BindingDefinition.buildClassNamesBlob(names), mb);
        if (this.m_isInput) {
            for (i4 = 0; i4 < count; ++i4) {
                cname = (String)s_mappedClasses.get(i4);
                map = this.m_activeContext.getMappingAtLevel(cname);
                names[i4] = map != null && map.getUnmarshaller() != null ? map.getUnmarshaller().getName() : null;
            }
            for (i4 = count; i4 < mcnt; ++i4) {
                names[i4] = this.m_extraUnmarshallers.get(i4 - count);
            }
            BindingDefinition.codegenString(BindingDefinition.buildClassNamesBlob(names), mb);
        } else {
            mb.appendACONST_NULL();
        }
        if (this.m_isOutput) {
            for (i4 = 0; i4 < count; ++i4) {
                cname = (String)s_mappedClasses.get(i4);
                map = this.m_activeContext.getMappingAtLevel(cname);
                names[i4] = map != null && map.getMarshaller() != null ? map.getMarshaller().getName() : null;
            }
            for (i4 = count; i4 < mcnt; ++i4) {
                names[i4] = this.m_extraMarshallers.get(i4 - count);
            }
            BindingDefinition.codegenString(BindingDefinition.buildClassNamesBlob(names), mb);
        } else {
            mb.appendACONST_NULL();
        }
        String[] nsuris = new String[this.m_namespaceUris.size()];
        mb.appendLoadConstant(this.m_namespaceUris.size());
        mb.appendCreateArray("java.lang.String");
        for (i3 = 0; i3 < this.m_namespaceUris.size(); ++i3) {
            mb.appendDUP();
            mb.appendLoadConstant(i3);
            String uri = (String)this.m_namespaceUris.get(i3);
            mb.appendLoadConstant(uri);
            mb.appendAASTORE();
            nsuris[i3] = uri;
        }
        if (this.m_isOutput) {
            mb.appendLoadConstant(this.m_namespacePrefixes.size());
            mb.appendCreateArray("java.lang.String");
            for (i3 = 0; i3 < this.m_namespacePrefixes.size(); ++i3) {
                mb.appendDUP();
                mb.appendLoadConstant(i3);
                mb.appendLoadConstant(this.m_namespacePrefixes.get(i3));
                mb.appendAASTORE();
            }
        } else {
            mb.appendACONST_NULL();
        }
        names = new String[count];
        String[] namespaces = new String[count];
        for (i2 = 0; i2 < count; ++i2) {
            NameDefinition ndef;
            String cname2 = (String)s_mappedClasses.get(i2);
            IMapping map2 = this.m_activeContext.getMappingAtLevel(cname2);
            if (map2 == null || (ndef = map2.getName()) == null) continue;
            names[i2] = ndef.getName();
            namespaces[i2] = ndef.getNamespace();
        }
        BindingDefinition.codegenString(BindingDefinition.buildNamesBlob(names), mb);
        mb.appendLoadConstant(BindingDefinition.buildNamespaceIndexBlob(nsuris, namespaces));
        if (this.m_uniqueIds != null && this.m_uniqueIds.size() > 0) {
            mb.appendLoadConstant(this.m_uniqueIds.size());
            mb.appendCreateArray("java.lang.String");
            for (i2 = 0; i2 < this.m_uniqueIds.size(); ++i2) {
                mb.appendDUP();
                mb.appendLoadConstant(i2);
                mb.appendLoadConstant((String)this.m_uniqueIds.get(i2));
                mb.appendAASTORE();
            }
        } else {
            mb.appendACONST_NULL();
        }
        GrowableStringArray allnames = new GrowableStringArray();
        int abmapcnt = 0;
        StringBuffer buff = new StringBuffer();
        for (int i6 = 0; i6 < count; ++i6) {
            String tname = (String)s_mappedClasses.get(i6);
            IMapping map3 = this.m_activeContext.getMappingAtLevel(tname);
            if (map3 == null || !map3.isAbstract()) continue;
            ITypeBinding bind = map3.getBinding();
            allnames.add(tname);
            allnames.add(map3.getBoundType());
            allnames.add(bind.getCreateMethod());
            allnames.add(bind.getCompleteMethod());
            allnames.add(bind.getPrepareMethod());
            allnames.add(bind.getAttributePresentTestMethod());
            allnames.add(bind.getAttributeUnmarshalMethod());
            allnames.add(bind.getAttributeMarshalMethod());
            allnames.add(bind.getContentPresentTestMethod());
            allnames.add(bind.getContentUnmarshalMethod());
            allnames.add(bind.getContentMarshalMethod());
            ++abmapcnt;
            ArrayList nss = map3.getNamespaces();
            if (nss == null) {
                buff.append('\u0001');
                continue;
            }
            buff.append((char)(nss.size() + 1));
            for (int j = 0; j < nss.size(); ++j) {
                NamespaceDefinition nsdef = (NamespaceDefinition)nss.get(j);
                buff.append((char)(nsdef.getIndex() + 1));
            }
        }
        BindingDefinition.codegenString(BindingDefinition.buildClassNamesBlob(allnames.toArray()), mb);
        BindingDefinition.codegenString(buff.toString(), mb);
        int basecount = this.m_baseBindings.size();
        BindingDefinition.codegenString(BindingDefinition.buildNamesBlob(this.m_baseBindings.toArray()), mb);
        String namesblob = BindingDefinition.buildClassNamesBlob(this.m_baseBindingFactories.toArray());
        if (this.m_closureFactories.size() > 0) {
            namesblob = namesblob + "|" + BindingDefinition.buildClassNamesBlob(this.m_closureFactories.toArray());
        }
        BindingDefinition.codegenString(namesblob, mb);
        char[] hashchars = new char[basecount * 2];
        for (i = 0; i < basecount; ++i) {
            int hash = (Integer)this.m_baseHashes.get(i);
            hashchars[i * 2] = (char)(hash >> 16);
            hashchars[i * 2 + 1] = (char)hash;
        }
        BindingDefinition.codegenString(new String(hashchars), mb);
        mb.appendLoadConstant(basecount + this.m_closureNamespaceTables.size());
        mb.appendCreateArray("java.lang.String");
        for (i = 0; i < basecount; ++i) {
            int[] table = (int[])this.m_baseNamespaceTables.get(i);
            if (table == null) continue;
            mb.appendDUP();
            mb.appendLoadConstant(i);
            mb.appendLoadConstant(BindingDefinition.buildIntsBlob(table));
            mb.appendAASTORE();
        }
        for (i = 0; i < this.m_closureNamespaceTables.size(); ++i) {
            int[] table = (int[])this.m_closureNamespaceTables.get(i);
            mb.appendDUP();
            mb.appendLoadConstant(i + basecount);
            mb.appendLoadConstant(BindingDefinition.buildIntsBlob(table));
            mb.appendAASTORE();
        }
        mb.appendCallInit(FACTORY_BASE, "(Ljava/lang/String;IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V");
        GrowableStringArray tnames = new GrowableStringArray();
        if (this.m_isForceClasses) {
            for (int i7 = 0; i7 < count; ++i7) {
                String cname3 = (String)s_mappedClasses.get(i7);
                IMapping map4 = this.m_activeContext.getMappingAtLevel(cname3);
                if (map4 == null || !map4.isAbstract() || map4.isBase()) continue;
                String tname = map4.getTypeName();
                if (tname == null) {
                    tname = cname3;
                }
                tnames.add(tname);
            }
        }
        ClassItem tmap = null;
        if (tnames.size() >= 5) {
            tmap = cf.addPrivateField(STRINGINT_MAPTYPE, TYPEMAP_NAME);
            mb.appendLoadLocal(0);
            mb.appendCreateNew(STRINGINT_MAPTYPE);
            mb.appendDUP();
            mb.appendLoadConstant(tnames.size());
            mb.appendCallInit(STRINGINT_MAPTYPE, STRINGINTINIT_SIGNATURE);
            for (int i8 = 0; i8 < tnames.size(); ++i8) {
                int index = s_mappedClasses.find(tnames.get(i8));
                if (index < 0) continue;
                mb.appendDUP();
                mb.appendLoadConstant(tnames.get(i8));
                mb.appendLoadConstant(index);
                mb.appendCallVirtual(STRINGINTADD_METHOD, STRINGINTADD_SIGNATURE);
                mb.appendPOP();
            }
            mb.appendPutField(tmap);
        }
        mb.appendReturn();
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETVERSION_METHODNAME, (Type)Type.INT, new Type[0], cf, 1);
        mb.appendLoadConstant(196608);
        mb.appendReturn("int");
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETDISTRIB_METHODNAME, (Type)Type.STRING, new Type[0], cf, 1);
        mb.appendLoadConstant(CURRENT_VERSION_NAME);
        mb.appendReturn((Type)Type.STRING);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETTYPEINDEX_METHODNAME, (Type)Type.INT, new Type[]{Type.STRING}, cf, 1);
        if (tnames.size() > 0) {
            if (tmap == null) {
                for (int i9 = 0; i9 < tnames.size(); ++i9) {
                    int index = s_mappedClasses.find(tnames.get(i9));
                    if (index < 0) continue;
                    mb.appendLoadLocal(1);
                    mb.appendLoadConstant(tnames.get(i9));
                    mb.appendCallVirtual("java.lang.String.equals", "(Ljava/lang/Object;)Z");
                    BranchWrapper onfail = mb.appendIFEQ(this);
                    mb.appendLoadConstant(index);
                    mb.appendReturn((Type)Type.INT);
                    mb.targetNext(onfail);
                }
                mb.appendLoadConstant(-1);
            } else {
                mb.appendLoadLocal(0);
                mb.appendGetField(tmap);
                mb.appendLoadLocal(1);
                mb.appendCallVirtual(STRINGINTGET_METHOD, STRINGINTGET_SIGNATURE);
            }
        } else {
            mb.appendLoadConstant(-1);
        }
        mb.appendReturn((Type)Type.INT);
        mb.codeComplete(false);
        mb.addMethod();
        mb = new ExceptionMethodBuilder(GETINST_METHODNAME, ClassItem.typeFromName(FACTORY_INTERFACE), new Type[0], cf, 9);
        mb.appendGetStatic(inst);
        BranchWrapper ifdone = mb.appendIFNONNULL(this);
        mb.appendCreateNew(cf.getName());
        mb.appendDUP();
        mb.appendCallInit(cf.getName(), "()V");
        mb.appendPutStatic(inst);
        mb.targetNext(ifdone);
        mb.appendGetStatic(inst);
        mb.appendReturn(FACTORY_INTERFACE);
        mb.codeComplete(false);
        mb.addMethod();
        cf.codeComplete();
        MungedClass.addModifiedClass(cf);
        this.m_factoryClass = cf;
        ArrayList maps = this.m_activeContext.getMappings();
        if (maps != null) {
            for (int i10 = 0; i10 < maps.size(); ++i10) {
                BoundClass bound;
                IMapping map5 = (IMapping)maps.get(i10);
                if (!(map5 instanceof MappingBase) || !(bound = ((MappingBase)map5).getBoundClass()).getClassFile().isModifiable()) continue;
                bound.addFactory(this.m_factoryName);
            }
        }
    }

    public void generateCode(boolean verbose) throws JiBXException {
        this.generateCode(verbose, false);
    }

    public void addClassList(ClassFile[] adds, ClassFile[] keeps) {
        int i;
        TreeSet<String> tree = new TreeSet<String>();
        int addcount = adds.length;
        for (i = 0; i < addcount; ++i) {
            tree.add(adds[i].getName());
        }
        for (i = 0; i < keeps.length; ++i) {
            tree.add(keeps[i].getName());
        }
        String[] refs = tree.toArray(new String[tree.size()]);
        this.m_factoryClass.deleteMethod(CLASSLIST_METHOD_NAME, CLASSLIST_METHOD_SIGNATURE);
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder(CLASSLIST_METHOD_NAME, (Type)Type.STRING, new Type[0], this.m_factoryClass, 10);
        BindingDefinition.codegenString(BindingDefinition.buildClassNamesBlob(refs), mb);
        mb.appendReturn((Type)Type.STRING);
        mb.codeComplete(false);
        mb.addMethod();
        this.m_factoryClass.codeComplete();
    }

    private static String methodNameOrNull(ClassItem item) {
        String method = item == null ? null : item.getName();
        return method;
    }

    public static BindingDefinition getBinding(int index) {
        return (BindingDefinition)s_bindings.get(index);
    }

    public static void reset() {
        s_bindings = new ArrayList();
        s_mappedClasses = new ArrayMap();
    }

    public boolean isContentOrdered() {
        return true;
    }

    public boolean hasNamespaces() {
        return false;
    }

    public BindingDefinition getBindingRoot() {
        return this;
    }

    public DefinitionContext getDefinitionContext() {
        return this.m_activeContext;
    }

    public static void indent(int depth) {
        if (depth < s_blanks.length) {
            System.out.write(s_blanks, 0, depth);
        } else {
            System.out.print(s_blanks);
        }
    }

    public void print() {
        System.out.println("binding " + this.m_name + ":");
        this.m_activeContext.print(1);
    }

    static {
        s_byteConversion = new PrimitiveStringConversion(Byte.TYPE, new Byte(0), "B", "serializeByte", "parseByte", "attributeByte", "parseElementByte");
        s_charConversion = new PrimitiveStringConversion(Character.TYPE, new Character('\u0000'), "C", "serializeChar", "parseChar", "attributeChar", "parseElementChar");
        s_doubleConversion = new PrimitiveStringConversion(Double.TYPE, new Double(0.0), "D", "serializeDouble", "parseDouble", "attributeDouble", "parseElementDouble");
        s_floatConversion = new PrimitiveStringConversion(Float.TYPE, new Float(0.0f), "F", "serializeFloat", "parseFloat", "attributeFloat", "parseElementFloat");
        s_intConversion = new PrimitiveStringConversion(Integer.TYPE, new Integer(0), "I", "serializeInt", "parseInt", "attributeInt", "parseElementInt");
        s_longConversion = new PrimitiveStringConversion(Long.TYPE, new Long(0L), "J", "serializeLong", "parseLong", "attributeLong", "parseElementLong");
        s_shortConversion = new PrimitiveStringConversion(Short.TYPE, new Short(0), "S", "serializeShort", "parseShort", "attributeShort", "parseElementShort");
        s_booleanConversion = new PrimitiveStringConversion(Boolean.TYPE, Boolean.FALSE, "Z", "serializeBoolean", "parseBoolean", "attributeBoolean", "parseElementBoolean");
        s_dateConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeDateTime", "org.jibx.runtime.Utility.deserializeDateTime", "java.util.Date");
        s_sqlDateConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeSqlDate", "org.jibx.runtime.Utility.deserializeSqlDate", "java.sql.Date");
        s_sqlTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeSqlTime", "org.jibx.runtime.Utility.deserializeSqlTime", "java.sql.Time");
        s_timestampConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeTimestamp", "org.jibx.runtime.Utility.deserializeTimestamp", "java.sql.Timestamp");
        s_jodaLocalDateConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeLocalDate", "org.jibx.runtime.JodaConvert.deserializeLocalDate", "org.joda.time.LocalDate");
        s_jodaZonedDateMidnightConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeZonedDateMidnight", "org.jibx.runtime.JodaConvert.deserializeZonedDateMidnight", "org.joda.time.DateMidnight");
        s_jodaLocalUnzonedDateMidnightConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeUnzonedDateMidnight", "org.jibx.runtime.JodaConvert.deserializeLocalDateMidnight", "org.joda.time.DateMidnight");
        s_jodaUTCDateMidnightConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeUTCDateMidnight", "org.jibx.runtime.JodaConvert.deserializeUTCDateMidnight", "org.joda.time.DateMidnight");
        s_jodaUnzonedLocalTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeUnzonedLocalTime", "org.jibx.runtime.JodaConvert.deserializeLocalTime", "org.joda.time.LocalTime");
        s_jodaUnzonedUTCLocalTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeUTCLocalTime", "org.jibx.runtime.JodaConvert.deserializeLocalTime", "org.joda.time.LocalTime");
        s_jodaZonedDateTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeZonedDateTime", "org.jibx.runtime.JodaConvert.deserializeZonedDateTime", "org.joda.time.DateTime");
        s_jodaUTCDateTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeUTCDateTime", "org.jibx.runtime.JodaConvert.deserializeUTCDateTime", "org.joda.time.DateTime");
        s_jodaLocalDateTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeZonedDateTime", "org.jibx.runtime.JodaConvert.deserializeLocalDateTime", "org.joda.time.DateTime");
        s_jodaStrictLocalDateTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeZonedDateTime", "org.jibx.runtime.JodaConvert.deserializeStrictLocalDateTime", "org.joda.time.DateTime");
        s_jodaStrictUTCDateTimeConversion = new ObjectStringConversion(null, "org.jibx.runtime.JodaConvert.serializeUTCDateTime", "org.jibx.runtime.JodaConvert.deserializeStrictUTCDateTime", "org.joda.time.DateTime");
        s_java5DecimalConversion = new ObjectStringConversion(null, "org.jibx.runtime.Java5DecimalConvert.serializeDecimal", null, "java.math.BigDecimal");
        s_base64Conversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeBase64", "org.jibx.runtime.Utility.deserializeBase64", "byte[]");
        s_wrappedBooleanConversion = new ObjectStringConversion(null, "org.jibx.runtime.Utility.serializeBoolean", "org.jibx.runtime.Utility.deserializeBoolean", "java.lang.Boolean");
        s_qnameConversion = new ObjectStringConversion(null, "org.jibx.runtime.QName.serialize", "org.jibx.runtime.QName.deserialize", "org.jibx.runtime.QName");
        s_stringConversion = new ObjectStringConversion(null, null, null, "java.lang.String");
        s_objectConversion = new ObjectStringConversion(null, null, null, "java.lang.Object");
        FACTORY_INTERFACES = new String[]{FACTORY_INTERFACE};
        s_blanks = "                                                   ".getBytes();
    }
}

