/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.sites;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.batch.BatchId;
import com.google.gdata.data.batch.BatchInterrupted;
import com.google.gdata.data.batch.BatchOperation;
import com.google.gdata.data.batch.BatchStatus;
import com.google.gdata.data.dublincore.Publisher;
import com.google.gdata.data.extensions.Deleted;
import com.google.gdata.data.media.MediaEntry;
import com.google.gdata.data.sites.Revision;
import com.google.gdata.data.sites.SitesLink;
import com.google.gdata.util.common.xml.XmlNamespace;

public abstract class BaseContentEntry<E extends BaseContentEntry<E>>
extends MediaEntry<E> {
    public BaseContentEntry() {
    }

    public BaseContentEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(BaseContentEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(BaseContentEntry.class, new ExtensionDescription(BatchId.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "id", false, false, false));
        extProfile.declare(BaseContentEntry.class, new ExtensionDescription(BatchInterrupted.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "interrupted", false, false, false));
        extProfile.declare(BaseContentEntry.class, new ExtensionDescription(BatchOperation.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "operation", false, false, false));
        extProfile.declare(BaseContentEntry.class, new ExtensionDescription(BatchStatus.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "status", false, false, false));
        extProfile.declare(BaseContentEntry.class, new ExtensionDescription(Deleted.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "deleted", false, false, false));
        extProfile.declare(BaseContentEntry.class, SitesLink.getDefaultDescription(true, true));
        extProfile.declare(BaseContentEntry.class, Publisher.class);
        extProfile.declare(BaseContentEntry.class, Revision.class);
    }

    public BatchId getBatchId() {
        return (BatchId)this.getExtension(BatchId.class);
    }

    public void setBatchId(BatchId batchId) {
        if (batchId == null) {
            this.removeExtension(BatchId.class);
        } else {
            this.setExtension((Extension)batchId);
        }
    }

    public boolean hasBatchId() {
        return this.hasExtension(BatchId.class);
    }

    public BatchInterrupted getBatchInterrupted() {
        return (BatchInterrupted)this.getExtension(BatchInterrupted.class);
    }

    public void setBatchInterrupted(BatchInterrupted batchInterrupted) {
        if (batchInterrupted == null) {
            this.removeExtension(BatchInterrupted.class);
        } else {
            this.setExtension((Extension)batchInterrupted);
        }
    }

    public boolean hasBatchInterrupted() {
        return this.hasExtension(BatchInterrupted.class);
    }

    public BatchOperation getBatchOperation() {
        return (BatchOperation)this.getExtension(BatchOperation.class);
    }

    public void setBatchOperation(BatchOperation batchOperation) {
        if (batchOperation == null) {
            this.removeExtension(BatchOperation.class);
        } else {
            this.setExtension((Extension)batchOperation);
        }
    }

    public boolean hasBatchOperation() {
        return this.hasExtension(BatchOperation.class);
    }

    public BatchStatus getBatchStatus() {
        return (BatchStatus)this.getExtension(BatchStatus.class);
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        if (batchStatus == null) {
            this.removeExtension(BatchStatus.class);
        } else {
            this.setExtension((Extension)batchStatus);
        }
    }

    public boolean hasBatchStatus() {
        return this.hasExtension(BatchStatus.class);
    }

    public Deleted getDeleted() {
        return (Deleted)this.getExtension(Deleted.class);
    }

    public void setDeleted(Deleted deleted) {
        if (deleted == null) {
            this.removeExtension(Deleted.class);
        } else {
            this.setExtension((Extension)deleted);
        }
    }

    public boolean hasDeleted() {
        return this.hasExtension(Deleted.class);
    }

    public Publisher getPublisher() {
        return (Publisher)this.getExtension(Publisher.class);
    }

    public void setPublisher(Publisher publisher) {
        if (publisher == null) {
            this.removeExtension(Publisher.class);
        } else {
            this.setExtension((Extension)publisher);
        }
    }

    public boolean hasPublisher() {
        return this.hasExtension(Publisher.class);
    }

    public Revision getRevision() {
        return (Revision)this.getExtension(Revision.class);
    }

    public void setRevision(Revision revision) {
        if (revision == null) {
            this.removeExtension(Revision.class);
        } else {
            this.setExtension((Extension)revision);
        }
    }

    public boolean hasRevision() {
        return this.hasExtension(Revision.class);
    }

    public Link getEntryPostLink() {
        return this.getLink("http://schemas.google.com/g/2005#post", ILink.Type.ATOM);
    }

    public Link getRevisionLink() {
        return this.getLink("http://schemas.google.com/sites/2008#revision", ILink.Type.ATOM);
    }

    protected void validate() {
    }

    public String toString() {
        return "{BaseContentEntry " + super.toString() + "}";
    }
}

