/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.sites;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.sites.SiteName;
import com.google.gdata.data.sites.SitesLink;
import com.google.gdata.data.sites.Theme;
import java.util.List;

public class SiteEntry
extends BaseEntry<SiteEntry> {
    public SiteEntry() {
    }

    public SiteEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(SiteEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(SiteEntry.class, SitesLink.getDefaultDescription(true, true));
        extProfile.declare(SiteEntry.class, SiteName.class);
        extProfile.declare(SiteEntry.class, Theme.class);
    }

    public SiteName getSiteName() {
        return (SiteName)this.getExtension(SiteName.class);
    }

    public void setSiteName(SiteName siteName) {
        if (siteName == null) {
            this.removeExtension(SiteName.class);
        } else {
            this.setExtension((Extension)siteName);
        }
    }

    public boolean hasSiteName() {
        return this.hasExtension(SiteName.class);
    }

    public Theme getTheme() {
        return (Theme)this.getExtension(Theme.class);
    }

    public void setTheme(Theme theme) {
        if (theme == null) {
            this.removeExtension(Theme.class);
        } else {
            this.setExtension((Extension)theme);
        }
    }

    public boolean hasTheme() {
        return this.hasExtension(Theme.class);
    }

    public Link getEntryPostLink() {
        return this.getLink("http://schemas.google.com/g/2005#post", ILink.Type.ATOM);
    }

    public Link getSourceLink() {
        return this.getLink("http://schemas.google.com/sites/2008#source", ILink.Type.ATOM);
    }

    public List<Link> getWebAddressMappingLinks() {
        return this.getLinks("http://schemas.google.com/sites/2008#webAddressMapping", ILink.Type.HTML);
    }

    protected void validate() {
    }

    public String toString() {
        return "{SiteEntry " + super.toString() + "}";
    }
}

