/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.events.impl;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.events.XMLEventInitializer;

public class DefaultXMLEventInitializer
implements XMLEventInitializer {
    private static Logger LOGGER = Logger.getLogger(DefaultXMLEventInitializer.class);
    private static final short EVENT_BUBBLES = 0;
    private static final short EVENT_CANCELABLE = 1;
    private static final short EVENT_CONTEXT = 2;
    private static final HashMap INITIALIZATION_RULES = new HashMap();

    public void initXMLEvent(XMLEvent event, String type, boolean bubbles, boolean cancelable, Object context) {
        boolean[] rules = (boolean[])INITIALIZATION_RULES.get(type);
        if (rules != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("initializing event " + type + " from rule: bubbles=" + rules[0] + ", cancelable=" + rules[1] + ", context=" + (rules[2] ? "yes" : "no")));
            }
            event.initXMLEvent(type, rules[0], rules[1], rules[2] ? context : null);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("initializing event " + type + " from parameters: bubbles=" + bubbles + ", cancelable=" + cancelable + ", context=" + (context != null ? "yes" : "no")));
            }
            event.initXMLEvent(type, bubbles, cancelable, context);
        }
    }

    static {
        INITIALIZATION_RULES.put("xforms-model-construct", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-model-construct-done", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-ready", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-model-destruct", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-previous", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-next", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-focus", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-help", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-hint", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-rebuild", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-refresh", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-revalidate", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-recalculate", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-reset", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-submit", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("DOMActivate", new boolean[]{true, true, false});
        INITIALIZATION_RULES.put("xforms-value-changed", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-select", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-deselect", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-scroll-first", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-scroll-last", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-insert", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-delete", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-valid", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-invalid", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("DOMFocusIn", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("DOMFocusOut", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-readonly", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-readwrite", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-required", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-optional", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-enabled", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-disabled", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-in-range", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-out-of-range", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-submit-done", new boolean[]{true, false, false});
        INITIALIZATION_RULES.put("xforms-submit-error", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-binding-exception", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-link-exception", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-link-error", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("xforms-compute-exception", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-load-uri", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-render-message", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-replace-all", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-state-changed", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-node-inserted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-node-deleted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-prototype-cloned", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-id-generated", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-item-inserted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-item-deleted", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-index-changed", new boolean[]{true, false, true});
        INITIALIZATION_RULES.put("chiba-switch-toggled", new boolean[]{true, false, true});
    }
}

