/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms;

import org.apache.xerces.dom.ElementImpl;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.CustomElementFactory;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.XFormsElementFactory;
import org.chiba.xml.xforms.action.AbstractAction;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.BindingResolver;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractUIElement;
import org.chiba.xml.xpath.XPathReferenceFinder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;

public class Initializer {
    private Initializer() {
    }

    public static void initializeActionElements(Model model, Element element) throws XFormsException {
        Initializer.initializeActionElements(model, element, null);
    }

    public static void initializeActionElements(Model model, Element element, String repeatItemId) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            ElementImpl elementImpl;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !XFormsElementFactory.isActionElement((Element)(elementImpl = (ElementImpl)node))) continue;
            Model contextModel = Initializer.getContextModel(model, (Element)elementImpl);
            AbstractAction actionElement = (AbstractAction)elementFactory.createXFormsElement((Element)elementImpl, contextModel);
            if (repeatItemId != null) {
                actionElement.setRepeatItemId(repeatItemId);
                actionElement.setGeneratedId(model.getContainer().generateId());
                actionElement.register();
            }
            actionElement.setRepeatItemId(repeatItemId);
            actionElement.init();
        }
    }

    public static void initializeBindElements(Model model, Element element, XPathReferenceFinder referenceFinder) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            ElementImpl elementImpl;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !XFormsElementFactory.isBindElement((Element)(elementImpl = (ElementImpl)node))) continue;
            Bind bindElement = (Bind)elementFactory.createXFormsElement((Element)elementImpl, model);
            bindElement.setReferenceFinder(referenceFinder);
            bindElement.init();
        }
    }

    public static void initializeSubmissionElements(Model model, Element element) throws XFormsException {
        XFormsElementFactory elementFactory = model.getContainer().getElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            ElementImpl elementImpl;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1 || !XFormsElementFactory.isSubmissionElement((Element)(elementImpl = (ElementImpl)node))) continue;
            Submission submissionElement = (Submission)elementFactory.createXFormsElement((Element)elementImpl, model);
            submissionElement.init();
        }
    }

    public static void initializeUIElements(Element element) throws XFormsException {
        ElementImpl elementImpl = (ElementImpl)element.getOwnerDocument().getDocumentElement();
        Container container = (Container)elementImpl.getUserData();
        Initializer.initializeUIElements(container.getDefaultModel(), element, null);
    }

    public static void initializeUIElements(Model model, Element element, String repeatItemId) throws XFormsException {
        Container container = model.getContainer();
        XFormsElementFactory xformsFactory = container.getElementFactory();
        CustomElementFactory customFactory = container.getCustomElementFactory();
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Model contextModel;
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            ElementImpl elementImpl = (ElementImpl)node;
            if (XFormsElementFactory.isUIElement((Element)elementImpl)) {
                contextModel = Initializer.getContextModel(model, (Element)elementImpl);
                AbstractUIElement uiElement = (AbstractUIElement)xformsFactory.createXFormsElement((Element)elementImpl, contextModel);
                if (repeatItemId != null) {
                    uiElement.setRepeatItemId(repeatItemId);
                    uiElement.setGeneratedId(model.getContainer().generateId());
                    uiElement.register();
                }
                uiElement.init();
                continue;
            }
            if (customFactory.isCustomElement((Element)elementImpl)) {
                contextModel = Initializer.getContextModel(model, (Element)elementImpl);
                AbstractUIElement customElement = (AbstractUIElement)customFactory.createCustomXFormsElement((Element)elementImpl, contextModel);
                customElement.init();
                continue;
            }
            Initializer.initializeUIElements(model, (Element)elementImpl, repeatItemId);
        }
    }

    public static void updateUIElements(Element element) throws XFormsException {
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            ElementImpl elementImpl = (ElementImpl)node;
            Object userData = elementImpl.getUserData();
            if (userData != null && userData instanceof AbstractUIElement) {
                ((AbstractUIElement)userData).update();
                continue;
            }
            Initializer.updateUIElements((Element)elementImpl);
        }
    }

    public static void disposeUIElements(Element element) throws XFormsException {
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            ElementImpl elementImpl = (ElementImpl)node;
            Object userData = elementImpl.getUserData();
            if (userData != null && userData instanceof AbstractUIElement) {
                ((AbstractUIElement)userData).dispose();
                continue;
            }
            Initializer.disposeUIElements((Element)elementImpl);
        }
    }

    private static Model getContextModel(Model model, Element element) throws XFormsBindingException {
        String bindId = null;
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "bind")) {
            bindId = element.getAttributeNS("http://www.w3.org/2002/xforms", "bind");
        } else if (element.hasAttributeNS(null, "bind")) {
            bindId = element.getAttributeNS(null, "bind");
        } else if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-bind")) {
            bindId = element.getAttributeNS("http://www.w3.org/2002/xforms", "repeat-bind");
        }
        if (bindId != null) {
            XFormsElement xFormsElement = model.getContainer().lookup(bindId);
            if (xFormsElement == null) {
                throw new XFormsBindingException("bind '" + bindId + "' not found", (EventTarget)((Object)element), (Object)bindId);
            }
            if (!(xFormsElement instanceof Bind)) {
                throw new XFormsBindingException("element '" + bindId + "' is not a bind", (EventTarget)((Object)element), (Object)bindId);
            }
            return xFormsElement.getModel();
        }
        String modelId = null;
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "model")) {
            modelId = element.getAttributeNS("http://www.w3.org/2002/xforms", "model");
        } else if (element.hasAttributeNS(null, "model")) {
            modelId = element.getAttributeNS(null, "model");
        }
        if (BindingResolver.hasUIBinding(element) && modelId != null) {
            XFormsElement xFormsElement = model.getContainer().lookup(modelId);
            if (xFormsElement == null) {
                throw new XFormsBindingException("model '" + modelId + "' not found", (EventTarget)((Object)element), (Object)modelId);
            }
            if (!(xFormsElement instanceof Model)) {
                throw new XFormsBindingException("element '" + modelId + "' is not a model", (EventTarget)((Object)element), (Object)modelId);
            }
            return (Model)xFormsElement;
        }
        return model;
    }
}

