/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.http;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.connector.http.AbstractHTTPConnector;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Node;

public class HTTPSubmissionHandler
extends AbstractHTTPConnector
implements SubmissionHandler {
    private static final Logger LOGGER = Logger.getLogger(HTTPSubmissionHandler.class);

    public Map submit(Submission submission, Node instance) throws XFormsException {
        try {
            String method = submission.getMethod();
            String mediatype = "application/xml";
            if (submission.getMediatype() != null) {
                mediatype = submission.getMediatype();
            }
            String encoding = submission.getEncoding();
            if (submission.getEncoding() == null) {
                encoding = this.getDefaultEncoding();
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.serialize(submission, instance, stream);
            if (method.equals("post")) {
                this.post(this.getURI(), stream.toString(encoding), mediatype + "; charset=" + encoding, encoding);
            } else if (method.equals("get")) {
                if (this.getURI().indexOf("?") == -1) {
                    this.get(this.getURI() + "?" + stream.toString(encoding));
                } else {
                    this.get(this.getURI() + "&" + stream.toString(encoding));
                }
            } else if (method.equals("put")) {
                this.put(this.getURI(), stream.toString(encoding), mediatype + "; charset=" + encoding, encoding);
            } else if (method.equals("multipart-post")) {
                String data = stream.toString(encoding);
                int i = data.indexOf("\n\n");
                if (i == -1) {
                    i = data.indexOf("\r\n\r\n");
                    if (i == -1) {
                        throw new XFormsException("serializer sent wrong multipart content.");
                    }
                    i += 2;
                }
                String contentType = null;
                StringTokenizer tok = new StringTokenizer(data.substring(0, i += 2).replaceAll("\r", "").replaceAll("\n ", " ").replaceAll("\n\t", " "));
                while (tok.hasMoreTokens()) {
                    String name = tok.nextToken("\n");
                    if (!name.toLowerCase().startsWith("content-type:")) continue;
                    contentType = name.substring("content-type:".length());
                    break;
                }
                this.post(this.getURI(), data.substring(i), contentType);
            } else if (method.equals("form-data-post")) {
                this.post(this.getURI(), stream.toString(encoding), "multipart/form-data; charset=" + encoding, encoding);
            } else if (method.equals("urlencoded-post")) {
                this.post(this.getURI(), stream.toString(encoding), "application/x-www-form-urlencoded; charset=" + encoding, encoding);
            } else {
                this.post(this.getURI(), stream.toString(encoding), mediatype + "; charset=" + encoding, encoding);
            }
            Map response = this.getResponseHeader();
            response.put("chiba.submission.response.stream", this.getResponseBody());
            return response;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }
}

