/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.constraints;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.xforms.constraints.DependencyGraph;
import org.chiba.xml.xforms.constraints.Vertex;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.exception.XFormsException;

public class MainDependencyGraph
extends DependencyGraph {
    protected static Logger LOGGER = Logger.getLogger(MainDependencyGraph.class);

    public Vector getVertices() {
        return this.vertices;
    }

    private void addReferredNodesToGraph(JXPathContext relativeContext, NodeImpl instanceNode, String expression, short property, Set references) throws XFormsException {
        Vertex vertex = this.addVertex(relativeContext, instanceNode, expression, property);
        boolean hadVertex = vertex.wasAlreadyInGraph;
        vertex.wasAlreadyInGraph = false;
        String xpath = vertex.getXPathExpression();
        if (xpath == null || xpath.length() == 0) {
            if (!hadVertex) {
                this.removeVertex(vertex);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("addReferredNodesToGraph: ignoring vertex " + vertex + " without xpath"));
            }
            return;
        }
        Vector refns = this.getXPathRefNodes(relativeContext, xpath, references);
        if (refns == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("addReferredNodesToGraph: ignoring vertex " + vertex + " without references"));
            }
            return;
        }
        if (refns.size() == 0) {
            vertex.compute();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addReferredNodesToGraph: processing vertex " + vertex + " with " + refns.size() + " references"));
        }
        Enumeration enumeration = refns.elements();
        while (enumeration.hasMoreElements()) {
            NodeImpl referencedNode = (NodeImpl)enumeration.nextElement();
            Vertex refVertex = this.addVertex(null, referencedNode, null, (short)1);
            this.addEdge(refVertex, vertex);
        }
    }

    public void buildBindGraph(Bind bind, Model model) throws XFormsException {
        Instance instance = model.getInstance(bind.getInstanceId());
        String locationPath = bind.getLocationPath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("buildBindGraph: building " + bind));
        }
        JXPathContext instanceContext = instance.getInstanceContext();
        Iterator iterator = instance.getPointerIterator(locationPath);
        while (iterator.hasNext()) {
            Pointer instancePointer = (Pointer)iterator.next();
            JXPathContext relativeContext = instanceContext.getRelativeContext(instancePointer);
            relativeContext.setFunctions(instanceContext.getFunctions());
            String s = instancePointer.asPath();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("buildBindGraph: processing " + s));
            }
            ModelItem modelItem = instance.getModelItem(s);
            NodeImpl node = (NodeImpl)modelItem.getNode();
            String property = bind.getCalculate();
            if (property != null) {
                modelItem.getDeclarationView().setCalculate(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)1, bind.getCalculateReferences());
            }
            if ((property = bind.getRelevant()) != null) {
                modelItem.getDeclarationView().setRelevant(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)2, bind.getRelevantReferences());
            }
            if ((property = bind.getReadonly()) != null) {
                modelItem.getDeclarationView().setReadonly(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)3, bind.getReadonlyReferences());
            }
            if ((property = bind.getRequired()) != null) {
                modelItem.getDeclarationView().setRequired(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)4, bind.getRequiredReferences());
            }
            if ((property = bind.getConstraint()) != null) {
                modelItem.getDeclarationView().setConstraint(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)5, bind.getConstraintReferences());
            }
            if ((property = bind.getDatatype()) != null) {
                modelItem.getDeclarationView().setDatatype(property);
            }
            if ((property = bind.getP3PType()) == null) continue;
            modelItem.getDeclarationView().setP3PType(property);
        }
    }
}

