/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSTypeDefinition;
import org.chiba.xml.events.DefaultAction;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.config.XFormsConfigException;
import org.chiba.xml.xforms.connector.ConnectorFactory;
import org.chiba.xml.xforms.constraints.MainDependencyGraph;
import org.chiba.xml.xforms.constraints.SubGraph;
import org.chiba.xml.xforms.constraints.Vertex;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.UpdateHandler;
import org.chiba.xml.xforms.core.UpdateSequencer;
import org.chiba.xml.xforms.core.Validator;
import org.chiba.xml.xforms.exception.XFormsComputeException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.exception.XFormsLinkException;
import org.chiba.xml.xpath.XPathUtil;
import org.chiba.xml.xpath.impl.JXPathReferenceFinderImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.events.Event;
import org.w3c.dom.ls.LSInput;
import org.w3c.xforms.XFormsModelElement;

public class Model
extends XFormsElement
implements XFormsModelElement,
DefaultAction {
    private static Logger LOGGER = Logger.getLogger(Model.class);
    private List instances;
    private List modelBindings;
    private MainDependencyGraph mainGraph;
    private Validator validator;
    private Vector changed = new Vector();
    private List schemas = new ArrayList();
    private boolean ready;
    private UpdateHandler updateHandler;
    private UpdateSequencer updateSequencer;
    private int modelItemCounter = 0;

    public Model(Element element) {
        super(element);
    }

    public boolean isReady() {
        return this.ready;
    }

    public Vector getChanged() {
        return this.changed;
    }

    public Container getContainer() {
        return this.container;
    }

    public Instance getDefaultInstance() {
        if (this.instances.size() > 0) {
            return (Instance)this.instances.get(0);
        }
        return null;
    }

    public Instance getInstance(String id) {
        if (id == null || "".equals(id)) {
            return this.getDefaultInstance();
        }
        int index = 0;
        while (index < this.instances.size()) {
            Instance instance = (Instance)this.instances.get(index);
            if (id.equals(instance.getId())) {
                return instance;
            }
            ++index;
        }
        return null;
    }

    public String computeInstanceId(String path) {
        if (path == null) {
            return null;
        }
        String expression = XPathUtil.getInstanceParameter(path);
        if (expression != null) {
            String value = (String)this.getDefaultInstance().getInstanceContext().getValue(expression, String.class);
            String realId = null;
            Instance instance = this.getInstance(value);
            if (instance != null) {
                realId = instance.getId();
            }
            return realId;
        }
        return this.getDefaultInstance().getId();
    }

    public MainDependencyGraph getMainGraph() {
        return this.mainGraph;
    }

    public Model getModel() {
        return this;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.validator = new Validator();
            this.validator.setModel(this);
        }
        return this.validator;
    }

    public List getSchemas() {
        return this.schemas;
    }

    public void addChanged(NodeImpl changedNode) {
        if (this.mainGraph != null) {
            Vertex vertex;
            if (this.changed == null) {
                this.changed = new Vector();
            }
            if ((vertex = this.mainGraph.getVertex(changedNode, (short)1)) != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " add changed: adding calculate vertex for " + changedNode));
                }
                this.changed.add(vertex);
            }
        }
    }

    public Instance addInstance(String id) throws XFormsException {
        Element instanceNode = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2002/xforms", String.valueOf(this.xformsPrefix) + ":" + "instance");
        String realId = id;
        if (realId == null || realId.length() == 0) {
            realId = this.container.generateId();
        }
        instanceNode.setAttributeNS(null, "id", realId);
        instanceNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        this.element.appendChild(instanceNode);
        this.createInstanceObject(instanceNode);
        return this.getInstance(id);
    }

    public void addModelBinding(Bind bind) {
        if (this.modelBindings == null) {
            this.modelBindings = new ArrayList();
        }
        this.modelBindings.add(bind);
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public void setUpdateHandler(UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    public String generateModelItemId() {
        return String.valueOf(++this.modelItemCounter);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.updateSequencer = new UpdateSequencer(this);
        this.initializeDefaultAction();
        this.initializeExtensionFunctions();
        Initializer.initializeActionElements(this, this.element);
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-model-construct", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-model-construct-done", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-ready", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-refresh", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-revalidate", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-recalculate", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-rebuild", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-reset", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-link-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-link-error", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-compute-exception", this);
    }

    protected void initializeExtensionFunctions() throws XFormsComputeException {
        String functions = this.getXFormsAttribute("functions");
        if (functions != null && !functions.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(functions);
            while (tokenizer.hasMoreTokens()) {
                String qname = tokenizer.nextToken();
                String prefix = qname.substring(0, qname.indexOf(":"));
                String localName = qname.substring(qname.indexOf(":") + 1);
                String[] functionInfo = new String[]{""};
                if (functionInfo == null) continue;
                try {
                    String uri = NamespaceResolver.getNamespaceURI(this.element, prefix);
                    functionInfo = Config.getInstance().getExtensionFunction(uri, localName);
                    if (functionInfo != null) {
                        Class.forName(functionInfo[0]);
                        continue;
                    }
                    throw new XFormsComputeException("Function '" + localName + "' cannot be found in Namespace '" + uri + "'", this.target, null);
                }
                catch (ClassNotFoundException e) {
                    throw new XFormsComputeException("Class containing Function cannot be found ", this.target, null);
                }
                catch (XFormsConfigException e) {
                    throw new XFormsComputeException("Configuration Problem - check default.xml ", this.target, null);
                }
            }
        }
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-model-construct", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-model-construct-done", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-ready", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-refresh", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-revalidate", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-recalculate", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-rebuild", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-reset", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-link-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-link-error", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-compute-exception", this);
    }

    public Document getInstanceDocument(String instanceID) throws DOMException {
        Instance instance = this.getInstance(instanceID);
        if (instance == null) {
            throw new DOMException(8, instanceID);
        }
        return instance.getInstanceDocument();
    }

    public void rebuild() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " rebuild"));
        }
        try {
            if (this.updateSequencer.sequence("rebuild")) {
                return;
            }
            if (this.modelBindings != null && this.modelBindings.size() > 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " rebuild: creating main dependency graph for " + this.modelBindings.size() + " bind(s)"));
                }
                this.mainGraph = new MainDependencyGraph();
                int index = 0;
                while (index < this.modelBindings.size()) {
                    Bind bind = (Bind)this.modelBindings.get(index);
                    this.mainGraph.buildBindGraph(bind, this);
                    ++index;
                }
                this.changed = (Vector)this.mainGraph.getVertices().clone();
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    public void recalculate() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " recalculate"));
        }
        try {
            if (this.updateSequencer.sequence("recalculate")) {
                return;
            }
            if (this.changed != null && this.changed.size() > 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " recalculate: creating sub dependency graph for " + this.changed.size() + " node(s)"));
                }
                SubGraph subGraph = new SubGraph();
                subGraph.constructSubDependencyGraph(this.changed);
                subGraph.recalculate();
                this.changed.clear();
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    public void revalidate() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " revalidate"));
        }
        try {
            if (this.updateSequencer.sequence("revalidate")) {
                return;
            }
            if (this.instances != null && this.instances.size() > 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " revalidate: revalidating " + this.instances.size() + " instance(s)"));
                }
                int index = 0;
                while (index < this.instances.size()) {
                    this.getValidator().validate((Instance)this.instances.get(index));
                    ++index;
                }
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    public void refresh() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " refresh"));
        }
        try {
            if (this.updateSequencer.sequence("refresh")) {
                return;
            }
            Initializer.updateUIElements(this.container.getDocument().getDocumentElement());
            if (this.instances != null) {
                int index = 0;
                while (index < this.instances.size()) {
                    Instance instance = (Instance)this.instances.get(index);
                    Iterator iterator = instance.iterateModelItems();
                    while (iterator.hasNext()) {
                        ModelItem modelItem = (ModelItem)iterator.next();
                        modelItem.getStateChangeView().reset();
                    }
                    ++index;
                }
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void performDefault(Event event) {
        try {
            if (event.getType().equals("xforms-model-construct")) {
                this.modelConstruct();
                return;
            }
            if (event.getType().equals("xforms-model-construct-done")) {
                this.modelConstructDone();
                return;
            }
            if (event.getType().equals("xforms-ready")) {
                this.ready();
                return;
            }
            if (event.getType().equals("xforms-refresh")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.refresh();
                return;
            }
            if (event.getType().equals("xforms-revalidate")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.revalidate();
                return;
            }
            if (event.getType().equals("xforms-recalculate")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.recalculate();
                return;
            }
            if (event.getType().equals("xforms-rebuild")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.rebuild();
                return;
            }
            if (event.getType().equals("xforms-reset")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.reset();
                return;
            }
            if (event.getType().equals("xforms-binding-exception")) {
                this.getLogger().error((Object)(this + " binding exception: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
            if (event.getType().equals("xforms-link-exception")) {
                this.getLogger().error((Object)(this + " link exception: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
            if (event.getType().equals("xforms-link-error")) {
                this.getLogger().warn((Object)(this + " link error: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
            if (event.getType().equals("xforms-compute-exception")) {
                this.getLogger().error((Object)(this + " compute exception: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.stopPropagation();
        }
    }

    private void modelConstruct() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " model construct"));
        }
        this.loadDefaultSchema(this.schemas);
        this.loadLinkedSchemas(this.schemas);
        this.loadInlineSchemas(this.schemas);
        this.getValidator().setDatatypes(this.getNamedDatatypes(this.schemas));
        this.instances = new ArrayList();
        NodeList nl = this.getElement().getElementsByTagNameNS("http://www.w3.org/2002/xforms", "instance");
        int count = nl.getLength();
        int index = 0;
        while (index < count) {
            Element xformsInstance = (Element)nl.item(index);
            this.createInstanceObject(xformsInstance);
            ++index;
        }
        Initializer.initializeBindElements(this, this.element, new JXPathReferenceFinderImpl());
        Initializer.initializeSubmissionElements(this, this.element);
        this.container.dispatch(this.target, "xforms-rebuild", null);
        this.container.dispatch(this.target, "xforms-recalculate", null);
        this.container.dispatch(this.target, "xforms-revalidate", null);
    }

    private void createInstanceObject(Element xformsInstance) throws XFormsException {
        Instance instance = (Instance)this.container.getElementFactory().createXFormsElement(xformsInstance, this);
        instance.init();
        this.instances.add(instance);
    }

    private void modelConstructDone() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " model construct done"));
        }
        if (this.getContainer().isModelConstructDone()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " model construct done: already performed"));
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " model construct done: starting ui initialization"));
            }
            Initializer.initializeUIElements(this.container.getDocument().getDocumentElement());
        }
    }

    private void ready() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " ready"));
        }
        if (this.instances != null) {
            int index = 0;
            while (index < this.instances.size()) {
                Instance instance = (Instance)this.instances.get(index);
                instance.storeInitialInstance();
                Iterator iterator = instance.iterateModelItems();
                while (iterator.hasNext()) {
                    ModelItem modelItem = (ModelItem)iterator.next();
                    modelItem.getStateChangeView().reset();
                }
                ++index;
            }
        }
        this.ready = true;
    }

    private void reset() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " reset"));
        }
        if (this.instances != null && this.instances.size() > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " reset: resetting " + this.instances.size() + " instance(s)"));
            }
            int index = 0;
            while (index < this.instances.size()) {
                Instance instance = (Instance)this.instances.get(index);
                instance.reset();
                ++index;
            }
        }
        this.container.dispatch(this.target, "xforms-rebuild", null);
        this.container.dispatch(this.target, "xforms-recalculate", null);
        this.container.dispatch(this.target, "xforms-revalidate", null);
        this.container.dispatch(this.target, "xforms-refresh", null);
    }

    private void loadDefaultSchema(List list) throws XFormsException {
        try {
            InputStream stream = Config.class.getResourceAsStream("/org/chiba/xml/xforms/config/XFormsDatatypes.xsd");
            XSModel schema = this.loadSchema(stream);
            if (schema == null) {
                throw new NullPointerException("resource not found");
            }
            list.add(schema);
        }
        catch (Exception e) {
            throw new XFormsLinkException("could not load default schema", e, this.target, null);
        }
    }

    private void loadLinkedSchemas(List list) throws XFormsException {
        String schemaURI = null;
        try {
            String schemaAttribute = this.getXFormsAttribute("schema");
            if (schemaAttribute != null) {
                StringTokenizer tokenizer = new StringTokenizer(schemaAttribute, " ");
                XSModel schema = null;
                while (tokenizer.hasMoreTokens()) {
                    schemaURI = tokenizer.nextToken();
                    if (schemaURI.startsWith("#")) {
                        String id = schemaURI.substring(1);
                        Pointer pointer = this.container.getRootContext().getPointer("//*[@id='" + id + "']");
                        Element element = (Element)pointer.getNode();
                        schema = this.loadSchema(element);
                    } else {
                        schema = this.loadSchema(schemaURI);
                    }
                    if (schema == null) {
                        throw new NullPointerException("resource not found");
                    }
                    list.add(schema);
                }
            }
        }
        catch (Exception e) {
            throw new XFormsLinkException("could not load linked schema", this.target, schemaURI);
        }
    }

    private void loadInlineSchemas(List list) throws XFormsException {
        String schemaId = null;
        try {
            NodeList children = this.element.getChildNodes();
            int index = 0;
            while (index < children.getLength()) {
                Node child = children.item(index);
                if (1 == child.getNodeType() && "http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI())) {
                    Element element = (Element)child;
                    schemaId = element.hasAttributeNS(null, "id") ? element.getAttributeNS(null, "id") : element.getNodeName();
                    XSModel schema = this.loadSchema(element);
                    if (schema == null) {
                        throw new NullPointerException("resource not found");
                    }
                    list.add(schema);
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new XFormsLinkException("could not load inline schema", e, this.target, schemaId);
        }
    }

    public Map getNamedDatatypes(List schemas) {
        HashMap<String, XSTypeDefinition> datatypes = new HashMap<String, XSTypeDefinition>();
        for (XSModel schema : schemas) {
            XSNamedMap definitions = schema.getComponents((short)3);
            int index = 0;
            while (index < definitions.getLength()) {
                XSTypeDefinition type = (XSTypeDefinition)definitions.item(index);
                if (type.getTypeCategory() == 16 && !type.getAnonymous() && this.getValidator().isSupported(type.getName())) {
                    String name = type.getName();
                    int separator = name.indexOf(58);
                    String localName = separator > -1 ? name.substring(separator + 1) : name;
                    String namespaceURI = type.getNamespace();
                    String expandedName = NamespaceResolver.expand(namespaceURI, localName);
                    if ("http://www.w3.org/2002/xforms".equals(namespaceURI) || "http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                        datatypes.put(localName, type);
                    }
                    datatypes.put(expandedName, type);
                }
                ++index;
            }
        }
        return datatypes;
    }

    public String getTargetNamespace(XSModel xsModel) {
        String namespace = xsModel.getComponents((short)3).item(0).getNamespace();
        return namespace;
    }

    private XSModel loadSchema(String uri) throws XFormsException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        ConnectorFactory connectorFactory = this.container.getConnectorFactory();
        URI absoluteURI = connectorFactory.getAbsoluteURI(uri, this.element);
        return this.getSchemaLoader().loadURI(absoluteURI.toString());
    }

    private XSModel loadSchema(InputStream stream) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        DOMInputImpl input = new DOMInputImpl();
        input.setByteStream(stream);
        return this.getSchemaLoader().load((LSInput)input);
    }

    private XSModel loadSchema(Element element) throws TransformerException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Element copy = (Element)element.cloneNode(true);
        NamespaceResolver.applyNamespaces(element, copy);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(copy), new StreamResult(stream));
        byte[] array = stream.toByteArray();
        return this.loadSchema(new ByteArrayInputStream(array));
    }

    private XSLoader getSchemaLoader() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation implementation = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        XSLoader loader = implementation.createXSLoader(null);
        return loader;
    }
}

