/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.chiba.xml.events.DefaultAction;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.UpdateHandler;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.chiba.xml.xforms.ui.UIElementState;
import org.chiba.xml.xforms.ui.state.BoundElementState;
import org.chiba.xml.xforms.ui.state.UIElementStateUtil;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public abstract class AbstractFormControl
extends BoundElement
implements DefaultAction {
    public AbstractFormControl(Element element, Model model) {
        super(element, model);
    }

    public abstract void setValue(String var1) throws XFormsException;

    public String getValue() {
        if (this.elementState != null) {
            return this.elementState.getValue();
        }
        return null;
    }

    public String getDatatype() {
        ModelItem modelItem;
        if (this.isBound() && (modelItem = this.model.getInstance(this.getInstanceId()).getModelItem(this.getLocationPath())) != null) {
            return UIElementStateUtil.getDatatype(modelItem, this.element);
        }
        return null;
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeElementState();
        this.initializeChildren();
        this.initializeActions();
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-previous", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-next", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-focus", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-help", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-hint", this);
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-previous", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-next", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-focus", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-help", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-hint", this);
    }

    protected UIElementState createElementState() throws XFormsException {
        return this.isBound() ? new BoundElementState() : null;
    }

    protected void dispatchValueChangeSequence() throws XFormsException {
        UpdateHandler updateHandler;
        if (this.elementState != null) {
            this.elementState.setProperty("dispatchValueChange", Boolean.FALSE);
        }
        if ((updateHandler = this.model.getUpdateHandler()) == null) {
            this.container.dispatch(this.model.getTarget(), "xforms-recalculate", null);
            this.container.dispatch(this.model.getTarget(), "xforms-revalidate", null);
            this.container.dispatch(this.model.getTarget(), "xforms-refresh", null);
        } else {
            updateHandler.doRecalculate(true);
            updateHandler.doRevalidate(true);
            updateHandler.doRefresh(true);
        }
        if (this.elementState != null) {
            this.elementState.setProperty("dispatchValueChange", Boolean.TRUE);
        }
    }

    public void performDefault(Event event) {
        super.performDefault(event);
        if (this.isCancelled(event)) {
            this.getLogger().debug((Object)(this + " event " + event.getType() + " cancelled"));
            return;
        }
        if (event.getType().equals("xforms-previous")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-next")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-focus")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-help")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-hint")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
    }
}

