/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.chiba.xml.events.DefaultAction;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.xforms.core.Bind;
import org.chiba.xml.xforms.core.Binding;
import org.chiba.xml.xforms.core.BindingResolver;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractUIElement;
import org.chiba.xml.xforms.ui.UIElementState;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public abstract class BoundElement
extends AbstractUIElement
implements Binding,
DefaultAction {
    protected String instanceId = null;
    protected String locationPath = null;
    protected UIElementState elementState = null;

    public BoundElement(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeElementState();
        this.initializeChildren();
    }

    public void update() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateElementState();
        this.updateChildren();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSelf();
    }

    public String getBindingExpression() {
        return this.getXFormsAttribute("ref");
    }

    public String getBindingId() {
        Bind bind = this.getModelBinding();
        if (bind != null) {
            return bind.getId();
        }
        return this.id;
    }

    public Binding getEnclosingBinding() {
        return BindingResolver.getEnclosingBinding(this);
    }

    public String getLocationPath() {
        if (!this.isBound()) {
            return null;
        }
        if (this.isRepeated()) {
            return BindingResolver.getExpressionPath(this, this.getRepeatItemId());
        }
        if (this.locationPath == null) {
            this.locationPath = BindingResolver.getExpressionPath(this, null);
        }
        return this.locationPath;
    }

    public String getModelId() {
        return this.model.getId();
    }

    public void performDefault(Event event) {
        if (event.getType().equals("xforms-binding-exception")) {
            this.getLogger().error((Object)(this + " binding exception: " + ((XMLEvent)event).getContextInfo()));
            return;
        }
    }

    public boolean isBound() {
        return this.hasModelBinding() || this.hasUIBinding();
    }

    public String getInstanceId() {
        if (this.instanceId == null) {
            this.instanceId = this.model.computeInstanceId(this.getLocationPath());
        }
        return this.instanceId;
    }

    public String getInstanceValue() {
        Instance instance = this.model.getInstance(this.getInstanceId());
        return (String)instance.getInstanceContext().getValue(this.getLocationPath());
    }

    protected boolean hasUIBinding() {
        return this.getXFormsAttribute("ref") != null;
    }

    protected boolean hasModelBinding() {
        return this.getXFormsAttribute("bind") != null;
    }

    protected Bind getModelBinding() {
        String bindAttribute = this.getXFormsAttribute("bind");
        if (bindAttribute != null) {
            return (Bind)this.container.lookup(bindAttribute);
        }
        return null;
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
    }

    protected final void initializeInstanceNode() throws XFormsException {
        if (this.isBound()) {
            String locationPath;
            String instanceId = this.getInstanceId();
            Instance instance = this.getModel().getInstance(instanceId);
            if (instance == null) {
                instance = this.model.addInstance(instanceId);
            }
            if (!instance.existsNode(locationPath = this.getLocationPath()) && !instance.hasInitialInstance()) {
                if (locationPath.startsWith("/*[1]")) {
                    locationPath = locationPath.substring("/*[1]".length());
                    locationPath = "/instanceData" + locationPath;
                }
                instance.createNode(locationPath);
            }
        }
    }

    protected final void initializeElementState() throws XFormsException {
        this.elementState = this.createElementState();
        if (this.elementState != null) {
            this.elementState.setOwner(this);
            this.elementState.init();
        }
    }

    protected final void updateElementState() throws XFormsException {
        if (this.elementState != null) {
            this.elementState.update();
        }
    }

    protected final void disposeElementState() throws XFormsException {
        if (this.elementState != null) {
            this.elementState.dispose();
            this.elementState = null;
        }
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
    }

    protected abstract UIElementState createElementState() throws XFormsException;
}

