/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.log4j.Logger;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.xforms.Initializer;
import org.chiba.xml.xforms.core.Binding;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractUIElement;
import org.chiba.xml.xforms.ui.Itemset;
import org.w3c.dom.Element;

public class Item
extends AbstractUIElement
implements Binding {
    private static final Logger LOGGER = Logger.getLogger(Item.class);
    private int position;
    private Itemset itemset;

    public Item(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        if (this.getXFormsAttribute("selected") == null) {
            this.element.setAttributeNS(null, "selected", String.valueOf(false));
        }
        if (this.itemset != null) {
            Initializer.initializeUIElements(this.model, this.element, this.id);
            Initializer.initializeActionElements(this.model, this.element, this.id);
            return;
        }
        this.initializeChildren();
        this.initializeActions();
    }

    public void update() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateChildren();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeChildren();
        this.disposeSelf();
    }

    public String getBindingExpression() {
        if (this.itemset != null) {
            return this.itemset.getBindingExpression() + "[" + this.getPosition() + "]";
        }
        return null;
    }

    public String getBindingId() {
        if (this.itemset != null) {
            return this.itemset.getBindingId();
        }
        return null;
    }

    public Binding getEnclosingBinding() {
        if (this.itemset != null) {
            return this.itemset.getEnclosingBinding();
        }
        return null;
    }

    public String getLocationPath() {
        if (this.itemset != null) {
            return this.itemset.getLocationPath() + "[" + this.getPosition() + "]";
        }
        return null;
    }

    public String getModelId() {
        if (this.itemset != null) {
            return this.itemset.getModelId();
        }
        return null;
    }

    public boolean isSelected() {
        String selectedAttribute = this.getXFormsAttribute("selected");
        return "true".equals(selectedAttribute);
    }

    public void select() {
        this.element.setAttributeNS(null, "selected", String.valueOf(true));
        if (this.itemset != null) {
            // empty if block
        }
    }

    public void deselect() {
        this.element.setAttributeNS(null, "selected", String.valueOf(false));
        if (this.itemset != null) {
            // empty if block
        }
    }

    public String getValue() {
        Element value = DOMUtil.findFirstChildNS(this.element, "http://www.w3.org/2002/xforms", "value");
        if (value != null) {
            return DOMUtil.getTextNodeAsString(value);
        }
        return null;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Itemset getItemset() {
        return this.itemset;
    }

    public void setItemset(Itemset itemset) {
        this.itemset = itemset;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

