/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.xpath;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.functions.MethodFunction;
import org.apache.commons.jxpath.util.MethodLookupUtils;
import org.apache.log4j.Logger;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.xpath.CoreExtensionFunctions;
import org.chiba.xml.xforms.xpath.XFormsExtensionFunctions;
import org.w3c.dom.Element;

public class ExtensionFunctions
implements Functions {
    private static Logger LOGGER = Logger.getLogger(ExtensionFunctions.class);
    private Element namespaceContext = null;
    private Set namespaces = new HashSet();

    public void setNamespaceContext(Element namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public Set getUsedNamespaces() {
        return this.namespaces;
    }

    public Function getFunction(String prefix, String name, Object[] parameters) {
        MethodFunction methodFunction;
        String uri = null;
        if (prefix != null) {
            uri = NamespaceResolver.getNamespaceURI(this.namespaceContext, prefix);
            this.namespaces.add(uri);
        }
        if (uri == null || "http://www.w3.org/2002/xforms".equals(uri)) {
            Class<XFormsExtensionFunctions> clazz = XFormsExtensionFunctions.class;
            if (name.equals("if")) {
                return this.getMethodFunction(clazz, "IF", parameters);
            }
            if (name.indexOf(45) > -1) {
                return this.getMethodFunction(clazz, name.replace('-', '_'), parameters);
            }
            return this.getMethodFunction(clazz, name, parameters);
        }
        if ("http://chiba.sourceforge.net/xforms".equals(uri) && (methodFunction = this.getMethodFunction(CoreExtensionFunctions.class, name, parameters)) != null) {
            return methodFunction;
        }
        try {
            String[] functionInfo = Config.getInstance().getExtensionFunction(uri == null ? prefix : uri, name);
            if (functionInfo != null) {
                Class<?> clazz = Class.forName(functionInfo[0]);
                MethodFunction function = this.getMethodFunction(clazz, functionInfo[1], parameters);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("functionInfo:: function name: " + functionInfo[1] + ":: java class: " + functionInfo[0]));
                    for (int i = 0; i < parameters.length; ++i) {
                        LOGGER.debug((Object)("parameter: " + parameters[i]));
                    }
                }
                if (function != null) {
                    return function;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("An error occured while loading XPath extension function: " + prefix + ":" + name));
        }
        return null;
    }

    private MethodFunction getMethodFunction(Class clazz, String name, Object[] parameters) {
        Method method = MethodLookupUtils.lookupStaticMethod((Class)clazz, (String)name, (Object[])parameters);
        if (method != null) {
            return new MethodFunction(method);
        }
        return null;
    }
}

