/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xslt.impl;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.chiba.xml.xslt.TransformerService;
import org.chiba.xml.xslt.impl.Resource;
import org.chiba.xml.xslt.impl.ResourceResolver;

public class CachingTransformerService
implements TransformerService,
URIResolver {
    private static final Logger LOGGER = Logger.getLogger(CachingTransformerService.class);
    private HashMap resources = new HashMap();
    private ArrayList resolvers = new ArrayList();
    private TransformerFactory transformerFactory;

    public CachingTransformerService() {
    }

    public CachingTransformerService(ResourceResolver resolver) {
        this();
        this.addResourceResolver(resolver);
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setURIResolver(this);
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory factory) {
        this.transformerFactory = factory;
        if (this.transformerFactory != null) {
            this.transformerFactory.setURIResolver(this);
        }
    }

    public Transformer getTransformer() throws TransformerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"get transformer: identity transformer");
        }
        return this.getTransformerFactory().newTransformer();
    }

    public Transformer getTransformer(URI uri) throws TransformerException {
        if (uri == null) {
            return this.getTransformer();
        }
        try {
            CacheEntry entry = (CacheEntry)this.resources.get(uri);
            if (entry == null || entry.isDirty()) {
                Resource resource;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("get transformer: cache " + (entry == null ? "miss" : "dirty") + " for " + uri));
                }
                if ((resource = this.load(uri)) == null) {
                    throw new IllegalArgumentException(uri.toString());
                }
                entry = this.sync(entry, resource);
                this.resources.put(uri, entry);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("get transformer: cache hit for " + uri));
            }
            if (entry.templates == null) {
                StreamSource source = new StreamSource(entry.resource.getInputStream());
                source.setSystemId(uri.toString());
                entry.templates = this.getTransformerFactory().newTemplates(source);
            }
            return entry.templates.newTransformer();
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    public Source resolve(String href, String base) throws TransformerException {
        try {
            URI uri;
            CacheEntry entry;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("resolve: " + href + " against " + base));
            }
            if ((entry = (CacheEntry)this.resources.get(uri = base != null ? new URI(base).resolve(href) : new URI(href))) == null || entry.isDirty()) {
                Resource resource;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("resolve: cache " + (entry == null ? "miss" : "dirty") + " for " + uri));
                }
                if ((resource = this.load(uri)) == null) {
                    return null;
                }
                entry = this.sync(entry, resource);
                this.resources.put(uri, entry);
                if (base != null) {
                    CacheEntry parent = (CacheEntry)this.resources.get(new URI(base));
                    parent.dependencies.add(entry);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("resolve: cache hit for " + uri));
            }
            StreamSource source = new StreamSource(entry.resource.getInputStream());
            source.setSystemId(uri.toString());
            return source;
        }
        catch (Exception e) {
            throw new TransformerException(e);
        }
    }

    public void addResourceResolver(ResourceResolver resolver) {
        this.resolvers.add(resolver);
    }

    public void removeResourceResolver(ResourceResolver resolver) {
        this.resolvers.remove(resolver);
    }

    private Resource load(URI uri) throws IOException {
        for (int i = 0; i < this.resolvers.size(); ++i) {
            ResourceResolver resolver = (ResourceResolver)this.resolvers.get(i);
            Resource resource = resolver.resolve(uri);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private CacheEntry sync(CacheEntry entry, Resource resource) {
        if (entry == null) {
            entry = new CacheEntry(resource.lastModified(), resource);
        } else {
            entry.lastModified = resource.lastModified();
            entry.resource = resource;
            entry.templates = null;
            entry.dependencies.clear();
        }
        return entry;
    }

    private static class CacheEntry {
        long lastModified;
        Resource resource;
        Templates templates;
        List dependencies;

        CacheEntry(long lastModified, Resource resource) {
            this.lastModified = lastModified;
            this.resource = resource;
            this.dependencies = new ArrayList();
        }

        boolean isDirty() {
            if (this.lastModified < this.resource.lastModified()) {
                return true;
            }
            for (int i = 0; i < this.dependencies.size(); ++i) {
                if (!((CacheEntry)this.dependencies.get(i)).isDirty()) continue;
                return true;
            }
            return false;
        }
    }
}

