/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.evaluator.doclib.action;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.evaluator.BaseEvaluator;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class GoogleDocsCheckInEvaluator
extends BaseEvaluator {
    private static final String ASPECT_CHECKEDOUT = "cm:checkedOut";
    private static final String ASPECT_GOOGLERESOURCE = "gd:googleResource";
    private static final String ASPECT_WORKINGCOPY = "cm:workingcopy";
    private static final String PROP_LOCKOWNER = "cm:lockOwner";
    private static final String PROP_WORKINGCOPYOWNER = "cm:workingCopyOwner";
    private static final String VALUE_GOOGLEDOCURL = "workingCopy.googleDocUrl";

    @Override
    public boolean evaluate(JSONObject jsonObject) {
        try {
            JSONArray nodeAspects = this.getNodeAspects(jsonObject);
            if (nodeAspects == null) {
                return false;
            }
            if (nodeAspects.contains((Object)ASPECT_GOOGLERESOURCE) && nodeAspects.contains((Object)ASPECT_WORKINGCOPY)) {
                return this.getMatchesCurrentUser(jsonObject, PROP_WORKINGCOPYOWNER);
            }
            if (nodeAspects.contains((Object)ASPECT_CHECKEDOUT) && this.getJSONValue(jsonObject, VALUE_GOOGLEDOCURL) != null) {
                return this.getMatchesCurrentUser(jsonObject, PROP_LOCKOWNER);
            }
        }
        catch (Exception err) {
            throw new AlfrescoRuntimeException("JSONException whilst running action evaluator: " + err.getMessage());
        }
        return false;
    }
}

