/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.extensibility;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.webscripts.ScriptRemote;
import org.springframework.extensions.webscripts.connector.Response;

public class SlingshotEvaluatorUtil {
    private static Log logger = LogFactory.getLog(SlingshotEvaluatorUtil.class);
    public static final String SITE_PRESET_CACHE = SlingshotEvaluatorUtil.class.getName() + ".sitePresets";
    protected static final String PORTLET_HOST = "portletHost";
    protected static final String PORTLET_URL = "portletUrl";
    protected static final String SITE_PRESET = "sitePreset";
    protected static final String SITE = "site";
    protected WebFrameworkServiceRegistry serviceRegistry = null;

    public void setServiceRegistry(WebFrameworkServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected String getEvaluatorParam(Map<String, String> params, String name, String defaultValue) {
        String value = params.get(name);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return defaultValue;
    }

    protected Boolean getPortletHost(RequestContext context) {
        Boolean portletHost = (Boolean)context.getAttribute(PORTLET_HOST);
        if (portletHost == null) {
            String portletHostParam = context.getParameter(PORTLET_HOST);
            portletHost = portletHostParam != null && portletHostParam.equalsIgnoreCase("true");
        }
        return portletHost;
    }

    protected String getPortletUrl(RequestContext context) {
        String portletUrl = (String)((Object)context.getAttribute(PORTLET_URL));
        if (portletUrl == null) {
            portletUrl = context.getParameter(PORTLET_URL);
        }
        return portletUrl;
    }

    public String getPageId(RequestContext context) {
        return context.getPageId();
    }

    protected String getSite(RequestContext context) {
        String site = (String)context.getUriTokens().get(SITE);
        if (site == null) {
            site = context.getParameter(SITE);
        }
        if (site == null) {
            String[] pathNames = context.getUri().substring(context.getContextPath().length()).split("/");
            for (int i = 0; i < pathNames.length; ++i) {
                if (!pathNames[i].equals(SITE) || i + 1 >= pathNames.length) continue;
                site = pathNames[i + 1];
                break;
            }
        }
        return site;
    }

    protected String getSitePreset(RequestContext context, String siteId) {
        String sitePresetId;
        block5: {
            HashMap<String, String> sitePresetCache = (HashMap<String, String>)context.getAttributes().get(SITE_PRESET_CACHE);
            if (sitePresetCache == null) {
                sitePresetCache = new HashMap<String, String>();
                context.getAttributes().put(SITE_PRESET_CACHE, sitePresetCache);
            }
            if ((sitePresetId = (String)sitePresetCache.get(siteId)) == null) {
                try {
                    JSONObject site = this.jsonGet("/api/sites/" + URLEncoder.encode(siteId));
                    if (site != null) {
                        sitePresetId = site.getString(SITE_PRESET);
                        sitePresetCache.put(siteId, sitePresetId);
                    }
                }
                catch (JSONException e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error((Object)"Could not get a sitePreset from site json.");
                }
            }
        }
        return sitePresetId;
    }

    private JSONObject jsonGet(String uri) {
        block3: {
            ScriptRemote scriptRemote = this.serviceRegistry.getScriptRemote();
            Response response = scriptRemote.connect().get(uri);
            if (response.getStatus().getCode() == 200) {
                try {
                    return new JSONObject(response.getResponse());
                }
                catch (JSONException e) {
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error((Object)("An error occurred when parsing response to json from the uri '" + uri + "': " + e.getMessage()));
                }
            }
        }
        return null;
    }
}

