/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.portlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLEncoder;

public class ProxyPortlet
implements Portlet {
    private static Log logger = LogFactory.getLog(ProxyPortlet.class);
    private static final String EDIT_URL = "editScriptUrl";
    private static final String VIEW_URL = "viewScriptUrl";
    private static final String SCRIPT_URL = "scriptUrl";
    private static final String PORTLET_URL = "portletUrl";
    private static final String PORTLET_HOST = "portletHost";
    private static final String MODE_PARAM_NAME = "mode";
    private static final String MODE_PARAM_VALUE_EDIT = "edit";
    private static final String MODE_PARAM_VALUE_VIEW = "view";
    private static final String UPDATED_PARAM_NAME = "updated";
    private static final String PREF_PARAM_NAME_PREFIX = "pref_";
    private static final String DEFAULT_VALUE = "[DEFAULT]";
    protected PortletConfig config;
    protected String editScriptUrl;
    protected String initScriptUrl;

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.editScriptUrl = config.getInitParameter(EDIT_URL);
        this.initScriptUrl = config.getInitParameter(VIEW_URL);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws PortletException, PortletSecurityException, IOException {
        if (req.getPortletMode() == PortletMode.EDIT) {
            boolean foundPref = false;
            PortletPreferences prefs = req.getPreferences();
            Map prefsMap = prefs.getMap();
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = req.getParameter(name);
                if (!prefsMap.containsKey(name) || value == null || value.equals(((String[])prefsMap.get(name))[0])) continue;
                prefs.setValue(name, value);
                foundPref = true;
            }
            if (foundPref) {
                prefs.store();
                req.setAttribute(UPDATED_PARAM_NAME, (Object)true);
            }
        }
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (paramName.equals(SCRIPT_URL)) continue;
            res.setRenderParameter(paramName, req.getParameter(paramName));
        }
        res.setRenderParameter(req.getWindowID() + SCRIPT_URL, req.getParameter(SCRIPT_URL));
    }

    public void render(RenderRequest req, RenderResponse res) throws PortletException, PortletSecurityException, IOException {
        PortletMode portletMode = req.getPortletMode();
        if (PortletMode.VIEW.equals((Object)portletMode)) {
            this.doView(req, res);
        } else if (PortletMode.EDIT.equals((Object)portletMode)) {
            this.doEdit(req, res);
        }
    }

    public void destroy() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doView(RenderRequest req, RenderResponse res) throws PortletException, PortletSecurityException, IOException {
        String scriptUrl = req.getParameter(req.getWindowID() + SCRIPT_URL);
        if (scriptUrl == null || scriptUrl.equals(this.editScriptUrl)) {
            scriptUrl = this.initScriptUrl;
            if (scriptUrl != null) {
                if (scriptUrl.indexOf("{") > -1) {
                    PortletPreferences prefs = req.getPreferences();
                    Map prefsMap = prefs.getMap();
                    Pattern p = Pattern.compile("\\{(\\w+)\\}");
                    Matcher m = p.matcher(scriptUrl);
                    boolean result = m.find();
                    if (result) {
                        StringBuffer sb = new StringBuffer();
                        do {
                            m.appendReplacement(sb, prefsMap.containsKey(m.group(1)) ? ((String[])prefsMap.get(m.group(1)))[0] : DEFAULT_VALUE);
                        } while (result = m.find());
                        m.appendTail(sb);
                        scriptUrl = sb.toString();
                    }
                    if (scriptUrl.indexOf(DEFAULT_VALUE) > -1) {
                        if (this.editScriptUrl == null) throw new PortletException("Required preferences missing and 'editScriptUrl' parameter has not been specified.");
                        scriptUrl = this.editScriptUrl;
                        req.setAttribute(MODE_PARAM_NAME, (Object)MODE_PARAM_VALUE_VIEW);
                    }
                }
            } else {
                String userId = req.getRemoteUser();
                if (userId == null) throw new PortletException("Initial 'scriptUrl' parameter has not been specified.");
                scriptUrl = "/page/user/" + URLEncoder.encode((String)userId) + "/dashboard";
            }
        }
        this.renderRequest(req, res, scriptUrl);
    }

    protected void doEdit(RenderRequest req, RenderResponse res) throws PortletException, PortletSecurityException, IOException {
        String scriptUrl = this.editScriptUrl;
        if (scriptUrl == null) {
            throw new PortletException("Initial 'editScriptUrl' parameter has not been specified.");
        }
        PortletPreferences prefs = req.getPreferences();
        Map prefsMap = prefs.getMap();
        for (Map.Entry pairs : prefsMap.entrySet()) {
            req.setAttribute(PREF_PARAM_NAME_PREFIX + pairs.getKey(), pairs.getValue());
        }
        req.setAttribute(MODE_PARAM_NAME, (Object)MODE_PARAM_VALUE_EDIT);
        this.renderRequest(req, res, scriptUrl);
    }

    protected void renderRequest(RenderRequest req, RenderResponse res, String scriptUrl) throws PortletException, PortletSecurityException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing portal render request " + req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + "/" + req.getContextPath() + " (scriptUrl=" + scriptUrl + ")"));
        }
        req.setAttribute(PORTLET_HOST, (Object)Boolean.TRUE);
        PortletURL actionUrl = res.createActionURL();
        actionUrl.setParameter(SCRIPT_URL, "$$scriptUrl$$");
        req.setAttribute(PORTLET_URL, (Object)actionUrl.toString());
        this.config.getPortletContext().getRequestDispatcher(scriptUrl).include(req, res);
    }
}

